/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Duration;
import com.axelor.apps.base.service.DurationService;
import com.axelor.i18n.I18n;
import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

@Singleton
public class DurationServiceImpl
implements DurationService {
    @Override
    public LocalDate computeDuration(Duration duration, LocalDate date) {
        if (duration == null) {
            return date;
        }
        switch (duration.getTypeSelect()) {
            case 1: {
                return date.plusMonths(duration.getValue().intValue());
            }
            case 2: {
                return date.plusDays(duration.getValue().intValue());
            }
        }
        return date;
    }

    @Override
    public BigDecimal computeRatio(LocalDate start, LocalDate end, Duration duration) {
        Preconditions.checkNotNull((Object)start, (Object)I18n.get((String)"You can't compute a duration ratio without start date."));
        Preconditions.checkNotNull((Object)end, (Object)I18n.get((String)"You can't compute a duration ratio without end date."));
        if (duration == null) {
            return BigDecimal.ONE;
        }
        end = end.plus(1L, ChronoUnit.DAYS);
        if (duration.getTypeSelect() == 1) {
            long months = ChronoUnit.MONTHS.between(start, end);
            LocalDate theoryEnd = start.plusMonths(months);
            long restDays = ChronoUnit.DAYS.between(theoryEnd, end);
            long daysInMonth = ChronoUnit.DAYS.between(theoryEnd, theoryEnd.plusMonths(1L));
            return BigDecimal.valueOf(months).add(BigDecimal.valueOf(restDays).divide(BigDecimal.valueOf(daysInMonth), MathContext.DECIMAL32)).divide(BigDecimal.valueOf(duration.getValue().intValue()), MathContext.DECIMAL32);
        }
        long restDays = ChronoUnit.DAYS.between(start, end);
        return BigDecimal.valueOf(restDays).divide(BigDecimal.valueOf(duration.getValue().intValue()), MathContext.DECIMAL32);
    }
}

