/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.message.service.MailServiceMessageImpl;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.mail.db.MailAddress;
import com.axelor.mail.db.MailFollower;
import com.axelor.mail.db.MailMessage;
import com.axelor.mail.db.repo.MailFollowerRepository;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MailServiceBaseImpl
extends MailServiceMessageImpl {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Model resolve(String email) {
        UserRepository users = (UserRepository)((Object)Beans.get(UserRepository.class));
        User user = (User)((Object)users.all().filter("self.partner.emailAddress.address = ?1", new Object[]{email}).fetchOne());
        if (user != null) {
            return user;
        }
        PartnerRepository partners = (PartnerRepository)((Object)Beans.get(PartnerRepository.class));
        Partner partner = (Partner)((Object)partners.all().filter("self.emailAddress.address = ?1", new Object[]{email}).fetchOne());
        if (partner != null) {
            return partner;
        }
        return super.resolve(email);
    }

    public List<InternetAddress> findEmails(String matching, List<String> selected, int maxResult) {
        ArrayList<String> selectedWithoutNull = new ArrayList<String>(selected);
        for (int i = 0; i < selected.size(); ++i) {
            if (!Strings.isNullOrEmpty((String)selected.get(i))) continue;
            selectedWithoutNull.remove(i);
        }
        ArrayList<String> where = new ArrayList<String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        where.add("((self.partner is not null AND self.partner.emailAddress is not null) OR (self.email is not null))");
        if (!StringUtils.isBlank((CharSequence)matching)) {
            where.add("(LOWER(self.partner.emailAddress.address) like LOWER(:email) OR LOWER(self.partner.fullName) like LOWER(:email) OR LOWER(self.email) like LOWER(:email) OR LOWER(self.name) like LOWER(:email))");
            params.put("email", "%" + matching + "%");
        }
        if (selectedWithoutNull != null && !selectedWithoutNull.isEmpty()) {
            where.add("self.partner.emailAddress.address not in (:selected)");
            params.put("selected", selectedWithoutNull);
        }
        String filter = Joiner.on((String)" AND ").join(where);
        Query query = Query.of(User.class);
        if (!StringUtils.isBlank((CharSequence)filter)) {
            query.filter(filter);
            query.bind(params);
        }
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
        for (User user : query.fetch(maxResult)) {
            try {
                InternetAddress item;
                if (user.getPartner() != null && user.getPartner().getEmailAddress() != null && !Strings.isNullOrEmpty((String)user.getPartner().getEmailAddress().getAddress())) {
                    item = new InternetAddress(user.getPartner().getEmailAddress().getAddress(), user.getFullName());
                    addresses.add(item);
                    selectedWithoutNull.add(user.getPartner().getEmailAddress().getAddress());
                    continue;
                }
                if (Strings.isNullOrEmpty((String)user.getEmail())) continue;
                item = new InternetAddress(user.getEmail(), user.getFullName());
                addresses.add(item);
                selectedWithoutNull.add(user.getEmail());
            }
            catch (UnsupportedEncodingException e) {
                TraceBackService.trace((Throwable)e);
            }
        }
        ArrayList<String> where2 = new ArrayList<String>();
        HashMap<String, Object> params2 = new HashMap<String, Object>();
        where2.add("self.emailAddress is not null");
        if (!StringUtils.isBlank((CharSequence)matching)) {
            where2.add("(LOWER(self.emailAddress.address) like LOWER(:email) OR LOWER(self.fullName) like LOWER(:email))");
            params2.put("email", "%" + matching + "%");
        }
        if (selectedWithoutNull != null && !selectedWithoutNull.isEmpty()) {
            where2.add("self.emailAddress.address not in (:selected)");
            params2.put("selected", selectedWithoutNull);
        }
        String filter2 = Joiner.on((String)" AND ").join(where2);
        Query query2 = Query.of(Partner.class);
        if (!StringUtils.isBlank((CharSequence)filter2)) {
            query2.filter(filter2);
            query2.bind(params2);
        }
        for (Partner partner : query2.fetch(maxResult)) {
            try {
                if (partner.getEmailAddress() == null || Strings.isNullOrEmpty((String)partner.getEmailAddress().getAddress())) continue;
                InternetAddress item = new InternetAddress(partner.getEmailAddress().getAddress(), partner.getFullName());
                addresses.add(item);
            }
            catch (UnsupportedEncodingException e) {
                TraceBackService.trace((Throwable)e);
            }
        }
        return addresses;
    }

    protected Set<String> recipients(MailMessage message, Model entity) {
        LinkedHashSet<String> recipients = new LinkedHashSet<String>();
        MailFollowerRepository followers = (MailFollowerRepository)Beans.get(MailFollowerRepository.class);
        String entityName = entity.getClass().getName();
        PartnerRepository partnerRepo = (PartnerRepository)((Object)Beans.get(PartnerRepository.class));
        if (message.getRecipients() != null) {
            for (MailAddress address : message.getRecipients()) {
                recipients.add(address.getAddress());
            }
        }
        for (MailFollower follower : followers.findAll((Model)message)) {
            if (follower.getArchived().booleanValue()) continue;
            User user = follower.getUser();
            if (user != null) {
                if (!user.getReceiveEmails().booleanValue() || !user.getFollowedMetaModelSet().stream().anyMatch(x -> x.getFullName().equals(entityName))) continue;
                Partner partner = partnerRepo.findByUser(user);
                if (partner != null && partner.getEmailAddress() != null) {
                    recipients.add(partner.getEmailAddress().getAddress());
                    continue;
                }
                if (user.getEmail() == null) continue;
                recipients.add(user.getEmail());
                continue;
            }
            if (follower.getEmail() != null) {
                recipients.add(follower.getEmail().getAddress());
                continue;
            }
            this.log.info("No email address found for follower : " + follower);
        }
        return Sets.filter(recipients, (Predicate)Predicates.notNull());
    }
}

