/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PartnerPriceList;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.repo.PartnerPriceListRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.tool.StringTool;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PartnerPriceListServiceImpl
implements PartnerPriceListService {
    protected AppBaseService appBaseService;

    @Inject
    public PartnerPriceListServiceImpl(AppBaseService appBaseService) {
        this.appBaseService = appBaseService;
    }

    @Override
    public void checkDates(PartnerPriceList partnerPriceList) throws AxelorException {
        Set<PriceList> priceListSet = partnerPriceList.getPriceListSet();
        if (priceListSet == null) {
            return;
        }
        Set sortedPriceListSet = priceListSet.stream().sorted(Comparator.comparing(priceList -> priceList.getApplicationBeginDate() != null ? priceList.getApplicationBeginDate() : LocalDate.MIN)).collect(Collectors.toSet());
        LocalDate previousEndDate = LocalDate.MIN;
        String previousTitle = "";
        for (PriceList priceList2 : sortedPriceListSet) {
            LocalDate beginDate;
            LocalDate localDate = beginDate = priceList2.getApplicationBeginDate() != null ? priceList2.getApplicationBeginDate() : LocalDate.MIN;
            if (beginDate.compareTo(previousEndDate) < 0) {
                throw new AxelorException(5, String.format(I18n.get((String)"The price list %s will still be active when the price list %s will become active."), previousTitle.replace("%", "%%"), priceList2.getTitle().replace("%", "%%")), new Object[]{partnerPriceList});
            }
            previousEndDate = priceList2.getApplicationEndDate() != null ? priceList2.getApplicationEndDate() : LocalDate.MAX;
            previousTitle = priceList2.getTitle();
        }
    }

    @Override
    public PriceList getDefaultPriceList(Partner partner, int priceListTypeSelect) {
        if (partner == null) {
            return null;
        }
        partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId()));
        PartnerPriceList partnerPriceList = this.getPartnerPriceList(partner, priceListTypeSelect);
        if (partnerPriceList == null) {
            return null;
        }
        Set<PriceList> priceListSet = partnerPriceList.getPriceListSet();
        if (priceListSet == null) {
            return null;
        }
        List priceLists = priceListSet.stream().filter(priceList -> !(priceList.getApplicationBeginDate() != null && priceList.getApplicationBeginDate().compareTo(this.appBaseService.getTodayDate()) > 0 || priceList.getApplicationEndDate() != null && priceList.getApplicationEndDate().compareTo(this.appBaseService.getTodayDate()) < 0)).collect(Collectors.toList());
        if (priceLists.size() == 1) {
            return (PriceList)((Object)priceLists.get(0));
        }
        return null;
    }

    @Override
    public String getPriceListDomain(Partner partner, int priceListTypeSelect) {
        if (partner == null) {
            return "self.id IN (0)";
        }
        List partnerPriceLists = ((PartnerPriceListRepository)((Object)Beans.get(PartnerPriceListRepository.class))).all().filter("self.typeSelect = :_priceListTypeSelect AND self.isExclusive = false").bind("_priceListTypeSelect", (Object)priceListTypeSelect).fetch();
        PartnerPriceList partnerPriceList = this.getPartnerPriceList(partner, priceListTypeSelect);
        if (partnerPriceList != null && partnerPriceList.getIsExclusive().booleanValue()) {
            partnerPriceLists.add(partnerPriceList);
        }
        if (partnerPriceLists.isEmpty()) {
            return "self.id IN (0)";
        }
        List priceLists = partnerPriceLists.stream().flatMap(partnerPriceList1 -> partnerPriceList1.getPriceListSet().stream()).filter(priceList -> !(priceList.getIsActive() == false || priceList.getApplicationBeginDate() != null && priceList.getApplicationBeginDate().compareTo(this.appBaseService.getTodayDate()) > 0 || priceList.getApplicationEndDate() != null && priceList.getApplicationEndDate().compareTo(this.appBaseService.getTodayDate()) < 0)).collect(Collectors.toList());
        return "self.id IN (" + StringTool.getIdListString(priceLists) + ")";
    }

    @Override
    public PartnerPriceList getPartnerPriceList(Partner partner, int priceListTypeSelect) {
        if (priceListTypeSelect == 1) {
            return partner.getSalePartnerPriceList();
        }
        if (priceListTypeSelect == 2) {
            return partner.getPurchasePartnerPriceList();
        }
        return null;
    }
}

