/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.repo.PeriodRepository;
import com.axelor.apps.base.service.AdjustHistoryService;
import com.axelor.apps.base.service.PeriodService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PeriodServiceImpl
implements PeriodService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PeriodRepository periodRepo;
    protected AdjustHistoryService adjustHistoryService;

    @Inject
    public PeriodServiceImpl(PeriodRepository periodRepo, AdjustHistoryService adjustHistoryService) {
        this.periodRepo = periodRepo;
        this.adjustHistoryService = adjustHistoryService;
    }

    @Override
    public Period getActivePeriod(LocalDate date, Company company, int typeSelect) throws AxelorException {
        Period period = this.getPeriod(date, company, typeSelect);
        if (period == null || period.getStatusSelect() == 2) {
            String dateStr = date != null ? date.toString() : "";
            throw new AxelorException(4, I18n.get((String)"No period found or it has been closed for the company %s for the date %s"), new Object[]{company.getName(), dateStr});
        }
        LOG.debug("Period : {}", (Object)period);
        return period;
    }

    @Override
    public Period getPeriod(LocalDate date, Company company, int typeSelect) {
        return (Period)((Object)this.periodRepo.all().filter("self.year.company = ?1 and self.fromDate <= ?2 and self.toDate >= ?2 and self.year.typeSelect = ?3", new Object[]{company, date, typeSelect}).fetchOne());
    }

    @Override
    public Period getNextPeriod(Period period) throws AxelorException {
        Period nextPeriod = (Period)((Object)this.periodRepo.all().filter("self.fromDate > ?1 AND self.year.company = ?2 AND self.statusSelect = ?3", new Object[]{period.getToDate(), period.getYear().getCompany(), 1}).fetchOne());
        if (nextPeriod == null || nextPeriod.getStatusSelect() == 2) {
            throw new AxelorException((Model)((Object)period), 4, I18n.get((String)"No period found or it has been closed for the company %s for the date %s"), new Object[]{period.getYear().getCompany().getName()});
        }
        LOG.debug("Next Period : {}", (Object)nextPeriod);
        return nextPeriod;
    }

    @Override
    public void testOpenPeriod(Period period) throws AxelorException {
        if (period.getStatusSelect() == 2) {
            throw new AxelorException((Model)((Object)period), 4, I18n.get((String)"Period closed"));
        }
    }

    @Override
    public void close(Period period) throws AxelorException {
        if (period.getStatusSelect() == 3) {
            this.adjustHistoryService.setEndDate(period);
        }
        this.updateClosePeriod(period);
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    protected void updateClosePeriod(Period period) {
        period.setStatusSelect(2);
        period.setClosureDateTime(LocalDateTime.now());
        this.periodRepo.save((Model)((Object)period));
    }

    @Override
    @Transactional
    public void adjust(Period period) {
        period = (Period)((Object)this.periodRepo.find(period.getId()));
        this.adjustHistoryService.setStartDate(period);
        period.setStatusSelect(3);
        this.periodRepo.save((Model)((Object)period));
    }

    @Override
    public void checkPeriod(Company company, LocalDate date) throws AxelorException {
        this.checkPeriod(company, date, date);
    }

    @Override
    public void checkPeriod(Company company, LocalDate fromDate, LocalDate toDate) throws AxelorException {
        List periodList = this.periodRepo.all().filter("self.year.typeSelect = :_typeSelect AND self.year.company = :_company AND ((self.fromDate <= :_fromDate AND self.toDate >= :_fromDate) OR (self.fromDate <= :_toDate AND self.toDate >= :_toDate))").bind("_typeSelect", (Object)2).bind("_company", (Object)company).bind("_fromDate", (Object)fromDate).bind("_toDate", (Object)toDate).fetch();
        if (periodList == null) {
            return;
        }
        for (Period period : periodList) {
            this.checkPeriod(period);
        }
    }

    @Override
    public void checkPeriod(Period period) throws AxelorException {
        if (period != null && period.getStatusSelect() == 2) {
            throw new AxelorException(5, I18n.get((String)"Warning : the pay period %s is closed."), new Object[]{period.getName()});
        }
    }
}

