/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductVariant;
import com.axelor.apps.base.db.ProductVariantAttr;
import com.axelor.apps.base.db.ProductVariantConfig;
import com.axelor.apps.base.db.ProductVariantValue;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.db.repo.ProductVariantRepository;
import com.axelor.apps.base.service.ProductService;
import com.axelor.apps.base.service.ProductVariantService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ProductServiceImpl
implements ProductService {
    protected ProductVariantService productVariantService;
    protected ProductVariantRepository productVariantRepo;
    protected SequenceService sequenceService;
    protected AppBaseService appBaseService;
    protected ProductRepository productRepo;
    @Inject
    private MetaFiles metaFiles;

    @Inject
    public ProductServiceImpl(ProductVariantService productVariantService, ProductVariantRepository productVariantRepo, SequenceService sequenceService, AppBaseService appBaseService, ProductRepository productRepo) {
        this.productVariantService = productVariantService;
        this.productVariantRepo = productVariantRepo;
        this.sequenceService = sequenceService;
        this.appBaseService = appBaseService;
        this.productRepo = productRepo;
    }

    @Override
    @Transactional
    public void updateProductPrice(Product product) {
        this.updateSalePrice(product);
        this.productRepo.save((Model)((Object)product));
    }

    @Override
    public String getSequence() throws AxelorException {
        String seq = this.sequenceService.getSequenceNumber("product");
        if (seq == null) {
            throw new AxelorException(4, I18n.get((String)"There is no configured sequence for product"));
        }
        return seq;
    }

    @Override
    public BigDecimal getPrice(Product product, boolean isPurchase) {
        if (isPurchase) {
            return product.getPurchasePrice();
        }
        return product.getSalePrice();
    }

    @Override
    public void updateSalePrice(Product product) {
        BigDecimal managePriceCoef = product.getManagPriceCoef();
        if (product.getCostPrice() != null && product.getProductVariant() != null) {
            product.setCostPrice(product.getCostPrice().add(this.getProductExtraPrice(product.getProductVariant(), 1)));
        }
        if (product.getCostPrice() != null && managePriceCoef != null) {
            product.setSalePrice(product.getCostPrice().multiply(managePriceCoef).setScale(this.appBaseService.getNbDecimalDigitForUnitPrice(), 4));
            if (product.getProductVariant() != null) {
                product.setSalePrice(product.getSalePrice().add(this.getProductExtraPrice(product.getProductVariant(), 0)));
            }
        }
        if (product.getProductVariantConfig() != null && product.getManageVariantPrice().booleanValue()) {
            this.updateSalePriceOfVariant(product);
        }
    }

    private void updateSalePriceOfVariant(Product product) {
        List productVariantList = this.productRepo.all().filter("self.parentProduct = ?1", new Object[]{product}).fetch();
        for (Product productVariant : productVariantList) {
            productVariant.setCostPrice(product.getCostPrice());
            productVariant.setSalePrice(product.getSalePrice());
            productVariant.setManagPriceCoef(product.getManagPriceCoef());
            this.updateSalePrice(productVariant);
        }
    }

    @Override
    @Transactional
    public void generateProductVariants(Product productModel) {
        List<ProductVariant> productVariantList = this.getProductVariantList(productModel.getProductVariantConfig());
        int seq = 1;
        for (ProductVariant productVariant : productVariantList) {
            this.productVariantRepo.save((Model)((Object)productVariant));
            this.productRepo.save((Model)((Object)this.createProduct(productModel, productVariant, seq++)));
        }
    }

    @Override
    public Product createProduct(Product productModel, ProductVariant productVariant, int seq) {
        String description = "";
        String internalDescription = "";
        if (productModel.getDescription() != null) {
            description = productModel.getDescription();
        }
        if (productModel.getInternalDescription() != null) {
            internalDescription = productModel.getInternalDescription();
        }
        description = description + "<br>" + productVariant.getName();
        internalDescription = internalDescription + "<br>" + productVariant.getName();
        Product product = new Product(productModel.getName() + " (" + productVariant.getName() + ")", productModel.getCode() + "-" + seq, description, internalDescription, productModel.getPicture(), productModel.getProductCategory(), productModel.getProductFamily(), productModel.getUnit(), productModel.getSaleSupplySelect(), productModel.getProductTypeSelect(), productModel.getProcurementMethodSelect(), productModel.getSaleCurrency(), productModel.getPurchaseCurrency(), productModel.getStartDate(), productModel.getEndDate());
        productModel.setIsModel(true);
        product.setIsModel(false);
        product.setParentProduct(productModel);
        product.setProductVariant(productVariant);
        product.setCostPrice(productModel.getCostPrice());
        product.setSalePrice(productModel.getSalePrice());
        product.setManagPriceCoef(productModel.getManagPriceCoef());
        this.updateSalePrice(product);
        return product;
    }

    @Override
    public BigDecimal getProductExtraPrice(ProductVariant productVariant, int applicationPriceSelect) {
        BigDecimal extraPrice = BigDecimal.ZERO;
        ProductVariantValue productVariantValue1 = productVariant.getProductVariantValue1();
        ProductVariantValue productVariantValue2 = productVariant.getProductVariantValue2();
        ProductVariantValue productVariantValue3 = productVariant.getProductVariantValue3();
        ProductVariantValue productVariantValue4 = productVariant.getProductVariantValue4();
        if (productVariantValue1 != null && productVariantValue1.getApplicationPriceSelect() == applicationPriceSelect) {
            extraPrice = extraPrice.add(productVariantValue1.getPriceExtra());
        }
        if (productVariantValue2 != null) {
            extraPrice = extraPrice.add(productVariantValue2.getPriceExtra());
        }
        if (productVariantValue3 != null) {
            extraPrice = extraPrice.add(productVariantValue3.getPriceExtra());
        }
        if (productVariantValue4 != null) {
            extraPrice = extraPrice.add(productVariantValue4.getPriceExtra());
        }
        return extraPrice;
    }

    private List<ProductVariant> getProductVariantList(ProductVariantConfig productVariantConfig) {
        ArrayList productVariantList = Lists.newArrayList();
        if (productVariantConfig.getProductVariantAttr1() != null && productVariantConfig.getProductVariantValue1Set() != null) {
            for (ProductVariantValue productVariantValue1 : productVariantConfig.getProductVariantValue1Set()) {
                productVariantList.addAll(this.getProductVariantList(productVariantConfig, productVariantValue1));
            }
        }
        return productVariantList;
    }

    private List<ProductVariant> getProductVariantList(ProductVariantConfig productVariantConfig, ProductVariantValue productVariantValue1) {
        ArrayList productVariantList = Lists.newArrayList();
        if (productVariantConfig.getProductVariantAttr2() != null && productVariantConfig.getProductVariantValue2Set() != null) {
            for (ProductVariantValue productVariantValue2 : productVariantConfig.getProductVariantValue2Set()) {
                productVariantList.addAll(this.getProductVariantList(productVariantConfig, productVariantValue1, productVariantValue2));
            }
        } else {
            productVariantList.add(this.createProductVariant(productVariantConfig, productVariantValue1, null, null, null));
        }
        return productVariantList;
    }

    private List<ProductVariant> getProductVariantList(ProductVariantConfig productVariantConfig, ProductVariantValue productVariantValue1, ProductVariantValue productVariantValue2) {
        ArrayList productVariantList = Lists.newArrayList();
        if (productVariantConfig.getProductVariantAttr3() != null && productVariantConfig.getProductVariantValue3Set() != null) {
            for (ProductVariantValue productVariantValue3 : productVariantConfig.getProductVariantValue3Set()) {
                productVariantList.addAll(this.getProductVariantList(productVariantConfig, productVariantValue1, productVariantValue2, productVariantValue3));
            }
        } else {
            productVariantList.add(this.createProductVariant(productVariantConfig, productVariantValue1, productVariantValue2, null, null));
        }
        return productVariantList;
    }

    private List<ProductVariant> getProductVariantList(ProductVariantConfig productVariantConfig, ProductVariantValue productVariantValue1, ProductVariantValue productVariantValue2, ProductVariantValue productVariantValue3) {
        ArrayList productVariantList = Lists.newArrayList();
        if (productVariantConfig.getProductVariantAttr4() != null && productVariantConfig.getProductVariantValue4Set() != null) {
            for (ProductVariantValue productVariantValue4 : productVariantConfig.getProductVariantValue4Set()) {
                productVariantList.add(this.createProductVariant(productVariantConfig, productVariantValue1, productVariantValue2, productVariantValue3, productVariantValue4));
            }
        } else {
            productVariantList.add(this.createProductVariant(productVariantConfig, productVariantValue1, productVariantValue2, productVariantValue3, null));
        }
        return productVariantList;
    }

    @Override
    public ProductVariant createProductVariant(ProductVariantConfig productVariantConfig, ProductVariantValue productVariantValue1, ProductVariantValue productVariantValue2, ProductVariantValue productVariantValue3, ProductVariantValue productVariantValue4) {
        ProductVariantAttr productVariantAttr1 = null;
        ProductVariantAttr productVariantAttr2 = null;
        ProductVariantAttr productVariantAttr3 = null;
        ProductVariantAttr productVariantAttr4 = null;
        if (productVariantValue1 != null) {
            productVariantAttr1 = productVariantConfig.getProductVariantAttr1();
        }
        if (productVariantValue2 != null) {
            productVariantAttr2 = productVariantConfig.getProductVariantAttr2();
        }
        if (productVariantValue3 != null) {
            productVariantAttr3 = productVariantConfig.getProductVariantAttr3();
        }
        if (productVariantValue4 != null) {
            productVariantAttr4 = productVariantConfig.getProductVariantAttr4();
        }
        return this.productVariantService.createProductVariant(productVariantAttr1, productVariantAttr2, productVariantAttr3, productVariantAttr4, productVariantValue1, productVariantValue2, productVariantValue3, productVariantValue4, false);
    }

    @Override
    public void copyProduct(Product product, Product copy) {
        copy.setBarCode(null);
        try {
            if (product.getPicture() != null) {
                File file = MetaFiles.getPath((MetaFile)product.getPicture()).toFile();
                copy.setPicture(this.metaFiles.upload(file));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        copy.setStartDate(null);
        copy.setEndDate(null);
        copy.setCostPrice(BigDecimal.ZERO);
        copy.setPurchasePrice(BigDecimal.ZERO);
    }
}

