/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ShippingCoef;
import com.axelor.apps.base.db.repo.ShippingCoefRepository;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.List;

public class ShippingCoefService {
    protected ShippingCoefRepository shippingCoefRepo;

    @Inject
    public ShippingCoefService(ShippingCoefRepository shippingCoefRepo) {
        this.shippingCoefRepo = shippingCoefRepo;
    }

    public BigDecimal getShippingCoefDefByPartner(Product product, Partner partner, Company company, BigDecimal qty) {
        BigDecimal shippingCoef = BigDecimal.ONE;
        if (partner == null || company == null) {
            return shippingCoef;
        }
        List shippingCoefList = this.shippingCoefRepo.all().filter("self.supplierCatalog.product.id = :productId AND self.supplierCatalog.supplierPartner.id = :partnerId AND self.supplierCatalog.minQty <= :qty").bind("productId", (Object)product.getId()).bind("partnerId", (Object)partner.getId()).bind("qty", (Object)qty).order("supplierCatalog.minQty").fetch();
        if (shippingCoefList == null || shippingCoefList.isEmpty()) {
            return shippingCoef;
        }
        for (ShippingCoef shippingCoefObject : shippingCoefList) {
            if (!company.equals((Object)shippingCoefObject.getCompany())) continue;
            shippingCoef = shippingCoefObject.getShippingCoef();
        }
        return shippingCoef;
    }

    public BigDecimal getShippingCoef(Product product, Partner supplierPartner, Company company, BigDecimal qty) {
        BigDecimal shippingCoef = product.getDefShipCoefByPartner() != false ? this.getShippingCoefDefByPartner(product, supplierPartner, company, qty) : product.getShippingCoef();
        if (shippingCoef.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ONE;
        }
        return shippingCoef;
    }
}

