/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Frequency;
import com.axelor.apps.base.db.repo.FrequencyRepository;
import com.axelor.apps.base.service.FrequencyService;
import com.axelor.apps.base.service.TeamTaskService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class TeamTaskServiceImpl
implements TeamTaskService {
    protected TeamTaskRepository teamTaskRepo;

    @Inject
    public TeamTaskServiceImpl(TeamTaskRepository teamTaskRepo) {
        this.teamTaskRepo = teamTaskRepo;
    }

    @Override
    @Transactional
    public void generateTasks(TeamTask teamTask, Frequency frequency) {
        List<LocalDate> taskDates = ((FrequencyService)Beans.get(FrequencyService.class)).getDates(frequency, teamTask.getTaskDate(), frequency.getEndDate());
        taskDates.removeIf(date -> date.equals(teamTask.getTaskDate()));
        Integer limitNumberTasksGenerated = ((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getLimitNumberTasksGenerated();
        if (taskDates.size() > limitNumberTasksGenerated) {
            taskDates = taskDates.subList(0, limitNumberTasksGenerated);
        }
        TeamTask lastTask = teamTask;
        for (LocalDate date2 : taskDates) {
            TeamTask newTeamTask = (TeamTask)((Object)this.teamTaskRepo.copy((Model)((Object)teamTask), false));
            this.setModuleFields(teamTask, date2, newTeamTask);
            this.teamTaskRepo.save((Model)((Object)newTeamTask));
            lastTask.setNextTeamTask(newTeamTask);
            this.teamTaskRepo.save((Model)((Object)lastTask));
            lastTask = newTeamTask;
        }
    }

    protected void setModuleFields(TeamTask teamTask, LocalDate date, TeamTask newTeamTask) {
        newTeamTask.setIsFirst(false);
        newTeamTask.setHasDateOrFrequencyChanged(false);
        newTeamTask.setDoApplyToAllNextTasks(false);
        newTeamTask.setFrequency((Frequency)((Object)((FrequencyRepository)((Object)Beans.get(FrequencyRepository.class))).copy((Model)((Object)teamTask.getFrequency()), false)));
        newTeamTask.setTaskDate(date);
        newTeamTask.setTaskDeadline(date);
        newTeamTask.setNextTeamTask(null);
    }

    @Override
    @Transactional
    public void updateNextTask(TeamTask teamTask) {
        TeamTask nextTeamTask = teamTask.getNextTeamTask();
        if (nextTeamTask != null) {
            this.updateModuleFields(teamTask, nextTeamTask);
            this.teamTaskRepo.save((Model)((Object)nextTeamTask));
            this.updateNextTask(nextTeamTask);
        }
    }

    protected void updateModuleFields(TeamTask teamTask, TeamTask nextTeamTask) {
        nextTeamTask.setName(teamTask.getName());
        nextTeamTask.setTeam(teamTask.getTeam());
        nextTeamTask.setPriority(teamTask.getPriority());
        nextTeamTask.setStatus(teamTask.getStatus());
        nextTeamTask.setTaskDuration(teamTask.getTaskDuration());
        nextTeamTask.setAssignedTo(teamTask.getAssignedTo());
        nextTeamTask.setDescription(teamTask.getDescription());
    }

    @Override
    @Transactional
    public void removeNextTasks(TeamTask teamTask) {
        List<TeamTask> teamTasks = this.getAllNextTasks(teamTask);
        teamTask.setNextTeamTask(null);
        teamTask.setHasDateOrFrequencyChanged(false);
        this.teamTaskRepo.save((Model)((Object)teamTask));
        for (TeamTask teamTaskToRemove : teamTasks) {
            this.teamTaskRepo.remove((Model)((Object)teamTaskToRemove));
        }
    }

    public List<TeamTask> getAllNextTasks(TeamTask teamTask) {
        ArrayList<TeamTask> teamTasks = new ArrayList<TeamTask>();
        TeamTask current = teamTask;
        while (current.getNextTeamTask() != null) {
            current = current.getNextTeamTask();
            teamTasks.add(current);
        }
        for (TeamTask tt : teamTasks) {
            tt.setNextTeamTask(null);
            this.teamTaskRepo.save((Model)((Object)tt));
        }
        return teamTasks;
    }
}

