/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.PrintingSettings;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.base.db.TradingNamePrintingSettings;
import com.axelor.apps.base.service.TradingNameService;
import com.axelor.db.JPA;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TradingNameServiceImpl
implements TradingNameService {
    @Override
    public List<PrintingSettings> getPrintingSettingsList(TradingName tradingName, Company company) {
        List<PrintingSettings> printingSettingsList = new ArrayList<PrintingSettings>();
        if (company == null) {
            return printingSettingsList;
        }
        if (tradingName == null || company.getId() == null || tradingName.getId() == null) {
            if (company.getPrintingSettings() != null) {
                printingSettingsList.add(company.getPrintingSettings());
            }
        } else {
            List tradingNamePrintingSettingsList = JPA.all(TradingNamePrintingSettings.class).filter("self.company.id = :company AND self.tradingName.id = :tradingName").bind("company", (Object)company.getId()).bind("tradingName", (Object)tradingName.getId()).fetch();
            printingSettingsList = tradingNamePrintingSettingsList.stream().map(TradingNamePrintingSettings::getPrintingSettings).collect(Collectors.toList());
        }
        return printingSettingsList;
    }

    @Override
    public PrintingSettings getDefaultPrintingSettings(TradingName tradingName, Company company) {
        List<PrintingSettings> printingSettingsList = this.getPrintingSettingsList(tradingName, company);
        return printingSettingsList.isEmpty() ? null : printingSettingsList.get(0);
    }
}

