/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.administration;

import com.axelor.apps.base.db.IndicatorGenerator;
import com.axelor.apps.base.db.repo.IndicatorGeneratorRepository;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigInteger;
import javax.persistence.Query;

public class IndicatorGeneratorService {
    @Inject
    private IndicatorGeneratorRepository indicatorGeneratorRepo;

    @Transactional(rollbackOn={Exception.class})
    public String run(IndicatorGenerator indicatorGenerator) throws AxelorException {
        String log = "";
        int requestType = indicatorGenerator.getRequestLanguage();
        String request = indicatorGenerator.getRequest();
        if (request == null || request.isEmpty()) {
            log = String.format(I18n.get((String)"Error : a request has to be set for the indicatior generator %s"), indicatorGenerator.getCode());
        }
        String result = "";
        try {
            if (request != null && !request.isEmpty()) {
                if (requestType == 0) {
                    result = this.runSqlRequest(request);
                } else if (requestType == 1) {
                    result = this.runJpqlRequest(request);
                }
            }
        }
        catch (Exception e) {
            log = log + String.format(I18n.get((String)"Error : incorrect request for the indicatior generator %s"), indicatorGenerator.getCode());
        }
        indicatorGenerator.setLog(log);
        indicatorGenerator.setResult(result);
        this.indicatorGeneratorRepo.save((Model)((Object)indicatorGenerator));
        return result;
    }

    public String runSqlRequest(String request) {
        String result = "";
        Query query = JPA.em().createNativeQuery(request);
        BigInteger requestResult = (BigInteger)query.getSingleResult();
        result = String.format("%s", requestResult);
        return result;
    }

    public String runJpqlRequest(String request) {
        String result = "";
        Query query = JPA.em().createQuery(request);
        Long requestResult = (Long)query.getSingleResult();
        result = String.format("%s", requestResult);
        return result;
    }
}

