/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advanced.imports;

import com.axelor.apps.base.db.AdvancedImport;
import com.axelor.apps.base.db.FileField;
import com.axelor.apps.base.db.FileTab;
import com.axelor.apps.base.db.repo.AdvancedImportRepository;
import com.axelor.apps.base.db.repo.FileFieldRepository;
import com.axelor.apps.base.service.advanced.imports.AdvancedImportService;
import com.axelor.apps.base.service.advanced.imports.DataImportService;
import com.axelor.apps.base.service.advanced.imports.FileFieldService;
import com.axelor.apps.base.service.advanced.imports.ValidatorService;
import com.axelor.apps.base.service.readers.DataReaderFactory;
import com.axelor.apps.base.service.readers.DataReaderService;
import com.axelor.common.Inflector;
import com.axelor.db.EntityHelper;
import com.axelor.db.JpaRepository;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.rpc.JsonContext;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedImportServiceImpl
implements AdvancedImportService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String forSelectUseValues = "values";
    private static final String forSelectUseTitles = "titles";
    private static final String forSelectUseTranslatedTitles = "translated titles";
    private Inflector inflector = Inflector.getInstance();
    private List<String> searchFieldList = new ArrayList<String>();
    private boolean isTabWithoutConfig = false;
    @Inject
    private MetaModelRepository metaModelRepo;
    @Inject
    private MetaFieldRepository metaFieldRepo;
    @Inject
    private DataReaderFactory dataReaderFactory;
    @Inject
    private FileFieldService fileFieldService;
    @Inject
    private AdvancedImportRepository advancedImportRepository;
    @Inject
    private FileFieldRepository fileFieldRepository;
    @Inject
    private DataImportService dataImportService;

    @Override
    public boolean apply(AdvancedImport advancedImport) throws AxelorException, ClassNotFoundException {
        if (advancedImport.getImportFile() == null) {
            throw new AxelorException(4, I18n.get((String)"Data file doesn't exist"));
        }
        String extension = Files.getFileExtension((String)advancedImport.getImportFile().getFileName());
        if (extension == null || !extension.equals("xlsx") && !extension.equals("xls") && !extension.equals("csv")) {
            return false;
        }
        DataReaderService reader = this.dataReaderFactory.getDataReader(extension);
        reader.initialize(advancedImport.getImportFile(), advancedImport.getFileSeparator());
        return this.process(reader, advancedImport);
    }

    @Transactional
    public boolean process(DataReaderService reader, AdvancedImport advancedImport) throws AxelorException, ClassNotFoundException {
        boolean isValid = true;
        if (!CollectionUtils.isEmpty(advancedImport.getFileTabList())) {
            advancedImport.getFileTabList().stream().forEach(tab -> tab.clearFileFieldList());
            advancedImport.clearFileTabList();
        }
        String[] sheets = reader.getSheetNames();
        boolean isConfig = advancedImport.getIsConfigInFile();
        boolean isTabConfig = advancedImport.getIsFileTabConfigAdded();
        boolean isHeader = advancedImport.getIsHeader();
        int linesToIgnore = advancedImport.getNbOfFirstLineIgnore();
        int tabConfigRowCount = 0;
        int startIndex = isConfig ? 0 : linesToIgnore;
        int fileTabSequence = 1;
        for (String sheet : sheets) {
            int line;
            int totalLines = reader.getTotalLines(sheet);
            if (totalLines == 0) continue;
            FileTab fileTab = new FileTab();
            fileTab.setName(sheet);
            fileTab.setSequence(fileTabSequence);
            ++fileTabSequence;
            String[] objectRow = reader.read(sheet, startIndex, 0);
            if (objectRow == null) {
                isValid = false;
                break;
            }
            if (isConfig && isTabConfig) {
                tabConfigRowCount = this.getTabConfigRowCount(sheet, reader, totalLines, objectRow);
            }
            if (!(isValid = this.applyObject(objectRow, fileTab, isConfig, linesToIgnore, isTabConfig))) break;
            ArrayList<FileField> fileFieldList = new ArrayList<FileField>();
            ArrayList<Integer> ignoreFields = new ArrayList<Integer>();
            int n = line = isConfig ? 1 : linesToIgnore;
            while (line < totalLines) {
                String[] row = reader.read(sheet, line, isConfig ? 0 : objectRow.length);
                if (row != null) {
                    if (isConfig) {
                        this.applyWithConfig(row, line, fileFieldList, ignoreFields, fileTab, isTabConfig, tabConfigRowCount);
                    } else {
                        this.applyWithoutConfig(row, line - linesToIgnore, fileFieldList, fileTab, isHeader);
                    }
                }
                ++line;
            }
            if (isConfig) {
                fileFieldList.removeIf(field -> field.getImportField() == null);
                if (!fileTab.getImportType().equals(3)) {
                    fileTab = this.setSearchField(fileTab, this.searchFieldList, fileFieldList);
                }
            }
            advancedImport.addFileTabListItem(fileTab);
            this.advancedImportRepository.save((Model)((Object)advancedImport));
        }
        return isValid;
    }

    private boolean applyObject(String[] row, FileTab fileTab, boolean isConfig, int linesToIgnore, boolean isTabConfig) throws AxelorException {
        int rowIndex;
        int n = isConfig ? (isTabConfig ? 1 : 0) : (rowIndex = 0);
        if (isTabConfig && row[0] != null) {
            rowIndex = 0;
            this.isTabWithoutConfig = true;
        }
        if (StringUtils.contains((CharSequence)row[rowIndex], (CharSequence)"Object") && isConfig) {
            this.setFileTabConfig(row, fileTab, rowIndex);
        } else {
            if ((StringUtils.containsIgnoreCase((CharSequence)row[0], (CharSequence)"Object") || row.length > 1 && StringUtils.contains((CharSequence)row[1], (CharSequence)"Object")) && !isConfig) {
                throw new AxelorException(4, I18n.get((String)"Config exist in the file. Please check 'Config included in file'"));
            }
            if (isConfig && !StringUtils.containsIgnoreCase((CharSequence)row[0], (CharSequence)"Object") && row.length > 1 && !StringUtils.contains((CharSequence)row[1], (CharSequence)"Object")) {
                throw new AxelorException(4, I18n.get((String)"Config doesn't exist in the file. Please uncheck 'Config included in file'"));
            }
            if (isConfig) {
                throw new AxelorException(4, I18n.get((String)"Object is missing for tab configuration(%s)"), new Object[]{fileTab.getName()});
            }
        }
        return !StringUtils.isBlank((CharSequence)row[0]) || row.length <= 1 || !StringUtils.isBlank((CharSequence)row[1]) || linesToIgnore != 0;
    }

    private void applyWithConfig(String[] row, int line, List<FileField> fileFieldList, List<Integer> ignoreFields, FileTab fileTab, Boolean isTabConfig, int tabConfigRowCount) throws AxelorException, ClassNotFoundException {
        Mapper mapper = this.getMapper(fileTab.getMetaModel().getFullName());
        FileField fileField = null;
        int index = 0;
        for (int i = 0; i < row.length; ++i) {
            if (Strings.isNullOrEmpty((String)row[i])) continue;
            index = line;
            String value = row[i].trim();
            if (line == 1) {
                this.readFields(value, i, fileFieldList, ignoreFields, mapper, fileTab);
                continue;
            }
            if (ignoreFields.contains(i)) continue;
            if (fileFieldList.size() < i || !isTabConfig.booleanValue() && fileFieldList.size() <= i) break;
            if (row[0] == null) {
                fileField = fileFieldList.get(i - 1);
            } else if (!isTabConfig.booleanValue() && row[0] != null) {
                fileField = fileFieldList.get(i);
            }
            if (this.isTabWithoutConfig) {
                fileField = fileFieldList.get(i);
            }
            if (line == 2) {
                fileField.setColumnTitle(value);
                continue;
            }
            if (isTabConfig.booleanValue() && i > 0 && row[0] != null && line >= 3 && line <= 11) {
                fileField = fileFieldList.get(i - 1);
                this.setFileFieldConfig(row, i, fileField);
            }
            if (isTabConfig.booleanValue() && i > 0 && row[0] == null) {
                this.setSampleLines(line += -(tabConfigRowCount + 2), value, fileField);
                line = index;
                continue;
            }
            if (isTabConfig.booleanValue()) continue;
            this.setSampleLines(line -= 2, value, fileField);
            line = index;
        }
    }

    @Transactional
    public void applyWithoutConfig(String[] row, int line, List<FileField> fileFieldList, FileTab fileTab, boolean isHeader) throws AxelorException {
        int index = 0;
        for (int i = 0; i < row.length; ++i) {
            if (Strings.isNullOrEmpty((String)row[i])) continue;
            index = line;
            String value = row[i].trim();
            FileField fileField = null;
            if (line == 0) {
                fileField = new FileField();
                fileField.setIsMatchWithFile(true);
                fileFieldList.add(fileField);
                fileField.setFileTab(fileTab);
                if (isHeader) {
                    fileField.setColumnTitle(value);
                } else {
                    fileField.setFirstLine(value);
                }
                fileField.setSequence(i);
                fileField.setFullName(this.fileFieldService.computeFullName(fileField));
                fileField = (FileField)((Object)this.fileFieldRepository.save((Model)((Object)fileField)));
                continue;
            }
            if (fileFieldList.size() <= i) break;
            if (!isHeader) {
                ++line;
            }
            if (fileField == null) {
                fileField = fileFieldList.get(i);
            }
            this.setSampleLines(line, value, fileField);
            line = index;
        }
    }

    private void setSampleLines(int line, String value, FileField fileField) {
        if (!StringUtils.isBlank((CharSequence)fileField.getTargetType()) && fileField.getTargetType().equals("String") && !StringUtils.isBlank((CharSequence)value) && value.length() > 255) {
            value = StringUtils.abbreviate((String)value, (int)255);
        }
        switch (line) {
            case 1: {
                fileField.setFirstLine(value);
                break;
            }
            case 2: {
                fileField.setSecondLine(value);
                break;
            }
            case 3: {
                fileField.setThirdLine(value);
                break;
            }
        }
    }

    @Transactional
    public void readFields(String value, int index, List<FileField> fileFieldList, List<Integer> ignoreFields, Mapper mapper, FileTab fileTab) throws AxelorException, ClassNotFoundException {
        FileField fileField = new FileField();
        fileField.setSequence(index);
        if (Strings.isNullOrEmpty((String)value)) {
            return;
        }
        String importType = StringUtils.substringBetween((String)value, (String)"(", (String)")");
        if (!Strings.isNullOrEmpty((String)importType) && (importType.equalsIgnoreCase(forSelectUseValues) || importType.equalsIgnoreCase(forSelectUseTitles) || importType.equalsIgnoreCase(forSelectUseTranslatedTitles))) {
            fileField.setForSelectUse(this.getForStatusSelect(importType));
        } else {
            fileField.setImportType(this.getImportType(value, importType));
        }
        value = value.split("\\(")[0];
        String importField = null;
        String subImportField = null;
        if (value.contains(".")) {
            importField = value.substring(0, value.indexOf("."));
            subImportField = value.substring(value.indexOf(".") + 1, value.length());
        } else {
            importField = value;
        }
        boolean isValid = this.checkFields(mapper, importField, subImportField);
        if (isValid) {
            this.setImportFields(mapper, fileField, importField, subImportField);
        } else {
            ignoreFields.add(index);
        }
        fileFieldList.add(fileField);
        fileField = (FileField)((Object)this.fileFieldRepository.save((Model)((Object)fileField)));
        fileTab.addFileFieldListItem(fileField);
    }

    private boolean checkFields(Mapper mapper, String importField, String subImportField) throws AxelorException, ClassNotFoundException {
        if (importField != null) {
            Property parentProp = mapper.getProperty(importField);
            if (parentProp == null) {
                throw new AxelorException(4, String.format(I18n.get((String)"Field(%s) doesn't exist for the object(%s)"), importField, mapper.getBeanClass().getSimpleName()));
            }
            if (parentProp.getType().name().equals("ONE_TO_MANY")) {
                return false;
            }
            if (!Strings.isNullOrEmpty((String)subImportField)) {
                String[] subFields = subImportField.split("\\.");
                return this.checkSubFields(subFields, 0, parentProp, parentProp.getEntity().getSimpleName());
            }
            if (parentProp.getTarget() != null) {
                throw new AxelorException(4, String.format(I18n.get((String)"Sub field doesn't exist of field(%s) for the object(%s)"), importField, mapper.getBeanClass().getSimpleName()));
            }
        }
        return true;
    }

    private boolean checkSubFields(String[] subFields, int index, Property parentProp, String model) throws AxelorException, ClassNotFoundException {
        boolean isValid = true;
        if (index < subFields.length && parentProp.getTarget() != null) {
            Mapper mapper = this.getMapper(parentProp.getTarget().getName());
            Property childProp = mapper.getProperty(subFields[index]);
            if (childProp == null) {
                throw new AxelorException(4, String.format(I18n.get((String)"Sub field(%s) doesn't exist of field(%s) for the object(%s)"), subFields[index], parentProp.getName(), model));
            }
            if (childProp.getTarget() != null) {
                if (childProp.getType().name().equals("ONE_TO_MANY")) {
                    isValid = false;
                    return isValid;
                }
                if (index != subFields.length - 1) {
                    isValid = this.checkSubFields(subFields, index + 1, childProp, model);
                } else {
                    throw new AxelorException(4, String.format(I18n.get((String)"Sub field doesn't exist of field(%s) for the object(%s)"), subFields[index], model));
                }
            }
        }
        return isValid;
    }

    private void setImportFields(Mapper mapper, FileField fileField, String importField, String subImportField) {
        Property prop = mapper.getProperty(importField);
        MetaField field = (MetaField)((Object)this.metaFieldRepo.all().filter("self.name = ?1 AND self.metaModel.name = ?2", new Object[]{prop.getName(), prop.getEntity().getSimpleName()}).fetchOne());
        fileField.setImportField(field);
        fileField.setIsMatchWithFile(true);
        if (!Strings.isNullOrEmpty((String)subImportField)) {
            fileField.setSubImportField(subImportField);
        }
        fileField.setFullName(this.fileFieldService.computeFullName(fileField));
        fileField = this.fileFieldService.fillType(fileField);
        if (fileField.getTargetType().equals("MetaFile")) {
            fileField.setImportType(3);
        }
    }

    private int getImportType(String value, String importType) {
        if (Strings.isNullOrEmpty((String)importType)) {
            if (value.contains(".")) {
                return 3;
            }
            return 0;
        }
        switch (importType.toLowerCase()) {
            case "find": {
                return 1;
            }
            case "findnew": {
                return 2;
            }
            case "new": {
                return 3;
            }
            case "ignore/empty": {
                return 4;
            }
        }
        if (value.contains(".")) {
            return 3;
        }
        return 0;
    }

    private int getForStatusSelect(String importType) {
        switch (importType.toLowerCase()) {
            case "titles": {
                return 0;
            }
            case "values": {
                return 1;
            }
            case "translated titles": {
                return 2;
            }
        }
        return 1;
    }

    protected void setFileTabConfig(String[] row, FileTab fileTab, int rowIndex) throws AxelorException {
        String KEY_OBJECT = "object";
        String KEY_IMPORT_TYPE = "importtype";
        String KEY_SEARCH_FIELD_SET = "searchfieldset";
        String KEY_ACTIONS = "actions";
        List<String> KEY_LIST = Arrays.asList("importtype", "object", "searchfieldset", "actions");
        Map<String, String> tabConfigDataMap = this.getTabConfigDataMap(row, KEY_LIST);
        MetaModel model = this.metaModelRepo.findByName(tabConfigDataMap.get("object"));
        fileTab.setMetaModel(model);
        if (tabConfigDataMap.containsKey("importtype")) {
            Integer importType = this.getImportType(null, tabConfigDataMap.get("importtype"));
            fileTab.setImportType(importType);
            if (importType != 3) {
                if (!tabConfigDataMap.containsKey("searchfieldset")) {
                    throw new AxelorException(4, I18n.get((String)"Search fields are missing for the object(%s)"), new Object[]{fileTab.getName()});
                }
                this.searchFieldList = Arrays.asList(tabConfigDataMap.get("searchfieldset").split("\\,"));
            }
        }
        fileTab.setActions(tabConfigDataMap.get("actions"));
    }

    protected void setFileFieldConfig(String[] row, Integer i, FileField fileField) {
        String fieldName = row[0].trim();
        switch (fieldName.toLowerCase()) {
            case "forselectuse": {
                fileField.setForSelectUse(this.getForStatusSelect(row[i]));
                break;
            }
            case "noimportif": {
                fileField.setNoImportIf(row[i]);
                break;
            }
            case "expression": {
                fileField.setExpression(row[i]);
                break;
            }
            case "dateformat": {
                fileField.setDateFormat(row[i]);
                break;
            }
            case "importtype": {
                fileField.setImportType(Integer.parseInt(row[i]));
                break;
            }
            case "subimportfield": {
                fileField.setSubImportField(row[i]);
                break;
            }
            case "splitby": {
                fileField.setSplitBy(row[i]);
                break;
            }
            case "defaultifnotfound": {
                fileField.setDefaultIfNotFound(row[i]);
            }
        }
    }

    protected FileTab setSearchField(FileTab fileTab, List<String> searchFieldList, List<FileField> fileFieldList) {
        HashSet<FileField> searchFieldSet = new HashSet<FileField>();
        for (String searchField : searchFieldList) {
            for (FileField fileField : fileFieldList) {
                if (!fileField.getFullName().endsWith("- " + searchField)) continue;
                searchFieldSet.add(fileField);
            }
        }
        fileTab.setSearchFieldSet(searchFieldSet);
        return fileTab;
    }

    @Override
    public int getTabConfigRowCount(String sheet, DataReaderService reader, int totalLines, String[] objectRow) {
        int tabConfigRowCount = 0;
        if (objectRow[0] == null && objectRow.length > 1 && StringUtils.containsIgnoreCase((CharSequence)objectRow[1], (CharSequence)"Object")) {
            for (int linesForTab = 3; linesForTab < totalLines && reader.read(sheet, linesForTab, 0)[0] != null; ++linesForTab) {
                ++tabConfigRowCount;
            }
        }
        return tabConfigRowCount;
    }

    @Override
    public Mapper getMapper(String modelFullName) throws ClassNotFoundException {
        Class<?> klass = Class.forName(modelFullName);
        return Mapper.of(klass);
    }

    @Override
    public boolean resetImport(AdvancedImport advancedImport) throws ClassNotFoundException {
        List<FileTab> fileTabList = advancedImport.getFileTabList();
        ((ValidatorService)Beans.get(ValidatorService.class)).sortFileTabList(fileTabList);
        boolean isResetValue = this.resetRelationalFields(fileTabList);
        if (isResetValue) {
            this.removeRecords(fileTabList);
        }
        return isResetValue;
    }

    public boolean resetRelationalFields(List<FileTab> fileTabList) throws ClassNotFoundException {
        boolean isResetValue = false;
        for (FileTab fileTab : fileTabList) {
            String fieldName;
            Map<String, Object> jsonContextMap = this.dataImportService.createJsonContext(fileTab);
            JsonContext jsonContext = (JsonContext)jsonContextMap.get("jsonContext");
            List recordList = (List)jsonContext.get((Object)(fieldName = this.inflector.camelize(fileTab.getMetaModel().getName(), true) + "Set"));
            if (CollectionUtils.isEmpty((Collection)recordList)) continue;
            isResetValue = true;
            Class<?> modelKlass = Class.forName(fileTab.getMetaModel().getFullName());
            this.resetPropertyValue(modelKlass, recordList);
            this.resetSubPropertyValue(modelKlass, jsonContext);
        }
        return isResetValue;
    }

    @Transactional
    private void resetPropertyValue(Class<? extends Model> klass, List<Object> recordList) throws ClassNotFoundException {
        JpaRepository modelRepo = JpaRepository.of(klass);
        for (Property prop : Mapper.of(klass).getProperties()) {
            if (prop.getTarget() == null || prop.isRequired()) continue;
            for (Object obj : recordList) {
                Map recordMap = Mapper.toMap((Object)EntityHelper.getEntity((Object)obj));
                Long id = Long.valueOf(recordMap.get("id").toString());
                Model bean = modelRepo.find(id);
                if (bean == null) continue;
                prop.set((Object)bean, null);
            }
        }
    }

    private void resetSubPropertyValue(Class<? extends Model> klass, JsonContext jsonContext) throws ClassNotFoundException {
        for (Property prop : Mapper.of(klass).getProperties()) {
            String simpleModelName;
            String field;
            if (prop.getTarget() == null || prop.isRequired() || !jsonContext.containsKey((Object)(field = this.inflector.camelize(simpleModelName = StringUtils.substringAfterLast((String)prop.getTarget().getName(), (String)"."), true) + "Set"))) continue;
            List recordList = (List)jsonContext.get((Object)field);
            Class<?> modelKlass = Class.forName(prop.getTarget().getName());
            this.resetPropertyValue(modelKlass, recordList);
        }
    }

    public void removeRecords(List<FileTab> fileTabList) throws ClassNotFoundException {
        for (FileTab fileTab : fileTabList) {
            String fieldName;
            String targetModelName = fileTab.getMetaModel().getFullName();
            Map<String, Object> jsonContextMap = this.dataImportService.createJsonContext(fileTab);
            JsonContext jsonContext = (JsonContext)jsonContextMap.get("jsonContext");
            List recordList = (List)jsonContext.get((Object)(fieldName = this.inflector.camelize(fileTab.getMetaModel().getName(), true) + "Set"));
            if (CollectionUtils.isEmpty((Collection)recordList)) continue;
            Class<?> modelKlass = Class.forName(targetModelName);
            this.removeRecord(fileTab, modelKlass, recordList, fileTabList);
            this.removeSubRecords(modelKlass, jsonContext);
        }
    }

    @Transactional
    public void removeRecord(FileTab fileTab, Class<? extends Model> modelKlass, List<Object> recordList, List<FileTab> fileTabList) throws ClassNotFoundException {
        JpaRepository modelRepo = JpaRepository.of(modelKlass);
        for (FileTab tab : fileTabList) {
            Property[] props;
            String fieldName;
            Map<String, Object> jsonContextMap = this.dataImportService.createJsonContext(tab);
            JsonContext jsonContext = (JsonContext)jsonContextMap.get("jsonContext");
            List recList = (List)jsonContext.get((Object)(fieldName = this.inflector.camelize(tab.getMetaModel().getName(), true) + "Set"));
            if (CollectionUtils.isEmpty((Collection)recList)) continue;
            Class<?> klass = Class.forName(tab.getMetaModel().getFullName());
            for (Property prop : props = Mapper.of(klass).getProperties()) {
                if (prop.getTarget() == null || prop.getTarget() != modelKlass || !prop.isRequired()) continue;
                this.removeRecord(tab, klass, recList, fileTabList);
            }
        }
        String ids = recordList.stream().map(obj -> {
            Map recordMap = Mapper.toMap((Object)EntityHelper.getEntity((Object)obj));
            return recordMap.get("id").toString();
        }).collect(Collectors.joining(","));
        modelRepo.all().filter("self.id IN (" + ids + ")").delete();
        fileTab.setAttrs(null);
        LOG.debug("Reset imported data : {}", (Object)modelKlass.getSimpleName());
    }

    @Transactional
    public void removeSubRecords(Class<? extends Model> klass, JsonContext jsonContext) throws ClassNotFoundException {
        for (Property prop : Mapper.of(klass).getProperties()) {
            String simpleModelName;
            String field;
            if (prop.getTarget() == null || prop.isCollection() || !jsonContext.containsKey((Object)(field = this.inflector.camelize(simpleModelName = StringUtils.substringAfterLast((String)prop.getTarget().getName(), (String)"."), true) + "Set"))) continue;
            List recList = (List)jsonContext.get((Object)field);
            String ids = recList.stream().map(obj -> {
                Map recordMap = Mapper.toMap((Object)EntityHelper.getEntity((Object)obj));
                return recordMap.get("id").toString();
            }).collect(Collectors.joining(","));
            JpaRepository modelRepo = JpaRepository.of(Class.forName(prop.getTarget().getName()));
            modelRepo.all().filter("self.id IN (" + ids + ")").delete();
        }
    }

    protected Map<String, String> getTabConfigDataMap(String[] row, List<String> keys) {
        HashMap<String, String> tabConfigDataMap = new HashMap<String, String>();
        for (String data : row) {
            String key;
            String[] keyValue;
            if (StringUtils.isBlank((CharSequence)data) || (keyValue = data.split("\\:")).length != 2 || !keys.contains(key = keyValue[0].replaceAll("(^\\h*)|(\\h*$)", "").trim().toLowerCase())) continue;
            tabConfigDataMap.put(key, keyValue[1].trim());
        }
        return tabConfigDataMap;
    }
}

