/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advanced.imports;

import com.axelor.apps.base.db.AdvancedImport;
import com.axelor.apps.base.db.FileField;
import com.axelor.apps.base.db.FileTab;
import com.axelor.apps.base.service.advanced.imports.AdvancedImportService;
import com.axelor.apps.base.service.advanced.imports.DataImportService;
import com.axelor.apps.base.service.advanced.imports.ValidatorService;
import com.axelor.apps.base.service.imports.listener.ImporterListener;
import com.axelor.apps.base.service.readers.DataReaderFactory;
import com.axelor.apps.base.service.readers.DataReaderService;
import com.axelor.apps.tool.service.TranslationService;
import com.axelor.common.Inflector;
import com.axelor.data.Listener;
import com.axelor.data.XStreamUtils;
import com.axelor.data.adapter.DataAdapter;
import com.axelor.data.adapter.JavaTimeAdapter;
import com.axelor.data.csv.CSVBind;
import com.axelor.data.csv.CSVConfig;
import com.axelor.data.csv.CSVImporter;
import com.axelor.data.csv.CSVInput;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.MetaSelect;
import com.axelor.meta.db.MetaSelectItem;
import com.axelor.meta.db.repo.MetaSelectItemRepository;
import com.axelor.meta.db.repo.MetaSelectRepository;
import com.axelor.rpc.Context;
import com.axelor.rpc.JsonContext;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.opencsv.CSVWriter;
import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;

public class DataImportServiceImpl
implements DataImportService {
    private static final char CSV_SEPRATOR = ';';
    private static final String INPUT_CALLABLE = "com.axelor.csv.script.ImportAdvancedImport:importGeneral";
    private static final String BIND_CALLABLE_DATE = "call:com.axelor.csv.script.ImportDateTime:importDate";
    private static final String BIND_CALLABLE_DATE_TIME = "call:com.axelor.csv.script.ImportDateTime:importDateTime";
    private static final String BIND_CALLABLE_META_FILE = "call:com.axelor.csv.script.ImportAdvancedImport:importPicture";
    private static final String MANY_TO_MANY = "ManyToMany";
    private static final String SPLIT = ".split('\\\\";
    private static final String AS_LIST = "') as List";
    private static final String REPLACE_SYMBOL = "$";
    private CSVInput csvInput;
    private Map<String, CSVBind> parentBindMap;
    private Map<String, CSVBind> subBindMap;
    private Map<String, Object> importContext;
    private Map<String, Object> fieldMap;
    private Map<String, Object> titleMap;
    private Map<String, DataAdapter> adapterMap;
    private List<String> ifList;
    private String fullFieldName;
    private String language;
    private File dataDir;
    private int counter = 1;
    private Inflector inflector = Inflector.getInstance();
    @Inject
    DataReaderFactory dataReaderFactory;
    @Inject
    private MetaFiles metaFiles;
    @Inject
    private MetaSelectItemRepository metaSelectItemRepo;
    @Inject
    private TranslationService translationService;
    @Inject
    private ValidatorService validatorService;
    @Inject
    private AdvancedImportService advancedImportService;
    @Inject
    private MetaSelectRepository metaSelectRepo;

    @Override
    public MetaFile importData(AdvancedImport advancedImport) throws IOException, AxelorException, ClassNotFoundException {
        this.adapterMap = new HashMap<String, DataAdapter>();
        this.importContext = new HashMap<String, Object>();
        this.language = advancedImport.getLanguageSelect();
        this.dataDir = Files.createTempDir();
        String extension = Files.getFileExtension((String)advancedImport.getImportFile().getFileName());
        DataReaderService reader = this.dataReaderFactory.getDataReader(extension);
        reader.initialize(advancedImport.getImportFile(), advancedImport.getFileSeparator());
        List<CSVInput> inputs = this.process(reader, advancedImport);
        if (advancedImport.getAttachment() != null) {
            this.processAttachments(advancedImport.getAttachment());
        }
        MetaFile logFile = this.importData(inputs);
        FileUtils.forceDelete((File)this.dataDir);
        return logFile;
    }

    private List<CSVInput> process(DataReaderService reader, AdvancedImport advancedImport) throws AxelorException, IOException, ClassNotFoundException {
        String[] sheets = reader.getSheetNames();
        boolean isConfig = advancedImport.getIsConfigInFile();
        int linesToIgnore = advancedImport.getNbOfFirstLineIgnore();
        boolean isTabConfig = advancedImport.getIsFileTabConfigAdded();
        ArrayList<CSVInput> inputList = new ArrayList<CSVInput>();
        this.validatorService.sortFileTabList(advancedImport.getFileTabList());
        for (FileTab fileTab : advancedImport.getFileTabList()) {
            if (!Arrays.stream(sheets).anyMatch(sheet -> sheet.equals(fileTab.getName()))) continue;
            this.initializeVariables();
            String fileName = this.createDataFileName(fileTab);
            this.csvInput = this.createCSVInput(fileTab, fileName);
            this.ifList = new ArrayList<String>();
            CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.dataDir, fileName)), ';');
            Throwable throwable = null;
            try {
                int totalLines = reader.getTotalLines(fileTab.getName());
                if (totalLines == 0) continue;
                Mapper mapper = this.advancedImportService.getMapper(fileTab.getMetaModel().getFullName());
                ArrayList<String[]> allLines = new ArrayList<String[]>();
                int startIndex = isConfig ? 1 : linesToIgnore;
                String[] row = reader.read(fileTab.getName(), startIndex, 0);
                String[] headers = this.createHeader(row, fileTab, isConfig, mapper);
                allLines.add(headers);
                int tabConfigRowCount = 0;
                if (isTabConfig) {
                    String[] objectRow = reader.read(fileTab.getName(), 0, 0);
                    tabConfigRowCount = this.advancedImportService.getTabConfigRowCount(fileTab.getName(), reader, totalLines, objectRow);
                }
                for (int line = startIndex = isConfig ? tabConfigRowCount + 3 : (fileTab.getAdvancedImport().getIsHeader() != false ? linesToIgnore + 1 : linesToIgnore); line < totalLines; ++line) {
                    String[] dataRow = reader.read(fileTab.getName(), line, row.length);
                    if (dataRow == null) continue;
                    String[] data = this.createData(dataRow, fileTab, isConfig, mapper);
                    allLines.add(data);
                }
                csvWriter.writeAll(allLines);
                csvWriter.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (csvWriter == null) continue;
                if (throwable != null) {
                    try {
                        csvWriter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                csvWriter.close();
                continue;
            }
            inputList.add(this.csvInput);
            this.importContext.put("ifConditions" + fileTab.getId(), this.ifList);
            this.importContext.put("jsonContextValues" + fileTab.getId(), this.createJsonContext(fileTab));
            this.importContext.put("actionsToApply" + fileTab.getId(), fileTab.getActions());
        }
        return inputList;
    }

    private void initializeVariables() {
        this.parentBindMap = new HashMap<String, CSVBind>();
        this.subBindMap = new HashMap<String, CSVBind>();
        this.fullFieldName = null;
        this.fieldMap = new HashMap<String, Object>();
        this.titleMap = new HashMap<String, Object>();
    }

    private String[] createHeader(String[] row, FileTab fileTab, boolean isConfig, Mapper mapper) throws ClassNotFoundException {
        Map<String, Object> map = isConfig ? this.fieldMap : this.titleMap;
        int rowCount = row.length;
        for (int cell = 0; cell < rowCount; ++cell) {
            if (Strings.isNullOrEmpty((String)row[cell])) continue;
            String value = row[cell].trim();
            map.put(isConfig ? (value.contains("(") ? value.split("\\(")[0] : value) : value, cell);
        }
        this.validatorService.sortFileFieldList(fileTab.getFileFieldList());
        ArrayList<String> headers = new ArrayList<String>();
        List<CSVBind> allBindings = new ArrayList<CSVBind>();
        int cnt = 0;
        HashMap<String, String> searchMap = new HashMap<String, String>();
        for (FileField fileField : fileTab.getFileFieldList()) {
            if (fileField.getImportType() == 4) continue;
            String key = isConfig ? this.validatorService.getField(fileField) : fileField.getColumnTitle();
            String column = "cell" + (cnt + 1);
            if (!CollectionUtils.isEmpty(fileTab.getSearchFieldSet()) && fileTab.getSearchFieldSet().contains((Object)fileField) && fileTab.getImportType() != 3) {
                searchMap.put(this.validatorService.getField(fileField), column);
            }
            if ((map.containsKey(key) || !isConfig && !fileTab.getAdvancedImport().getIsHeader().booleanValue()) && fileField.getIsMatchWithFile().booleanValue()) {
                headers.add(column);
            }
            allBindings = this.createCSVBinding(column, fileField, mapper, allBindings);
            ++cnt;
        }
        CSVBind fileTabBind = new CSVBind();
        fileTabBind.setField("fileTabId");
        fileTabBind.setExpression(fileTab.getId().toString());
        allBindings.add(fileTabBind);
        for (Map.Entry entry : searchMap.entrySet()) {
            if (Strings.isNullOrEmpty((String)this.csvInput.getSearch())) {
                this.csvInput.setSearch("self." + (String)entry.getKey() + " = :" + entry.getValue());
                continue;
            }
            this.csvInput.setSearch(this.csvInput.getSearch() + " AND self." + (String)entry.getKey() + " = :" + entry.getValue());
        }
        this.csvInput.setBindings(allBindings);
        return (String[])headers.stream().toArray(String[]::new);
    }

    private String[] createData(String[] dataRow, FileTab fileTab, boolean isConfig, Mapper mapper) throws ClassNotFoundException {
        Map<String, Object> map = isConfig ? this.fieldMap : this.titleMap;
        ArrayList<String> dataList = new ArrayList<String>();
        for (int fieldIndex = 0; fieldIndex < fileTab.getFileFieldList().size(); ++fieldIndex) {
            FileField fileField = fileTab.getFileFieldList().get(fieldIndex);
            String key = null;
            key = isConfig ? this.validatorService.getField(fileField) : fileField.getColumnTitle();
            if (!fileField.getIsMatchWithFile().booleanValue() || fileField.getImportType() == 4) continue;
            int cell = 0;
            if (map.containsKey(key)) {
                cell = (Integer)map.get(key);
            }
            int n = cell = !isConfig && fileTab.getAdvancedImport().getIsHeader() == false ? fieldIndex : cell;
            if (Strings.isNullOrEmpty((String)dataRow[cell])) {
                dataList.add(!Strings.isNullOrEmpty((String)fileField.getDefaultIfNotFound()) ? fileField.getDefaultIfNotFound().trim() : "");
                continue;
            }
            String dataCell = dataRow[cell].trim();
            this.checkAndWriteData(dataCell, fileTab.getMetaModel(), fileField, mapper, dataList);
        }
        return (String[])dataList.stream().toArray(String[]::new);
    }

    private void checkAndWriteData(String dataCell, MetaModel model, FileField fileField, Mapper mapper, List<String> dataList) throws ClassNotFoundException {
        Property parentProp = mapper.getProperty(fileField.getImportField().getName());
        if (Strings.isNullOrEmpty((String)fileField.getSubImportField())) {
            if (!Strings.isNullOrEmpty((String)parentProp.getSelection())) {
                this.writeSelectionData(parentProp.getSelection(), dataCell, fileField.getForSelectUse(), dataList);
            } else {
                dataList.add(dataCell);
            }
        } else {
            String[] subFields = fileField.getSubImportField().split("\\.");
            this.checkSubFieldAndWriteData(subFields, 0, parentProp, dataCell, fileField.getForSelectUse(), dataList);
        }
    }

    private void checkSubFieldAndWriteData(String[] subFields, int index, Property parentProp, String dataCell, int forSelectUse, List<String> dataList) throws ClassNotFoundException {
        if (index < subFields.length && parentProp.getTarget() != null) {
            Mapper mapper = this.advancedImportService.getMapper(parentProp.getTarget().getName());
            Property childProp = mapper.getProperty(subFields[index]);
            if (childProp != null && childProp.getTarget() != null) {
                this.checkSubFieldAndWriteData(subFields, index + 1, childProp, dataCell, forSelectUse, dataList);
            } else if (!Strings.isNullOrEmpty((String)childProp.getSelection())) {
                this.writeSelectionData(childProp.getSelection(), dataCell, forSelectUse, dataList);
            } else {
                dataList.add(dataCell);
            }
        }
    }

    private void writeSelectionData(String selection, String dataCell, int forSelectUse, List<String> dataList) {
        String value = this.getSelectionValue(selection, dataCell, forSelectUse);
        if (value == null) {
            return;
        }
        dataList.add(value);
    }

    private String getSelectionValue(String selection, String value, int forSelectUse) {
        if (forSelectUse != 1) {
            String title = null;
            title = forSelectUse == 2 ? this.translationService.getTranslationKey(value, this.language) : value;
            MetaSelect metaSelect = this.metaSelectRepo.findByName(selection);
            if (metaSelect == null) {
                return null;
            }
            MetaSelectItem metaSelectItem = (MetaSelectItem)this.metaSelectItemRepo.all().filter("self.title = ?1 AND self.select.id = ?2", new Object[]{title, metaSelect.getId()}).fetchOne();
            if (metaSelectItem != null) {
                return metaSelectItem.getValue();
            }
            return value;
        }
        return value;
    }

    private CSVInput createCSVInput(FileTab fileTab, String fileName) {
        boolean update = false;
        int importType = fileTab.getImportType();
        if (importType == 1 && !CollectionUtils.isEmpty(fileTab.getSearchFieldSet())) {
            update = true;
        }
        XStream stream = XStreamUtils.createXStream();
        stream.processAnnotations(CSVInput.class);
        CSVInput input = (CSVInput)stream.fromXML("<input update=\"" + update + "\" />");
        input.setFileName(fileName);
        input.setSeparator(';');
        input.setTypeName(fileTab.getMetaModel().getFullName());
        input.setCallable(INPUT_CALLABLE);
        input.setSearch(null);
        input.setBindings(new ArrayList());
        return input;
    }

    private List<CSVBind> createCSVBinding(String column, FileField fileField, Mapper mapper, List<CSVBind> allBindings) throws ClassNotFoundException {
        Property prop = mapper.getProperty(fileField.getImportField().getName());
        if (prop == null) {
            return allBindings;
        }
        CSVBind dummyBind = null;
        if (!fileField.getIsMatchWithFile().booleanValue()) {
            dummyBind = this.createCSVBind(null, column, null, null, null, null);
            allBindings.add(0, dummyBind);
        }
        if (Strings.isNullOrEmpty((String)fileField.getSubImportField())) {
            String expression = this.setExpression(column, fileField, prop);
            String adapter = null;
            String dateFormat = fileField.getDateFormat();
            if (Strings.isNullOrEmpty((String)expression) && !Strings.isNullOrEmpty((String)dateFormat)) {
                adapter = this.getAdapter(prop.getJavaType().getSimpleName(), dateFormat.trim());
            }
            CSVBind bind = null;
            if (!fileField.getIsMatchWithFile().booleanValue()) {
                dummyBind.setExpression(expression);
                dummyBind.setAdapter(adapter);
                bind = this.createCSVBind(column, prop.getName(), null, null, null, null);
                this.setImportIf(prop, bind, column);
            } else {
                bind = this.createCSVBind(column, prop.getName(), null, expression, adapter, null);
                this.setImportIf(prop, bind, column);
            }
            allBindings.add(bind);
            this.setSearch(column, prop.getName(), fileField, null);
        } else {
            CSVBind parentBind = null;
            if (this.parentBindMap.containsKey(prop.getName())) {
                parentBind = this.parentBindMap.get(prop.getName());
            } else {
                parentBind = this.createCSVBind(null, prop.getName(), null, null, null, true);
                parentBind.setBindings(new ArrayList());
                allBindings.add(parentBind);
                this.parentBindMap.put(prop.getName(), parentBind);
            }
            this.fullFieldName = prop.getName();
            String[] subFields = fileField.getSubImportField().split("\\.");
            this.createCSVSubBinding(subFields, 0, column, prop, fileField, parentBind, dummyBind);
        }
        if (!Strings.isNullOrEmpty((String)fileField.getNoImportIf())) {
            String importIf = this.convertExpression(fileField.getNoImportIf().trim(), fileField.getTargetType(), column);
            this.ifList.add(importIf);
        }
        return allBindings;
    }

    private void createCSVSubBinding(String[] subFields, int index, String column, Property parentProp, FileField fileField, CSVBind parentBind, CSVBind dummyBind) throws ClassNotFoundException {
        if (index < subFields.length) {
            if (parentProp.getTarget() == null) {
                return;
            }
            int importType = fileField.getImportType();
            String relationship = fileField.getRelationship();
            this.fullFieldName = this.fullFieldName + "." + subFields[index];
            Mapper mapper = this.advancedImportService.getMapper(parentProp.getTarget().getName());
            Property childProp = mapper.getProperty(subFields[index]);
            if (childProp != null && childProp.getTarget() != null) {
                CSVBind subBind = null;
                if (this.subBindMap.containsKey(this.fullFieldName)) {
                    subBind = this.subBindMap.get(this.fullFieldName);
                } else {
                    subBind = this.createCSVBind(null, childProp.getName(), null, null, null, true);
                    subBind.setBindings(new ArrayList());
                    parentBind.getBindings().add(subBind);
                    this.subBindMap.put(this.fullFieldName, subBind);
                }
                this.createCSVSubBinding(subFields, index + 1, column, childProp, fileField, subBind, dummyBind);
            } else {
                String expression = this.setExpression(column, fileField, childProp);
                String adapter = null;
                String dateFormat = fileField.getDateFormat();
                if (Strings.isNullOrEmpty((String)expression) && !Strings.isNullOrEmpty((String)dateFormat)) {
                    adapter = this.getAdapter(childProp.getJavaType().getSimpleName(), dateFormat.trim());
                }
                if (!fileField.getIsMatchWithFile().booleanValue()) {
                    this.createBindForNotMatchWithFile(column, importType, dummyBind, expression, adapter, parentBind, childProp);
                } else {
                    this.createBindForMatchWithFile(column, importType, expression, adapter, relationship, parentBind, childProp);
                }
                this.setSearch(column, childProp.getName(), fileField, parentBind);
                if (importType != 1) {
                    parentBind.setUpdate(false);
                }
            }
        }
    }

    private void createBindForNotMatchWithFile(String column, int importType, CSVBind dummyBind, String expression, String adapter, CSVBind parentBind, Property childProp) {
        dummyBind.setExpression(expression);
        dummyBind.setAdapter(adapter);
        if (importType == 2 || importType == 3) {
            CSVBind subBind = this.createCSVBind(column, childProp.getName(), null, null, null, null);
            this.setImportIf(childProp, subBind, column);
            parentBind.getBindings().add(subBind);
        }
    }

    private void createBindForMatchWithFile(String column, int importType, String expression, String adapter, String relationship, CSVBind parentBind, Property childProp) {
        if (importType != 1) {
            if (!Strings.isNullOrEmpty((String)expression) && expression.contains(BIND_CALLABLE_META_FILE) && importType == 3) {
                parentBind.setExpression(expression);
                return;
            }
            CSVBind subBind = this.createCSVBind(column, childProp.getName(), null, expression, adapter, null);
            this.setImportIf(childProp, subBind, column);
            parentBind.getBindings().add(subBind);
        } else if (!Strings.isNullOrEmpty((String)relationship) && relationship.equals(MANY_TO_MANY)) {
            parentBind.setColumn(column);
            parentBind.setExpression(expression);
        }
    }

    private void setSearch(String column, String field, FileField fileField, CSVBind bind) {
        int importType = fileField.getImportType();
        String relationship = fileField.getRelationship();
        String splitBy = fileField.getSplitBy();
        if (importType == 1 || importType == 2) {
            if (Strings.isNullOrEmpty((String)bind.getSearch())) {
                if (!Strings.isNullOrEmpty((String)relationship) && relationship.equals(MANY_TO_MANY) && !Strings.isNullOrEmpty((String)splitBy)) {
                    bind.setSearch("self." + field + " in :" + column);
                } else {
                    bind.setSearch("self." + field + " = :" + column);
                }
            } else {
                bind.setSearch(bind.getSearch() + " AND self." + field + " = :" + column);
            }
        }
    }

    private String setExpression(String column, FileField fileField, Property prop) {
        String expr = fileField.getExpression();
        String relationship = fileField.getRelationship();
        String splitBy = fileField.getSplitBy();
        String targetType = fileField.getTargetType();
        String expression = null;
        if (!Strings.isNullOrEmpty((String)expr)) {
            if ((expr = expr.trim()).contains(REPLACE_SYMBOL) && !Strings.isNullOrEmpty((String)column)) {
                if (!Strings.isNullOrEmpty((String)relationship) && relationship.equals(MANY_TO_MANY)) {
                    expression = !Strings.isNullOrEmpty((String)splitBy) ? expr.replace(REPLACE_SYMBOL, column) + SPLIT + splitBy + AS_LIST : expr.replace(REPLACE_SYMBOL, column);
                    return expression;
                }
                return this.convertExpression(expr, targetType, column);
            }
            if (!Strings.isNullOrEmpty((String)relationship) && relationship.equals(MANY_TO_MANY)) {
                expression = !Strings.isNullOrEmpty((String)splitBy) ? expr + SPLIT + splitBy + AS_LIST : "'" + expr + "'";
                return expression;
            }
            return this.createExpression(expr, targetType, prop, fileField.getForSelectUse());
        }
        if (!Strings.isNullOrEmpty((String)relationship) && relationship.equals(MANY_TO_MANY) && !targetType.equals("MetaFile")) {
            expression = !Strings.isNullOrEmpty((String)fileField.getSplitBy()) ? column + SPLIT + splitBy + AS_LIST : null;
            return expression;
        }
        if (!Strings.isNullOrEmpty((String)targetType) && targetType.equals("MetaFile")) {
            expression = "call:com.axelor.csv.script.ImportAdvancedImport:importPicture(" + column + ", '" + this.dataDir.toPath() + "')";
            return expression;
        }
        return expression;
    }

    private String createExpression(String expr, String type, Property prop, int forSelectUse) {
        String expression = null;
        switch (type) {
            case "LocalDate": {
                expression = "call:com.axelor.csv.script.ImportDateTime:importDate('" + expr + "')";
                break;
            }
            case "LocalTime": 
            case "LocalDateTime": 
            case "ZonedDateTime": {
                expression = "call:com.axelor.csv.script.ImportDateTime:importDateTime('" + expr + "')";
                break;
            }
            case "Integer": 
            case "BigDecimal": 
            case "Long": 
            case "String": {
                if (!Strings.isNullOrEmpty((String)prop.getSelection())) {
                    expression = this.getSelectionValue(prop.getSelection(), expr, forSelectUse);
                    if (!type.equals("String")) break;
                    expression = "'" + expression + "'";
                    break;
                }
                expression = type.equals("String") ? "'" + expr + "'" : expr;
                break;
            }
            default: {
                expression = "'" + expr + "'";
            }
        }
        return expression;
    }

    private String convertExpression(String expr, String type, String column) {
        String expression = null;
        switch (type) {
            case "Integer": {
                expression = expr.replace(REPLACE_SYMBOL, "Integer.parseInt(" + column + ")");
                break;
            }
            case "Long": {
                expression = expr.replace(REPLACE_SYMBOL, "Long.parseLong(" + column + ")");
                break;
            }
            case "BigDecimal": {
                expression = expr.replace(REPLACE_SYMBOL, "new BigDecimal(" + column + ")");
                break;
            }
            case "LocalDate": {
                expression = "call:com.axelor.csv.script.ImportDateTime:importDate('" + expr.replace(REPLACE_SYMBOL, column) + "')";
                break;
            }
            case "LocalTime": 
            case "LocalDateTime": 
            case "ZonedDateTime": {
                expression = "call:com.axelor.csv.script.ImportDateTime:importDateTime('" + expr.replace(REPLACE_SYMBOL, column) + "')";
                break;
            }
            default: {
                expression = expr.replace(REPLACE_SYMBOL, column);
            }
        }
        return expression;
    }

    private String getAdapter(String type, String dateFormat) {
        String adapter = null;
        switch (type) {
            case "LocalDate": {
                DataAdapter dateAdapter = this.createAdapter("LocalDate", dateFormat);
                adapter = dateAdapter.getName();
                break;
            }
            case "LocalDateTime": {
                DataAdapter dateTimeAdapter = this.createAdapter("LocalDateTime", dateFormat);
                adapter = dateTimeAdapter.getName();
                break;
            }
            case "LocalTime": {
                DataAdapter timeAdapter = this.createAdapter("LocalTime", dateFormat);
                adapter = timeAdapter.getName();
                break;
            }
            case "ZoneDateTime": {
                DataAdapter zonedDateTimeAdapter = this.createAdapter("ZonedDateTime", dateFormat);
                adapter = zonedDateTimeAdapter.getName();
            }
        }
        return adapter;
    }

    private DataAdapter createAdapter(String typeName, String format) {
        DataAdapter adapter = this.adapterMap.get(format);
        if (adapter == null) {
            adapter = new DataAdapter("Adapter" + this.counter, JavaTimeAdapter.class, new String[]{"type", typeName, "format", format});
            this.adapterMap.put(format, adapter);
            ++this.counter;
        }
        return adapter;
    }

    private CSVBind createCSVBind(String column, String field, String search, String expression, String adapter, Boolean update) {
        CSVBind bind = new CSVBind();
        bind.setColumn(column);
        bind.setField(field);
        bind.setSearch(search);
        bind.setExpression(expression);
        bind.setAdapter(adapter);
        if (update != null) {
            bind.setUpdate(update.booleanValue());
        }
        return bind;
    }

    private String createDataFileName(FileTab fileTab) {
        String fileName = null;
        MetaModel model = fileTab.getMetaModel();
        Long fileTabId = fileTab.getId();
        try {
            Mapper mapper = this.advancedImportService.getMapper(model.getFullName());
            fileName = this.inflector.camelize(mapper.getBeanClass().getSimpleName(), true) + fileTabId + ".csv";
        }
        catch (ClassNotFoundException e) {
            TraceBackService.trace((Throwable)e);
        }
        return fileName;
    }

    private void processAttachments(MetaFile attachments) throws ZipException, IOException {
        if (this.dataDir.isDirectory() && this.dataDir.list().length == 0) {
            return;
        }
        File attachmentFile = MetaFiles.getPath((MetaFile)attachments).toFile();
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(attachmentFile));){
            ZipEntry ze;
            byte[] buffer = new byte[1024];
            while ((ze = zis.getNextEntry()) != null) {
                String fileName = ze.getName();
                File extractFile = new File(this.dataDir, fileName);
                if (ze.isDirectory()) {
                    extractFile.mkdirs();
                    continue;
                }
                extractFile.getParentFile().mkdirs();
                extractFile.createNewFile();
                try (FileOutputStream fos = new FileOutputStream(extractFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                zis.closeEntry();
            }
        }
    }

    private MetaFile importData(List<CSVInput> inputs) throws IOException {
        if (CollectionUtils.isEmpty(inputs)) {
            return null;
        }
        CSVConfig config = new CSVConfig();
        config.setInputs(inputs);
        if (!CollectionUtils.isEmpty(this.adapterMap.values())) {
            config.getAdapters().addAll(this.adapterMap.values());
        }
        CSVImporter importer = new CSVImporter(config, this.dataDir.getAbsolutePath());
        ImporterListener listener = new ImporterListener("importData");
        importer.addListener((Listener)listener);
        importer.setContext(this.importContext);
        importer.run();
        if (!listener.isImported()) {
            MetaFile logFile = this.createImportLogFile(listener);
            return logFile;
        }
        return null;
    }

    private void setImportIf(Property prop, CSVBind bind, String column) {
        if (prop.isRequired()) {
            bind.setCondition(column.toString() + "!= null && !" + column.toString() + ".empty");
        }
    }

    private MetaFile createImportLogFile(ImporterListener listener) throws IOException {
        MetaFile logMetaFile = this.metaFiles.upload((InputStream)new ByteArrayInputStream(listener.getImportLog().getBytes()), "importLog-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".log");
        return logMetaFile;
    }

    @Override
    public Map<String, Object> createJsonContext(FileTab fileTab) {
        Class<?> klass = ((Object)((Object)fileTab)).getClass();
        Context context = new Context(klass);
        JsonContext jsonContext = new JsonContext(context, Mapper.of(klass).getProperty("attrs"), fileTab.getAttrs());
        HashMap<String, Object> _map = new HashMap<String, Object>();
        _map.put("context", context);
        _map.put("jsonContext", jsonContext);
        return _map;
    }
}

