/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advanced.imports;

import com.axelor.i18n.I18n;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelLogWriter {
    private Workbook workbook;
    private Sheet sheet;
    private File excelFile;

    public void initialize(String fileName) throws IOException {
        this.excelFile = File.createTempFile(fileName, ".xlsx");
        this.workbook = new XSSFWorkbook();
        this.sheet = this.workbook.createSheet(fileName);
    }

    public void writeHeader(String[] header) {
        Row headerRow = this.sheet.createRow(this.sheet.getFirstRowNum());
        for (int col = 0; col < header.length; ++col) {
            Cell headerCell = headerRow.createCell(col);
            headerCell.setCellValue(I18n.get((String)header[col]));
        }
    }

    public void writeBody(Map<String, Map<String, List<Integer>>> dataMap) {
        CellStyle cellStyle = this.setStyle();
        for (Map.Entry<String, Map<String, List<Integer>>> keyEntry : dataMap.entrySet()) {
            Row titleRow = this.sheet.createRow(this.sheet.getLastRowNum() + 1);
            Cell titleCell = titleRow.createCell(0);
            titleCell.setCellStyle(cellStyle);
            titleCell.setCellValue(keyEntry.getKey());
            for (Map.Entry<String, List<Integer>> dataEntry : keyEntry.getValue().entrySet()) {
                this.sheet.autoSizeColumn(0);
                this.sheet.autoSizeColumn(1);
                Row dataRow = this.sheet.createRow(this.sheet.getLastRowNum() + 1);
                Cell dataCell1 = dataRow.createCell(0);
                dataCell1.setCellValue(dataEntry.getKey());
                Cell dataCell2 = dataRow.createCell(1);
                if (CollectionUtils.isEmpty((Collection)dataEntry.getValue())) continue;
                dataCell2.setCellValue(dataEntry.getValue().stream().map(num -> String.valueOf(num)).collect(Collectors.joining(",")));
            }
        }
    }

    private CellStyle setStyle() {
        CellStyle cellStyle = this.workbook.createCellStyle();
        Font font = this.workbook.createFont();
        font.setBoldweight((short)700);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public void close() throws IOException {
        FileOutputStream fout = new FileOutputStream(this.excelFile);
        this.workbook.write((OutputStream)fout);
        fout.close();
    }

    public File getExcelFile() {
        return this.excelFile;
    }
}

