/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advanced.imports;

import com.axelor.apps.base.db.FileField;
import com.axelor.apps.base.db.FileTab;
import com.axelor.apps.base.service.advanced.imports.AdvancedImportService;
import com.axelor.apps.base.service.advanced.imports.FileFieldService;
import com.axelor.apps.base.service.advanced.imports.FileTabService;
import com.axelor.apps.base.service.advanced.imports.ValidatorService;
import com.axelor.db.EntityHelper;
import com.axelor.db.mapper.Mapper;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.rpc.Context;
import com.axelor.rpc.JsonContext;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class FileTabServiceImpl
implements FileTabService {
    @Inject
    MetaFieldRepository metaFieldRepo;
    @Inject
    FileFieldService fileFieldService;

    @Override
    public FileTab updateFields(FileTab fileTab) throws ClassNotFoundException {
        MetaModel model = fileTab.getMetaModel();
        if (model == null || CollectionUtils.isEmpty(fileTab.getFileFieldList())) {
            return fileTab;
        }
        ((ValidatorService)Beans.get(ValidatorService.class)).sortFileFieldList(fileTab.getFileFieldList());
        for (FileField fileField : fileTab.getFileFieldList()) {
            MetaField importField = (MetaField)((Object)this.metaFieldRepo.all().filter("self.label = ?1 AND self.metaModel.id = ?2", new Object[]{fileField.getColumnTitle(), model.getId()}).fetchOne());
            if (importField != null) {
                String relationship = importField.getRelationship();
                if (!Strings.isNullOrEmpty((String)relationship) && relationship.equals("OneToMany")) continue;
                fileField.setImportField(importField);
                if (!Strings.isNullOrEmpty((String)relationship)) {
                    String subImportField = this.getSubImportField(importField);
                    fileField.setSubImportField(subImportField);
                }
                fileField = this.fileFieldService.fillType(fileField);
                if (!Strings.isNullOrEmpty((String)relationship) && !fileField.getTargetType().equals("MetaFile")) {
                    fileField.setImportType(1);
                } else if (!Strings.isNullOrEmpty((String)fileField.getTargetType()) && fileField.getTargetType().equals("MetaFile")) {
                    fileField.setImportType(3);
                }
                fileField.setFullName(this.fileFieldService.computeFullName(fileField));
                continue;
            }
            fileField.setImportField(null);
            fileField.setSubImportField(null);
        }
        return fileTab;
    }

    private String getSubImportField(MetaField importField) throws ClassNotFoundException {
        String modelName = importField.getTypeName();
        MetaModel metaModel = ((MetaModelRepository)Beans.get(MetaModelRepository.class)).findByName(modelName);
        AdvancedImportService advancedImportService = (AdvancedImportService)Beans.get(AdvancedImportService.class);
        Mapper mapper = advancedImportService.getMapper(metaModel.getFullName());
        return mapper != null && mapper.getNameField() != null ? mapper.getNameField().getName() : null;
    }

    @Override
    public FileTab compute(FileTab fileTab) {
        if (CollectionUtils.isEmpty(fileTab.getFileFieldList())) {
            return fileTab;
        }
        for (FileField fileField : fileTab.getFileFieldList()) {
            fileField.setFullName(this.fileFieldService.computeFullName(fileField));
        }
        return fileTab;
    }

    @Override
    public String getShowRecordIds(FileTab fileTab, String field) throws ClassNotFoundException {
        Class<?> klass;
        Context context = new Context(((Object)((Object)fileTab)).getClass());
        JsonContext jsonContext = new JsonContext(context, Mapper.of(klass = Class.forName(((Object)((Object)fileTab)).getClass().getName())).getProperty("attrs"), fileTab.getAttrs());
        List recordList = (List)jsonContext.get((Object)field);
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            return null;
        }
        String ids = recordList.stream().map(obj -> {
            Map recordMap = Mapper.toMap((Object)EntityHelper.getEntity((Object)obj));
            return recordMap.get("id").toString();
        }).collect(Collectors.joining(","));
        return ids;
    }
}

