/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advanced.imports;

import com.axelor.apps.base.service.advanced.imports.ExcelLogWriter;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LogService {
    public static final String COMMON_KEY = "Common log";
    public static final String HEADER_COL1 = "Field names";
    public static final String HEADER_COL2 = "Row numbers";
    private String fileName;
    private Map<String, Map<String, List<Integer>>> logMap;
    @Inject
    private ExcelLogWriter logWriter;

    public void initialize(String fileName) {
        this.fileName = fileName;
        this.logMap = new LinkedHashMap<String, Map<String, List<Integer>>>();
    }

    public void addLog(String key, String log, Integer rowNumber) {
        Map<String, List<Integer>> map;
        if (!this.logMap.containsKey(key)) {
            this.logMap.put(key, new LinkedHashMap());
        }
        if (!(map = this.logMap.get(key)).containsKey(log)) {
            map.put(log, new ArrayList());
        }
        List<Integer> list = map.get(log);
        if (rowNumber != null) {
            list.add(rowNumber);
        }
    }

    public void write() throws IOException {
        this.logWriter.initialize(this.fileName);
        this.logWriter.writeHeader(new String[]{HEADER_COL1, HEADER_COL2});
        this.logWriter.writeBody(this.logMap);
    }

    public void close() throws IOException {
        this.logWriter.close();
    }

    public boolean isLogGenerated() {
        return !this.logMap.isEmpty();
    }

    public File getLogFile() {
        return this.logWriter.getExcelFile();
    }
}

