/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advanced.imports;

import com.axelor.apps.base.db.AdvancedImport;
import com.axelor.apps.base.db.FileField;
import com.axelor.apps.base.db.FileTab;
import com.axelor.apps.base.db.repo.FileTabRepository;
import com.axelor.apps.base.service.advanced.imports.ActionService;
import com.axelor.apps.base.service.advanced.imports.AdvancedImportService;
import com.axelor.apps.base.service.advanced.imports.LogService;
import com.axelor.apps.base.service.readers.DataReaderFactory;
import com.axelor.apps.base.service.readers.DataReaderService;
import com.axelor.common.Inflector;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.repo.MetaJsonFieldRepository;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ValidatorService {
    public static final String STRING = "String";
    public static final String INTEGER = "Integer";
    public static final String LONG = "Long";
    public static final String BIG_DECIMAL = "BigDecimal";
    public static final String BOOLEAN = "Boolean";
    public static final String ZONED_DATE_TIME = "ZonedDateTime";
    public static final String LOCAL_DATE_TIME = "LocalDateTime";
    public static final String LOCAL_TIME = "LocalTime";
    public static final String LOCAL_DATE = "LocalDate";
    private Map<String, Object> titleMap;
    private Map<String, Object> fieldMap;
    @Inject
    private MetaFiles metaFiles;
    @Inject
    private AdvancedImportService advancedImportService;
    @Inject
    private FileTabRepository fileTabRepo;
    @Inject
    private ActionService actionService;
    @Inject
    private DataReaderFactory dataReaderFactory;
    @Inject
    private LogService logService;
    @Inject
    private MetaJsonFieldRepository metaJsonFieldRepo;

    public boolean validate(AdvancedImport advancedImport) throws AxelorException, IOException, ClassNotFoundException {
        if (advancedImport.getImportFile() == null) {
            throw new AxelorException(4, I18n.get((String)"Data file doesn't exist"));
        }
        if (advancedImport.getAttachment() != null && !Files.getFileExtension((String)advancedImport.getAttachment().getFileName()).equals("zip")) {
            throw new AxelorException(4, I18n.get((String)"Attachments must be in zip format"));
        }
        String extension = Files.getFileExtension((String)advancedImport.getImportFile().getFileName());
        if (extension == null || !extension.equals("xlsx") && !extension.equals("xls") && !extension.equals("csv")) {
            throw new AxelorException(4, I18n.get((String)"Data file format is invalid"));
        }
        DataReaderService reader = this.dataReaderFactory.getDataReader(extension);
        reader.initialize(advancedImport.getImportFile(), advancedImport.getFileSeparator());
        return this.validate(reader, advancedImport);
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public boolean validate(DataReaderService reader, AdvancedImport advancedImport) throws IOException, ClassNotFoundException, AxelorException {
        boolean isLog = false;
        String[] sheets = reader.getSheetNames();
        this.validateTab(sheets, advancedImport);
        boolean isConfig = advancedImport.getIsConfigInFile();
        boolean isTabConfig = advancedImport.getIsFileTabConfigAdded();
        this.sortFileTabList(advancedImport.getFileTabList());
        for (FileTab fileTab : advancedImport.getFileTabList()) {
            if (!Arrays.stream(sheets).anyMatch(sheet -> sheet.equals(fileTab.getName()))) continue;
            this.fieldMap = new HashMap<String, Object>();
            this.titleMap = new HashMap<String, Object>();
            String sheet2 = fileTab.getName();
            this.logService.initialize(sheet2);
            this.validateModel(fileTab);
            int tabConfigRowCount = 0;
            int totalLines = reader.getTotalLines(fileTab.getName());
            if (isConfig) {
                String[] objectRow = reader.read(sheet2, 0, 0);
                if (isTabConfig) {
                    tabConfigRowCount = this.advancedImportService.getTabConfigRowCount(sheet2, reader, totalLines, objectRow);
                }
                this.validateObject(objectRow, fileTab, isTabConfig);
            }
            this.validateSearchFields(fileTab);
            this.validateObjectRequiredFields(fileTab);
            this.validateFieldAndData(reader, sheet2, fileTab, isConfig, isTabConfig, tabConfigRowCount);
            this.validateActions(fileTab);
            if (fileTab.getValidationLog() != null) {
                fileTab.setValidationLog(null);
            }
            if (this.logService.isLogGenerated()) {
                this.logService.write();
                this.logService.close();
                File logFile = this.logService.getLogFile();
                fileTab.setValidationLog(this.metaFiles.upload((InputStream)new FileInputStream(logFile), sheet2 + "_err.xlsx"));
                logFile.delete();
                isLog = true;
            } else {
                this.createCustomObjectSet(((Object)((Object)fileTab)).getClass().getName(), fileTab.getMetaModel().getFullName(), 0);
                this.createCustomButton(((Object)((Object)fileTab)).getClass().getName(), fileTab.getMetaModel().getFullName(), 1);
            }
            this.fileTabRepo.save((Model)((Object)fileTab));
        }
        return isLog;
    }

    private void validateTab(String[] sheets, AdvancedImport advancedImport) throws AxelorException {
        if (sheets == null) {
            return;
        }
        List<String> sheetList = Arrays.asList(sheets);
        List tabList = advancedImport.getFileTabList().stream().map(tab -> tab.getName()).collect(Collectors.toList());
        if (!CollectionUtils.containsAny(tabList, sheetList)) {
            throw new AxelorException(4, I18n.get((String)"File tab is not matched inside file"));
        }
    }

    private void validateModel(FileTab fileTab) throws IOException, AxelorException {
        if (fileTab.getMetaModel() == null) {
            throw new AxelorException(4, String.format(I18n.get((String)"Object is missing for tab configuration(%s)"), fileTab.getName()));
        }
    }

    private void validateObject(String[] row, FileTab fileTab, Boolean isTabConfig) throws IOException, AxelorException {
        int rowIndex;
        int n = rowIndex = isTabConfig != false ? 1 : 0;
        if (isTabConfig.booleanValue() && row[0] != null) {
            rowIndex = 0;
        }
        if (row == null || StringUtils.isBlank((CharSequence)row[rowIndex])) {
            throw new AxelorException(4, I18n.get((String)"Data file format is invalid"));
        }
        String object = row[rowIndex].trim();
        if (StringUtils.containsIgnoreCase((CharSequence)object, (CharSequence)"Object")) {
            String model = object.split("\\:")[1].trim();
            if (fileTab.getMetaModel() != null && !fileTab.getMetaModel().getName().equals(model)) {
                this.logService.addLog("Common log", "Object is not matched", rowIndex);
            }
        }
    }

    private void validateSearchFields(FileTab fileTab) throws AxelorException {
        if ((fileTab.getImportType() == 1 || fileTab.getImportType() == 2) && CollectionUtils.isEmpty(fileTab.getSearchFieldSet())) {
            throw new AxelorException(4, String.format(I18n.get((String)"Search fields are missing for the object(%s)"), fileTab.getMetaModel().getName()));
        }
    }

    private void validateObjectRequiredFields(FileTab fileTab) throws ClassNotFoundException, IOException, AxelorException {
        if (CollectionUtils.isEmpty(fileTab.getFileFieldList())) {
            throw new AxelorException(4, String.format(I18n.get((String)"There is no field for tab configuration(%s)"), fileTab.getName()));
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        for (FileField fileField : fileTab.getFileFieldList()) {
            if (fileField.getImportField() != null) {
                fieldList.add(fileField.getImportField().getName());
                continue;
            }
            this.logService.addLog("Missing import fields", fileField.getColumnTitle(), null);
        }
        if (fileTab.getImportType() == 1) {
            return;
        }
        if (fileTab.getMetaModel() != null) {
            Mapper mapper = this.advancedImportService.getMapper(fileTab.getMetaModel().getFullName());
            Model obj = null;
            try {
                obj = (Model)Class.forName(fileTab.getMetaModel().getFullName()).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                TraceBackService.trace((Throwable)e);
            }
            for (Property prop : mapper.getProperties()) {
                if (!prop.isRequired() || fieldList.contains(prop.getName()) || obj != null && mapper.get((Object)obj, prop.getName()) != null) continue;
                this.logService.addLog("Missing required fields", prop.getName(), null);
            }
        }
    }

    private void validateFieldAndData(DataReaderService reader, String sheet, FileTab fileTab, boolean isConfig, boolean isTabConfig, int tabConfigRowCount) throws ClassNotFoundException, IOException {
        AdvancedImport advancedImport = fileTab.getAdvancedImport();
        Map<String, Object> map = isConfig ? this.fieldMap : this.titleMap;
        int linesToIgnore = advancedImport.getNbOfFirstLineIgnore();
        int startIndex = isConfig ? 1 : linesToIgnore;
        String[] row = reader.read(sheet, startIndex, 0);
        if (row == null) {
            return;
        }
        this.sortFileFieldList(fileTab.getFileFieldList());
        int rowCount = row.length;
        for (int cell = 0; cell < rowCount; ++cell) {
            String value = row[cell];
            if (Strings.isNullOrEmpty((String)value)) continue;
            value = value.trim();
            map.put(isConfig ? (value.contains("(") ? value.split("\\(")[0] : value) : value, cell);
            if (cell != row.length - 1) continue;
            this.validateFields(startIndex, isConfig, fileTab);
        }
        if (!advancedImport.getIsValidateValue().booleanValue()) {
            return;
        }
        int totalLines = reader.getTotalLines(sheet);
        for (int line = startIndex = isConfig ? tabConfigRowCount + 3 : (fileTab.getAdvancedImport().getIsHeader() != false ? linesToIgnore + 1 : linesToIgnore); line < totalLines; ++line) {
            String[] dataRow = reader.read(sheet, line, row.length);
            if (dataRow == null) continue;
            this.validateData(dataRow, line, isConfig, fileTab);
        }
    }

    private void validateFields(int line, boolean isConfig, FileTab fileTab) throws IOException, ClassNotFoundException {
        List<String> relationalFieldList = fileTab.getFileFieldList().stream().filter(field -> !Strings.isNullOrEmpty((String)field.getSubImportField())).map(field -> field.getImportField().getName() + "." + field.getSubImportField()).collect(Collectors.toList());
        for (FileField fileField : fileTab.getFileFieldList()) {
            MetaField importField = fileField.getImportField();
            if (importField != null && Strings.isNullOrEmpty((String)fileField.getSubImportField())) {
                if (importField.getRelationship() != null) {
                    this.logService.addLog("Missing sub fields for", importField.getName(), line);
                }
                this.validateImportRequiredField(line, Class.forName(fileTab.getMetaModel().getFullName()), importField.getName(), fileField, null);
                this.validateDateField(line, fileField);
                continue;
            }
            if (Strings.isNullOrEmpty((String)fileField.getSubImportField())) continue;
            Mapper mapper = this.advancedImportService.getMapper(importField.getMetaModel().getFullName());
            Property parentProp = mapper.getProperty(importField.getName());
            if (parentProp == null) {
                return;
            }
            Property subProperty = this.getAndValidateSubField(line, parentProp, fileField, false);
            if (subProperty == null) continue;
            this.validateImportRequiredField(line, subProperty.getEntity(), subProperty.getName(), fileField, relationalFieldList);
            this.validateDateField(line, fileField);
        }
    }

    private void validateDateField(int line, FileField fileField) throws IOException {
        Integer rowNum;
        String type = fileField.getTargetType();
        Integer n = rowNum = fileField.getIsMatchWithFile() != false ? Integer.valueOf(line) : null;
        if (!Strings.isNullOrEmpty((String)type) && (type.equals(LOCAL_DATE) || type.equals(LOCAL_DATE_TIME) || type.equals(LOCAL_TIME) || type.equals(ZONED_DATE_TIME))) {
            String field = this.getField(fileField);
            if (Strings.isNullOrEmpty((String)fileField.getDateFormat()) && Strings.isNullOrEmpty((String)fileField.getExpression())) {
                this.logService.addLog("Missing date format or expression", field, rowNum);
            }
        }
    }

    private void validateImportRequiredField(int line, Class<?> model, String fieldName, FileField fileField, List<String> relationalFieldList) throws IOException, ClassNotFoundException {
        Mapper mapper = this.advancedImportService.getMapper(model.getName());
        String field = this.getField(fileField);
        Integer rowNum = fileField.getIsMatchWithFile() != false ? Integer.valueOf(line) : null;
        int importType = fileField.getImportType();
        for (Property prop : mapper.getProperties()) {
            if (!prop.isRequired()) continue;
            if (prop.getName().equals(fieldName) && importType == 4) {
                this.logService.addLog("Fields can't be ignore", field, rowNum);
                continue;
            }
            if (importType != 2 && importType != 3 || !field.contains(".") || fileField.getTargetType().equals("MetaFile")) continue;
            String newField = StringUtils.substringBeforeLast((String)field, (String)".");
            if (relationalFieldList.contains(newField = newField + "." + prop.getName())) continue;
            this.logService.addLog("Missing required fields", newField, null);
        }
    }

    private void validateData(String[] dataRow, int line, boolean isConfig, FileTab fileTab) throws IOException, ClassNotFoundException {
        Map<String, Object> map = isConfig ? this.fieldMap : this.titleMap;
        for (int fieldIndex = 0; fieldIndex < fileTab.getFileFieldList().size(); ++fieldIndex) {
            Property subProperty;
            FileField fileField = fileTab.getFileFieldList().get(fieldIndex);
            if (!fileField.getIsMatchWithFile().booleanValue() || !Strings.isNullOrEmpty((String)fileField.getExpression())) continue;
            Mapper mapper = null;
            Property property = null;
            String key = null;
            key = isConfig ? this.getField(fileField) : fileField.getColumnTitle();
            int cellIndex = 0;
            if (map.containsKey(key)) {
                cellIndex = (Integer)map.get(key);
            }
            int n = cellIndex = !isConfig && fileTab.getAdvancedImport().getIsHeader() == false ? fieldIndex : cellIndex;
            if (fileField.getImportField() != null) {
                mapper = this.advancedImportService.getMapper(fileField.getImportField().getMetaModel().getFullName());
                property = mapper.getProperty(fileField.getImportField().getName());
            }
            if (property != null && Strings.isNullOrEmpty((String)fileField.getSubImportField())) {
                if (this.validateDataRequiredField(dataRow, cellIndex, line, Class.forName(fileTab.getMetaModel().getFullName()), property.getName(), fileField) || !Strings.isNullOrEmpty((String)property.getSelection()) && fileField.getForSelectUse() != 1) continue;
                this.validateDataType(dataRow, cellIndex, line, property.getJavaType().getSimpleName(), fileField);
                continue;
            }
            if (Strings.isNullOrEmpty((String)fileField.getSubImportField()) || (subProperty = this.getAndValidateSubField(line, property, fileField, true)) == null || this.validateDataRequiredField(dataRow, cellIndex, line, subProperty.getEntity(), subProperty.getName(), fileField) || !Strings.isNullOrEmpty((String)subProperty.getSelection()) && fileField.getForSelectUse() != 1) continue;
            this.validateDataType(dataRow, cellIndex, line, subProperty.getJavaType().getSimpleName(), fileField);
        }
    }

    private boolean validateDataRequiredField(String[] row, int cell, int line, Class<?> model, String fieldName, FileField fileField) throws IOException, ClassNotFoundException {
        boolean flag = false;
        String field = this.getField(fileField);
        int importType = fileField.getImportType();
        Mapper mapper = this.advancedImportService.getMapper(model.getName());
        Property prop = mapper.getProperty(fieldName);
        if (prop != null) {
            if (prop.isRequired() && Strings.isNullOrEmpty((String)row[cell]) && importType != 1) {
                this.logService.addLog("Missing data for required fields", field, line);
            } else if (importType == 4) {
                flag = true;
                return flag;
            }
        }
        return flag;
    }

    private Property getAndValidateSubField(int line, Property parentProp, FileField fileField, boolean isLog) throws IOException, ClassNotFoundException {
        String field = this.getField(fileField);
        Integer rowNum = fileField.getIsMatchWithFile() != false ? Integer.valueOf(line) : null;
        String[] subFields = fileField.getSubImportField().split("\\.");
        return this.getAndValidateSubField(subFields, 0, rowNum, parentProp, field, isLog);
    }

    public Property getAndValidateSubField(String[] subFields, int index, Integer rowNum, Property parentProp, String field, boolean isLog) throws IOException, ClassNotFoundException {
        Property subProperty = null;
        if (parentProp.getTarget() != null) {
            Mapper mapper = this.advancedImportService.getMapper(parentProp.getTarget().getName());
            Property childProp = mapper.getProperty(subFields[index]);
            if (childProp == null && !isLog) {
                this.logService.addLog("Invalid fields", field, rowNum);
            }
            if (childProp != null && childProp.getTarget() != null) {
                if (index != subFields.length - 1) {
                    subProperty = this.getAndValidateSubField(subFields, index + 1, rowNum, childProp, field, isLog);
                } else {
                    subProperty = childProp;
                    if (!isLog) {
                        this.logService.addLog("Missing sub fields for", field, rowNum);
                    }
                }
            } else {
                subProperty = childProp;
            }
        }
        return subProperty;
    }

    private void validateDataType(String[] row, int cell, int line, String type, FileField fileField) throws IOException {
        if (Strings.isNullOrEmpty((String)row[cell])) {
            return;
        }
        String field = this.getField(fileField);
        String value = row[cell].trim();
        switch (type) {
            case "Integer": 
            case "Long": 
            case "BigDecimal": {
                this.checkNumeric(value, line, field, type);
                break;
            }
            case "LocalDate": 
            case "ZonedDateTime": 
            case "LocalDateTime": 
            case "LocalTime": {
                this.checkDateTime(value, line, type, fileField);
                break;
            }
            case "Boolean": {
                String boolPat = "(true|false|1|0|no|yes|n|y)";
                if (value.matches(boolPat)) break;
                this.logService.addLog("Invalid type of data", field + "(" + type + ")", line);
                break;
            }
            default: {
                if (type.equals(STRING)) break;
                try {
                    new BigInteger(value);
                    break;
                }
                catch (Exception e) {
                    this.logService.addLog("Invalid type of data", field + "(" + type + ")", line);
                }
            }
        }
    }

    private void checkNumeric(String value, int line, String field, String type) throws IOException {
        switch (type) {
            case "Integer": {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.logService.addLog("Invalid type of data", field + "(" + type + ")", line);
                }
                break;
            }
            case "Long": {
                try {
                    Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    this.logService.addLog("Invalid type of data", field + "(" + type + ")", line);
                }
                break;
            }
            case "BigDecimal": {
                try {
                    new BigDecimal(value);
                    break;
                }
                catch (NumberFormatException e) {
                    this.logService.addLog("Invalid type of data", field + "(" + type + ")", line);
                }
            }
        }
    }

    private void checkDateTime(String value, int line, String type, FileField fileField) throws IOException {
        if (!Strings.isNullOrEmpty((String)fileField.getDateFormat()) && Strings.isNullOrEmpty((String)fileField.getExpression())) {
            String pattern = fileField.getDateFormat().trim();
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
                switch (type) {
                    case "LocalDate": {
                        LocalDate.parse(value, formatter);
                        break;
                    }
                    case "LocalTime": {
                        LocalTime.parse(value, formatter);
                        break;
                    }
                    case "LocalDateTime": {
                        LocalDateTime.parse(value, formatter);
                        break;
                    }
                    case "ZonedDateTime": {
                        ZonedDateTime.parse(value, formatter);
                    }
                }
            }
            catch (DateTimeParseException e) {
                this.logService.addLog("Invalid type of data", this.getField(fileField) + "(" + type + ")", line);
            }
        }
    }

    private void validateActions(FileTab fileTab) {
        String actions = fileTab.getActions();
        if (StringUtils.isBlank((CharSequence)actions)) {
            return;
        }
        if (!this.actionService.validate(actions).booleanValue()) {
            this.logService.addLog("Common log", String.format("Action does not exists or invalid for the object(%s)", fileTab.getMetaModel().getName()), 1);
        }
    }

    public String getField(FileField fileField) {
        String field = !Strings.isNullOrEmpty((String)fileField.getSubImportField()) ? fileField.getImportField().getName() + "." + fileField.getSubImportField().trim() : fileField.getImportField().getName();
        return field;
    }

    public void sortFileTabList(List<FileTab> fileTabList) {
        fileTabList.sort((tab1, tab2) -> tab1.getSequence().compareTo(tab2.getSequence()));
    }

    public void sortFileFieldList(List<FileField> fileFieldList) {
        fileFieldList.sort((field1, field2) -> field1.getSequence().compareTo(field2.getSequence()));
    }

    public void addLog(BufferedWriter writer, String errorType, String log) throws IOException {
        writer.write(I18n.get((String)errorType) + ":   " + log);
        writer.newLine();
    }

    @Transactional(rollbackOn={Exception.class})
    public void createCustomObjectSet(String modelName, String targetModelName, int sequence) {
        String simpleModelName = StringUtils.substringAfterLast((String)targetModelName, (String)".");
        String fieldName = Inflector.getInstance().camelize(simpleModelName, true) + "Set";
        String viewName = Inflector.getInstance().dasherize(simpleModelName);
        if (this.metaJsonFieldRepo.all().filter("self.type = ?1 AND self.model = ?2 AND self.targetModel = ?3", new Object[]{"many-to-many", modelName, targetModelName}).count() > 0L) {
            return;
        }
        MetaJsonField jsonField = new MetaJsonField();
        jsonField.setName(fieldName);
        jsonField.setType("many-to-many");
        jsonField.setTitle(Inflector.getInstance().titleize(simpleModelName));
        jsonField.setSequence(Integer.valueOf(sequence));
        jsonField.setModel(modelName);
        jsonField.setModelField("attrs");
        jsonField.setTargetModel(targetModelName);
        jsonField.setGridView(viewName + "-grid");
        jsonField.setFormView(viewName + "-form");
        jsonField.setWidgetAttrs("{\"colSpan\": \"12\"}");
        jsonField.setShowIf(fieldName + " != null && $record.advancedImport.statusSelect > 0");
        this.metaJsonFieldRepo.save((Model)jsonField);
    }

    @Transactional(rollbackOn={Exception.class})
    public void createCustomButton(String modelName, String targetModelName, int sequence) {
        String simpleModelName = StringUtils.substringAfterLast((String)targetModelName, (String)".");
        String fieldName = Inflector.getInstance().camelize(simpleModelName, true) + "Set";
        String buttonName = "show" + fieldName + "Btn";
        if (this.metaJsonFieldRepo.all().filter("self.name = ?1 AND self.type = ?2 AND self.model = ?3", new Object[]{buttonName, "button", modelName}).count() > 0L) {
            return;
        }
        MetaJsonField jsonField = new MetaJsonField();
        jsonField.setName(buttonName);
        jsonField.setType("button");
        jsonField.setTitle("Show " + Inflector.getInstance().titleize(simpleModelName));
        jsonField.setSequence(Integer.valueOf(sequence));
        jsonField.setModel(modelName);
        jsonField.setModelField("attrs");
        jsonField.setOnClick("action-file-tab-method-show-record,close");
        jsonField.setWidgetAttrs("{\"colSpan\": \"4\"}");
        jsonField.setShowIf(fieldName + " != null && $record.advancedImport.statusSelect > 0");
        this.metaJsonFieldRepo.save((Model)jsonField);
    }
}

