/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advancedExport;

import com.axelor.apps.base.db.AdvancedExport;
import com.axelor.apps.base.service.advancedExport.AdvancedExportGenerator;
import com.axelor.apps.base.service.advancedExport.CsvExportGenerator;
import com.axelor.apps.base.service.advancedExport.ExcelExportGenerator;
import com.axelor.apps.base.service.advancedExport.PdfExportGenerator;
import com.axelor.exception.AxelorException;
import com.google.inject.Singleton;

@Singleton
public class AdvancedExportGeneratorFactory {
    public AdvancedExportGenerator getAdvancedExportGenerator(AdvancedExport advancedExport, String fileType) throws AxelorException {
        AdvancedExportGenerator exportGenerator = null;
        switch (fileType) {
            case "PDF": {
                exportGenerator = new PdfExportGenerator(advancedExport);
                break;
            }
            case "EXCEL": {
                exportGenerator = new ExcelExportGenerator(advancedExport);
                break;
            }
            case "CSV": {
                exportGenerator = new CsvExportGenerator(advancedExport);
                break;
            }
        }
        return exportGenerator;
    }
}

