/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advancedExport;

import com.axelor.apps.base.db.AdvancedExport;
import com.axelor.apps.base.db.AdvancedExportLine;
import com.axelor.apps.base.service.advancedExport.AdvancedExportGenerator;
import com.axelor.apps.base.service.advancedExport.AdvancedExportGeneratorFactory;
import com.axelor.apps.base.service.advancedExport.AdvancedExportService;
import com.axelor.apps.tool.NamingTool;
import com.axelor.auth.AuthUtils;
import com.axelor.db.JPA;
import com.axelor.db.JpaSecurity;
import com.axelor.db.hibernate.type.JsonFunction;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.MetaSelect;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.meta.db.repo.MetaSelectRepository;
import com.axelor.rpc.filter.Filter;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.QueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedExportServiceImpl
implements AdvancedExportService {
    private static final Logger log = LoggerFactory.getLogger(AdvancedExportServiceImpl.class);
    @Inject
    private MetaFieldRepository metaFieldRepo;
    @Inject
    private MetaModelRepository metaModelRepo;
    @Inject
    private MetaSelectRepository metaSelectRepo;
    @Inject
    private AdvancedExportGeneratorFactory exportGeneratorFactory;
    private LinkedHashSet<String> joinFieldSet = new LinkedHashSet();
    private LinkedHashSet<String> selectionJoinFieldSet = new LinkedHashSet();
    private List<Object> params = null;
    private String exportFileName;
    private String language;
    private String selectField;
    private String aliasName;
    private boolean isReachMaxExportLimit;
    private boolean isNormalField;
    private boolean isSelectionField = false;
    private int msi;
    private int mt;

    @Override
    public Query getAdvancedExportQuery(AdvancedExport advancedExport, List<Long> recordIds) throws AxelorException {
        StringBuilder selectFieldBuilder = new StringBuilder();
        StringBuilder orderByFieldBuilder = new StringBuilder();
        this.joinFieldSet.clear();
        this.selectionJoinFieldSet.clear();
        this.isNormalField = true;
        this.selectField = "";
        this.msi = 0;
        this.mt = 0;
        int col = 0;
        this.language = AuthUtils.getUser().getLanguage();
        try {
            for (AdvancedExportLine advancedExportLine : advancedExport.getAdvancedExportLineList()) {
                String[] splitField = advancedExportLine.getTargetField().split("\\.");
                String alias = "Col_" + col;
                this.createQueryParts(splitField, 0, advancedExport.getMetaModel());
                selectFieldBuilder.append(this.aliasName + this.selectField + " AS " + alias + ",");
                if (advancedExportLine.getOrderBy().booleanValue()) {
                    orderByFieldBuilder.append(alias + " " + advancedExportLine.getOrderByType() + ",");
                }
                this.selectField = "";
                this.aliasName = "";
                ++col;
            }
        }
        catch (ClassNotFoundException e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException((Throwable)e, 4);
        }
        return this.createQuery(this.createQueryBuilder(advancedExport.getMetaModel(), selectFieldBuilder, recordIds, orderByFieldBuilder));
    }

    private void createQueryParts(String[] splitField, int parentIndex, MetaModel metaModel) throws ClassNotFoundException {
        while (parentIndex <= splitField.length - 1) {
            MetaField relationalField = (MetaField)((Object)this.metaFieldRepo.all().filter("self.name = ?1 and self.metaModel = ?2", new Object[]{splitField[parentIndex], metaModel}).fetchOne());
            MetaModel subMetaModel = (MetaModel)this.metaModelRepo.all().filter("self.name = ?1", new Object[]{relationalField.getTypeName()}).fetchOne();
            if (!Strings.isNullOrEmpty((String)relationalField.getRelationship())) {
                this.checkRelationalField(splitField, parentIndex);
            } else {
                this.checkSelectionField(splitField, parentIndex, metaModel);
                this.checkNormalField(splitField, parentIndex);
            }
            ++parentIndex;
            metaModel = subMetaModel;
        }
    }

    private void checkRelationalField(String[] splitField, int parentIndex) {
        String tempAliasName = "";
        this.isNormalField = false;
        if (parentIndex != 0) {
            this.aliasName = tempAliasName = this.isKeyword(splitField, 0);
            for (int subIndex = 1; subIndex <= parentIndex; ++subIndex) {
                tempAliasName = this.isKeyword(splitField, subIndex);
                if (this.aliasName.equals(splitField[parentIndex])) continue;
                this.joinFieldSet.add("LEFT JOIN " + this.aliasName + "." + splitField[subIndex] + " " + tempAliasName);
                this.aliasName = tempAliasName;
            }
        } else {
            tempAliasName = this.isKeyword(splitField, parentIndex);
            this.joinFieldSet.add("LEFT JOIN self." + splitField[parentIndex] + " " + tempAliasName);
            this.aliasName = tempAliasName;
        }
    }

    private String isKeyword(String[] fieldNames, int ind) {
        if (NamingTool.isKeyword((String)fieldNames[ind])) {
            return fieldNames[ind] + "_id";
        }
        return fieldNames[ind];
    }

    private void checkSelectionField(String[] fieldName, int index, MetaModel metaModel) throws ClassNotFoundException {
        Class<?> klass = Class.forName(metaModel.getFullName());
        Mapper mapper = Mapper.of(klass);
        MetaSelect metaSelect = this.metaSelectRepo.findByName(mapper.getProperty(fieldName[index]).getSelection());
        if (metaSelect != null) {
            this.isSelectionField = true;
            String alias = "self";
            ++this.msi;
            ++this.mt;
            if (!this.isNormalField && index != 0) {
                alias = this.aliasName;
            }
            this.addSelectionField(fieldName[index], alias, metaSelect.getId());
        }
    }

    private void addSelectionField(String fieldName, String alias, Long metaSelectId) {
        String selectionJoin = "LEFT JOIN MetaSelectItem " + "msi_" + this.msi + " ON CAST(" + alias + "." + fieldName + " AS text) = " + "msi_" + this.msi + ".value AND " + "msi_" + this.msi + ".select = " + metaSelectId;
        if (this.language.equals("fr")) {
            selectionJoin = selectionJoin + " LEFT JOIN MetaTranslation " + "mt_" + this.mt + " ON " + "msi_" + this.msi + ".title = " + "mt_" + this.mt + ".key AND " + "mt_" + this.mt + ".language = '" + this.language + "'";
        }
        this.selectionJoinFieldSet.add(selectionJoin);
    }

    private void checkNormalField(String[] splitField, int parentIndex) {
        if (this.isSelectionField) {
            if (parentIndex == 0) {
                this.selectField = "";
            }
            if (this.language.equals("fr")) {
                this.aliasName = "COALESCE (NULLIF(" + "mt_" + this.mt + ".message, '') , " + "msi_" + this.msi + ".title)";
                this.selectField = this.selectField + "";
            } else {
                this.aliasName = "msi_" + this.msi;
                this.selectField = this.selectField + ".title";
            }
            this.isSelectionField = false;
        } else {
            if (parentIndex == 0) {
                this.selectField = "";
                this.aliasName = "self";
            }
            this.selectField = this.selectField + "." + splitField[parentIndex];
        }
    }

    private StringBuilder createQueryBuilder(MetaModel metaModel, StringBuilder selectFieldBuilder, List<Long> recordIds, StringBuilder orderByFieldBuilder) {
        String joinField = "";
        String selectionJoinField = "";
        String orderByCol = "";
        joinField = String.join((CharSequence)" ", this.joinFieldSet);
        selectionJoinField = String.join((CharSequence)" ", this.selectionJoinFieldSet);
        this.params = null;
        String criteria = this.getCriteria(metaModel, recordIds);
        if (!orderByFieldBuilder.toString().equals("")) {
            orderByCol = " ORDER BY " + orderByFieldBuilder.substring(0, orderByFieldBuilder.length() - 1);
        }
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT NEW List(");
        queryBuilder.append(selectFieldBuilder.substring(0, selectFieldBuilder.length() - 1));
        queryBuilder.append(") FROM " + metaModel.getName() + " self ");
        queryBuilder.append(!Strings.isNullOrEmpty((String)joinField) ? joinField + " " : "");
        queryBuilder.append(!Strings.isNullOrEmpty((String)selectionJoinField) ? selectionJoinField + " " : "");
        queryBuilder.append(!Strings.isNullOrEmpty((String)criteria) ? criteria : "");
        queryBuilder.append(!Strings.isNullOrEmpty((String)orderByCol) ? orderByCol : "");
        return queryBuilder;
    }

    private String getCriteria(MetaModel metaModel, List<Long> recordIds) {
        String criteria = null;
        if (recordIds != null) {
            criteria = recordIds.toString().substring(1, recordIds.toString().length() - 1);
            log.trace("criteria : {}", (Object)recordIds.toString());
            criteria = " WHERE self.id IN (" + criteria + ")";
        }
        Filter filter = this.getJpaSecurityFilter(metaModel);
        JoinHelper helper = null;
        if (filter != null) {
            String permissionFilter = filter.getQuery();
            try {
                helper = new JoinHelper(Class.forName(metaModel.getFullName()));
                permissionFilter = helper.parse(permissionFilter).toString();
            }
            catch (ClassNotFoundException e) {
                TraceBackService.trace((Throwable)e, (String)e.getMessage());
            }
            criteria = recordIds == null ? " WHERE " + permissionFilter : criteria + " AND (" + permissionFilter + ")";
            this.params = filter.getParams();
        }
        if (helper != null) {
            criteria = helper.toString() + " " + criteria;
        }
        return criteria;
    }

    @Override
    public Filter getJpaSecurityFilter(MetaModel metaModel) {
        JpaSecurity jpaSecurity = (JpaSecurity)Beans.get(JpaSecurity.class);
        try {
            return jpaSecurity.getFilter(JpaSecurity.CAN_EXPORT, Class.forName(metaModel.getFullName()), new Long[]{null});
        }
        catch (ClassNotFoundException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private Query createQuery(StringBuilder queryBuilder) {
        int n = 0;
        int i = queryBuilder.indexOf("?");
        while (i > -1) {
            queryBuilder.replace(i, i + 1, "?" + ++n);
            i = queryBuilder.indexOf("?", i + 1);
        }
        log.debug("query : {}", (Object)queryBuilder.toString());
        TypedQuery query = JPA.em().createQuery(queryBuilder.toString(), List.class);
        if (this.params != null) {
            for (i = 0; i < this.params.size(); ++i) {
                query.setParameter(i + 1, this.params.get(i));
            }
        }
        return query;
    }

    private List<AdvancedExportLine> sortAdvancedExportLineList(List<AdvancedExportLine> advancedExportLineList) {
        advancedExportLineList.sort(new Comparator<AdvancedExportLine>(){

            @Override
            public int compare(AdvancedExportLine line1, AdvancedExportLine line2) {
                if (line1.getSequence() == line2.getSequence()) {
                    if (line1.getId() > line2.getId()) {
                        return 1;
                    }
                    return -1;
                }
                return line1.getSequence() - line2.getSequence();
            }
        });
        return advancedExportLineList;
    }

    @Override
    public File export(AdvancedExport advancedExport, List<Long> recordIds, String fileType) throws AxelorException {
        AdvancedExportGenerator exportGenerator = this.exportGeneratorFactory.getAdvancedExportGenerator(advancedExport, fileType);
        this.sortAdvancedExportLineList(advancedExport.getAdvancedExportLineList());
        Query query = this.getAdvancedExportQuery(advancedExport, recordIds);
        File file = exportGenerator.generateFile(query);
        this.isReachMaxExportLimit = exportGenerator.getIsReachMaxExportLimit();
        this.exportFileName = exportGenerator.getExportFileName();
        return file;
    }

    @Override
    public boolean getIsReachMaxExportLimit() {
        return this.isReachMaxExportLimit;
    }

    @Override
    public String getExportFileName() {
        return this.exportFileName;
    }

    private static class JoinHelper {
        private Class<?> beanClass;
        private Map<String, String> joins = Maps.newLinkedHashMap();
        private static final Pattern pathPattern = Pattern.compile("self\\.((?:[a-zA-Z_]\\w+)(?:(?:\\[\\])?\\.\\w+)*)");

        public JoinHelper(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        private String parse(String filter) {
            String result = "";
            Matcher matcher = pathPattern.matcher(filter);
            int last = 0;
            while (matcher.find()) {
                MatchResult matchResult = matcher.toMatchResult();
                String alias = this.joinName(matchResult.group(1));
                if (alias == null) {
                    alias = "self." + matchResult.group(1);
                }
                result = result + filter.substring(last, matchResult.start()) + alias;
                last = matchResult.end();
            }
            if (last < filter.length()) {
                result = result + filter.substring(last);
            }
            return result;
        }

        public String joinName(String name) {
            Mapper mapper = Mapper.of(this.beanClass);
            String[] path = name.split("\\.");
            String prefix = null;
            String variable = name;
            if (path.length > 1) {
                variable = path[path.length - 1];
                String joinOn = null;
                Mapper currentMapper = mapper;
                for (int i = 0; i < path.length - 1; ++i) {
                    String item = path[i].replace("[]", "");
                    Property property = currentMapper.getProperty(item);
                    if (property == null) {
                        throw new QueryException("could not resolve property: " + item + " of: " + currentMapper.getBeanClass().getName());
                    }
                    if (property.isJson()) {
                        return JsonFunction.fromPath((String)name).toString();
                    }
                    if (prefix == null) {
                        joinOn = "self." + item;
                        prefix = "_" + item;
                    } else {
                        joinOn = prefix + "." + item;
                        prefix = prefix + "_" + item;
                    }
                    if (!this.joins.containsKey(joinOn)) {
                        this.joins.put(joinOn, prefix);
                    }
                    if (property.getTarget() != null) {
                        currentMapper = Mapper.of((Class)property.getTarget());
                    }
                    if (i != path.length - 2) continue;
                    property = currentMapper.getProperty(variable);
                    if (property == null) {
                        throw new IllegalArgumentException(String.format("No such field '%s' in object '%s'", variable, currentMapper.getBeanClass().getName()));
                    }
                    if (!property.isReference()) continue;
                    joinOn = prefix + "." + variable;
                    prefix = prefix + "_" + variable;
                    this.joins.put(joinOn, prefix);
                    return prefix;
                }
            } else {
                Property property = mapper.getProperty(name);
                if (property == null) {
                    throw new IllegalArgumentException(String.format("No such field '%s' in object '%s'", variable, this.beanClass.getName()));
                }
                if (property.isCollection()) {
                    return null;
                }
                if (property.getTarget() != null) {
                    prefix = "_" + name;
                    this.joins.put("self." + name, prefix);
                    return prefix;
                }
            }
            if (prefix == null) {
                prefix = "self";
            }
            return prefix + "." + variable;
        }

        public String toString() {
            if (this.joins.size() == 0) {
                return "";
            }
            ArrayList joinItems = Lists.newArrayList();
            for (String key : this.joins.keySet()) {
                String val = this.joins.get(key);
                joinItems.add("LEFT JOIN " + key + " " + val);
            }
            return " " + Joiner.on((String)" ").join((Iterable)joinItems);
        }
    }
}

