/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advancedExport;

import com.axelor.apps.base.db.AdvancedExport;
import com.axelor.apps.base.db.AdvancedExportLine;
import com.axelor.apps.base.service.advancedExport.AdvancedExportGenerator;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.List;

public class CsvExportGenerator
extends AdvancedExportGenerator {
    private CSVWriter csvWriter;
    private String[] totalCols;
    private AdvancedExport advancedExport;
    private File exportFile;
    private String exportFileName;

    public CsvExportGenerator(AdvancedExport advancedExport) throws AxelorException {
        this.advancedExport = advancedExport;
        this.exportFileName = advancedExport.getMetaModel().getName() + ".csv";
        try {
            this.exportFile = File.createTempFile(advancedExport.getMetaModel().getName(), ".csv");
            this.csvWriter = new CSVWriter((Writer)new FileWriter(this.exportFile, true), ';');
        }
        catch (IOException e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException((Throwable)e, 4);
        }
        this.totalCols = new String[advancedExport.getAdvancedExportLineList().size()];
    }

    @Override
    public void generateHeader() {
        int index = 0;
        for (AdvancedExportLine advancedExportLine : this.advancedExport.getAdvancedExportLineList()) {
            this.totalCols[index++] = I18n.get((String)advancedExportLine.getTitle());
        }
        this.csvWriter.writeNext(this.totalCols);
    }

    @Override
    public void generateBody(List<List> dataList) {
        for (List listObj : dataList) {
            for (int colIndex = 0; colIndex < listObj.size(); ++colIndex) {
                Object value = listObj.get(colIndex);
                String columnValue = null;
                if (value != null && !value.equals("")) {
                    columnValue = value instanceof BigDecimal ? this.convertDecimalValue(value) : value.toString();
                }
                this.totalCols[colIndex] = columnValue;
            }
            this.csvWriter.writeNext(this.totalCols);
        }
    }

    @Override
    public void close() throws AxelorException {
        try {
            this.csvWriter.close();
        }
        catch (IOException e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException((Throwable)e, 4);
        }
    }

    @Override
    public AdvancedExport getAdvancedExport() {
        return this.advancedExport;
    }

    @Override
    public File getExportFile() {
        return this.exportFile;
    }

    @Override
    public String getFileName() {
        return this.exportFileName;
    }
}

