/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advancedExport;

import com.axelor.app.internal.AppFilter;
import com.axelor.apps.base.db.AdvancedExport;
import com.axelor.apps.base.db.AdvancedExportLine;
import com.axelor.apps.base.service.advancedExport.AdvancedExportGenerator;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.DateFormatConverter;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelExportGenerator
extends AdvancedExportGenerator {
    private Workbook workbook;
    private Sheet sheet;
    private AdvancedExport advancedExport;
    private File exportFile;
    private String exportFileName;

    public ExcelExportGenerator(AdvancedExport advancedExport) throws AxelorException {
        this.advancedExport = advancedExport;
        this.exportFileName = advancedExport.getMetaModel().getName() + ".xlsx";
        try {
            this.exportFile = File.createTempFile(advancedExport.getMetaModel().getName(), ".xlsx");
        }
        catch (IOException e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException((Throwable)e, 4);
        }
        this.workbook = new XSSFWorkbook();
        this.sheet = this.workbook.createSheet(advancedExport.getMetaModel().getName());
    }

    @Override
    public void generateHeader() {
        Row headerRow = this.sheet.createRow(this.sheet.getFirstRowNum());
        int colHeaderNum = 0;
        for (AdvancedExportLine advancedExportLine : this.advancedExport.getAdvancedExportLineList()) {
            Cell headerCell = headerRow.createCell(colHeaderNum++);
            headerCell.setCellValue(I18n.get((String)advancedExportLine.getTitle()));
        }
    }

    @Override
    public void generateBody(List<List> dataList) {
        String pattern;
        CellStyle dateCellStyle = this.workbook.createCellStyle();
        CellStyle dateTimeCellStyle = this.workbook.createCellStyle();
        DateFormat fmt = DateFormat.getDateInstance(3, AppFilter.getLocale());
        if (fmt instanceof SimpleDateFormat) {
            pattern = ((SimpleDateFormat)fmt).toPattern();
            pattern = pattern.replaceAll("y+", "yyyy");
            dateCellStyle.setDataFormat(this.workbook.createDataFormat().getFormat(DateFormatConverter.convert((Locale)AppFilter.getLocale(), (String)pattern)));
        }
        if ((fmt = DateFormat.getDateTimeInstance(3, 3, AppFilter.getLocale())) instanceof SimpleDateFormat) {
            pattern = ((SimpleDateFormat)fmt).toPattern();
            pattern = pattern.replaceAll("y+", "yyyy");
            dateTimeCellStyle.setDataFormat(this.workbook.createDataFormat().getFormat(DateFormatConverter.convert((Locale)AppFilter.getLocale(), (String)pattern)));
        }
        for (List listObj : dataList) {
            Row row = this.sheet.createRow(this.sheet.getLastRowNum() + 1);
            for (int colIndex = 0; colIndex < listObj.size(); ++colIndex) {
                Object value = listObj.get(colIndex);
                Cell cell = row.createCell(colIndex);
                Object columnValue = null;
                if (value == null || value.equals("")) continue;
                if (value instanceof LocalDate) {
                    cell.setCellStyle(dateCellStyle);
                    cell.setCellValue(Date.from(((LocalDate)value).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
                }
                if (value instanceof LocalDateTime) {
                    cell.setCellStyle(dateTimeCellStyle);
                    cell.setCellValue(Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant()));
                    continue;
                }
                if (value instanceof ZonedDateTime) {
                    cell.setCellStyle(dateTimeCellStyle);
                    cell.setCellValue(Date.from(((ZonedDateTime)value).toInstant()));
                    continue;
                }
                if (value instanceof Instant) {
                    cell.setCellStyle(dateTimeCellStyle);
                    cell.setCellValue(Date.from((Instant)value));
                    continue;
                }
                if (value instanceof Number) {
                    cell.setCellValue(((Number)value).doubleValue());
                    continue;
                }
                cell.setCellValue(value.toString());
            }
        }
    }

    @Override
    public void close() throws AxelorException {
        try {
            FileOutputStream fout = new FileOutputStream(this.exportFile);
            this.workbook.write((OutputStream)fout);
            fout.close();
        }
        catch (IOException e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException((Throwable)e, 4);
        }
    }

    @Override
    public AdvancedExport getAdvancedExport() {
        return this.advancedExport;
    }

    @Override
    public File getExportFile() {
        return this.exportFile;
    }

    @Override
    public String getFileName() {
        return this.exportFileName;
    }
}

