/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advancedExport;

import com.axelor.apps.base.db.AdvancedExport;
import com.axelor.apps.base.db.AdvancedExportLine;
import com.axelor.apps.base.service.advancedExport.AdvancedExportGenerator;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;

public class PdfExportGenerator
extends AdvancedExportGenerator {
    private Document document = null;
    private PdfPTable table = null;
    private AdvancedExport advancedExport;
    private File exportFile;
    private String exportFileName;

    public PdfExportGenerator(AdvancedExport advancedExport) throws AxelorException {
        this.advancedExport = advancedExport;
        this.exportFileName = advancedExport.getMetaModel().getName() + ".pdf";
        this.document = new Document();
        this.table = new PdfPTable(advancedExport.getAdvancedExportLineList().size());
        try {
            this.exportFile = File.createTempFile(advancedExport.getMetaModel().getName(), ".pdf");
            FileOutputStream outStream = new FileOutputStream(this.exportFile);
            PdfWriter.getInstance((Document)this.document, (OutputStream)outStream);
        }
        catch (DocumentException | IOException e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException(e, 4);
        }
        this.document.open();
    }

    @Override
    public void generateHeader() throws AxelorException {
        try {
            for (AdvancedExportLine advancedExportLine : this.advancedExport.getAdvancedExportLineList()) {
                PdfPCell headerCell = new PdfPCell(new Phrase(I18n.get((String)advancedExportLine.getTitle()), new Font(BaseFont.createFont(), 8.0f, 0, BaseColor.WHITE)));
                headerCell.setBackgroundColor(BaseColor.GRAY);
                headerCell.setHorizontalAlignment(1);
                this.table.addCell(headerCell);
            }
        }
        catch (DocumentException | IOException e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException(e, 4);
        }
    }

    @Override
    public void generateBody(List<List> dataList) {
        Font font = new Font();
        font.setSize(7.0f);
        for (List listObj : dataList) {
            for (int colIndex = 0; colIndex < listObj.size(); ++colIndex) {
                Object value = listObj.get(colIndex);
                String columnValue = null;
                if (value != null && !value.equals("")) {
                    columnValue = value instanceof BigDecimal ? this.convertDecimalValue(value) : value.toString();
                }
                PdfPCell cell = new PdfPCell(new Phrase(columnValue, font));
                this.table.addCell(cell);
            }
        }
    }

    @Override
    public void close() throws AxelorException {
        try {
            this.document.add((Element)this.table);
            this.document.close();
        }
        catch (DocumentException e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException((Throwable)e, 4);
        }
    }

    @Override
    public AdvancedExport getAdvancedExport() {
        return this.advancedExport;
    }

    @Override
    public File getExportFile() {
        return this.exportFile;
    }

    @Override
    public String getFileName() {
        return this.exportFileName;
    }
}

