/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.batch;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.ICalendar;
import com.axelor.apps.base.db.repo.ICalendarRepository;
import com.axelor.apps.base.ical.ICalendarService;
import com.axelor.apps.base.service.administration.AbstractBatch;
import com.google.inject.Inject;
import java.util.List;

public class BatchCalendarSynchronization
extends AbstractBatch {
    @Inject
    ICalendarService iCalendarService;
    @Inject
    ICalendarRepository repo;

    @Override
    protected void process() {
        Company company = this.batch.getBaseBatch().getCompany();
        List calendars = this.repo.all().filter("self.user.activeCompany = :company AND self.isValid = TRUE").bind("company", (Object)company).fetch();
        for (ICalendar calendar : calendars) {
            try {
                this.iCalendarService.sync(calendar, this.batch.getBaseBatch().getAllEvents(), this.batch.getBaseBatch().getSynchronizationDuration());
                this.incrementDone();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.incrementAnomaly();
            }
        }
    }
}

