/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.imports.importer;

import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelToCSV {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public List<Map> generateExcelSheets(File file) throws IOException {
        ArrayList<Map> newSheets = new ArrayList<Map>();
        Object sheet = new Object();
        XSSFWorkbook workBook = null;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            workBook = new XSSFWorkbook((InputStream)inputStream);
            for (int i = 0; i < workBook.getNumberOfSheets(); ++i) {
                sheet = workBook.getSheetAt(i).getSheetName();
                HashMap<String, Object> newSheet = new HashMap<String, Object>();
                newSheet.put("name", sheet);
                newSheets.add(newSheet);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return newSheets;
    }

    public void writeTOCSV(File sheetFile, Sheet sheet, int startRow, int startColumn) throws IOException, AxelorException {
        try (FileWriter writer = new FileWriter(sheetFile);){
            String separator = ";";
            int cnt = 0;
            for (int row = startRow; row <= sheet.getLastRowNum(); ++row) {
                int cell;
                if (row == startRow) {
                    Row headerRow = sheet.getRow(row);
                    for (cell = startColumn; cell < headerRow.getLastCellNum(); ++cell) {
                        Cell headerCell = headerRow.getCell(cell);
                        if (headerCell == null || headerCell.getCellType() != 1) {
                            throw new AxelorException(5, I18n.get((String)"Header is not valid."));
                        }
                        writer.append(headerCell.getStringCellValue() + separator);
                        ++cnt;
                    }
                    writer.append("\n");
                    continue;
                }
                Row dataRow = sheet.getRow(row);
                for (cell = startColumn; cell <= cnt; ++cell) {
                    try {
                        Cell dataCell = dataRow.getCell(cell);
                        if (dataCell != null) {
                            switch (dataCell.getCellType()) {
                                case 1: {
                                    String strData = dataCell.getStringCellValue();
                                    writer.append("\"" + strData + "\"" + separator);
                                    break;
                                }
                                case 0: {
                                    if (DateUtil.isCellDateFormatted((Cell)dataCell)) {
                                        String dateInString = ExcelToCSV.getDateValue(dataCell);
                                        writer.append("\"" + dateInString + "\"" + separator);
                                        break;
                                    }
                                    Integer val = (int)dataCell.getNumericCellValue();
                                    writer.append(val.toString() + separator);
                                    break;
                                }
                                default: {
                                    writer.append("" + separator);
                                    break;
                                }
                            }
                            continue;
                        }
                        writer.append("" + separator);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage());
                    }
                }
                writer.append("\n");
            }
            writer.flush();
        }
    }

    public static String getDateValue(Cell cell) {
        Calendar cal = Calendar.getInstance();
        Date date = cell.getDateCellValue();
        cal.setTime(date);
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        SimpleDateFormat format = hours == 0 && minutes == 0 && seconds == 0 ? new SimpleDateFormat("yyyy-MM-dd") : (seconds == 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:SS"));
        return format.format(date);
    }
}

