/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.imports.importer;

import com.axelor.apps.base.db.ImportConfiguration;
import com.axelor.apps.base.db.ImportHistory;
import com.axelor.apps.base.service.imports.importer.ExcelToCSV;
import com.axelor.apps.base.service.imports.listener.ImporterListener;
import com.axelor.auth.AuthUtils;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Importer {
    private static final File DEFAULT_WORKSPACE = Importer.createDefaultWorkspace();
    protected Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ImportConfiguration configuration;
    private File workspace;
    @Inject
    ExcelToCSV excelToCSV;
    @Inject
    MetaFiles metaFiles;

    public void setConfiguration(ImportConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setWorkspace(File workspace) {
        Preconditions.checkArgument((workspace.exists() && workspace.isDirectory() ? 1 : 0) != 0);
        this.workspace = workspace;
    }

    public ImportConfiguration getConfiguration() {
        return this.configuration;
    }

    public File getWorkspace() {
        return this.workspace;
    }

    public Importer init(ImportConfiguration configuration) {
        return this.init(configuration, DEFAULT_WORKSPACE);
    }

    public Importer init(ImportConfiguration configuration, File workspace) {
        this.setConfiguration(configuration);
        this.setWorkspace(workspace);
        this.log.debug("Initialisation de l'import pour la configuration {}", (Object)configuration.getName());
        return this;
    }

    public ImportHistory run(Map<String, Object> importContext) throws AxelorException, IOException {
        File bind = MetaFiles.getPath((MetaFile)this.configuration.getBindMetaFile()).toFile();
        File data = MetaFiles.getPath((MetaFile)this.configuration.getDataMetaFile()).toFile();
        if (!bind.exists()) {
            throw new AxelorException(4, I18n.get((String)"Error : Mapping file is unreachable."));
        }
        if (!data.exists()) {
            throw new AxelorException(4, I18n.get((String)"Error : Data file is unreachable."));
        }
        File fileWorkspace = this.createFinalWorkspace(this.configuration.getDataMetaFile());
        ImportHistory importHistory = this.process(bind.getAbsolutePath(), fileWorkspace.getAbsolutePath(), importContext);
        this.deleteFinalWorkspace(fileWorkspace);
        return importHistory;
    }

    public ImportHistory run() throws AxelorException, IOException {
        return this.run(null);
    }

    protected abstract ImportHistory process(String var1, String var2, Map<String, Object> var3) throws IOException;

    protected abstract ImportHistory process(String var1, String var2) throws IOException;

    protected void deleteFinalWorkspace(File workspace) throws IOException {
        if (workspace.isDirectory()) {
            FileUtils.deleteDirectory((File)workspace);
        } else {
            workspace.delete();
        }
    }

    protected File createFinalWorkspace(MetaFile metaFile) throws IOException {
        File data = MetaFiles.getPath((MetaFile)metaFile).toFile();
        File finalWorkspace = new File(this.workspace, this.computeFinalWorkspaceName(data));
        finalWorkspace.mkdir();
        if (this.isZip(data)) {
            this.unZip(data, finalWorkspace);
        } else {
            FileUtils.copyFile((File)data, (File)new File(finalWorkspace, metaFile.getFileName()));
        }
        if (Files.getFileExtension((String)data.getName()).equals("xlsx")) {
            this.importExcel(new File(finalWorkspace, metaFile.getFileName()));
        }
        return finalWorkspace;
    }

    protected String computeFinalWorkspaceName(File data) {
        return String.format("%s-%s", Files.getNameWithoutExtension((String)data.getName()), LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
    }

    protected boolean isZip(File file) {
        return Files.getFileExtension((String)file.getName()).equals("zip");
    }

    protected void unZip(File file, File directory) throws IOException {
        File extractFile = null;
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                try {
                    InputStream entryInputStream = zipFile.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        byte[] buffer = new byte[1024];
                        int bytesRead = 0;
                        extractFile = new File(directory, entry.getName());
                        if (entry.isDirectory()) {
                            extractFile.mkdirs();
                            continue;
                        }
                        extractFile.getParentFile().mkdirs();
                        extractFile.createNewFile();
                        try (FileOutputStream fileOutputStream = new FileOutputStream(extractFile);){
                            while ((bytesRead = entryInputStream.read(buffer)) != -1) {
                                fileOutputStream.write(buffer, 0, bytesRead);
                            }
                        }
                        if (!Files.getFileExtension((String)extractFile.getName()).equals("xlsx")) continue;
                        this.importExcel(extractFile);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (entryInputStream == null) continue;
                        if (throwable != null) {
                            try {
                                entryInputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        entryInputStream.close();
                    }
                }
                catch (IOException ioException) {
                    this.log.error(ioException.getMessage());
                }
            }
        }
    }

    protected ImportHistory addHistory(ImporterListener listener) throws IOException {
        ImportHistory importHistory = new ImportHistory(AuthUtils.getUser(), this.configuration.getDataMetaFile());
        File logFile = File.createTempFile("importLog", ".log");
        try (FileWriter writer = new FileWriter(logFile);){
            writer.write(listener.getImportLog());
        }
        MetaFile logMetaFile = this.metaFiles.upload((InputStream)new FileInputStream(logFile), "importLog-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".log");
        importHistory.setLogMetaFile(logMetaFile);
        importHistory.setImportConfiguration(this.configuration);
        return importHistory;
    }

    private static File createDefaultWorkspace() {
        File file = Files.createTempDir();
        file.deleteOnExit();
        return file;
    }

    public void importExcel(File excelFile) throws IOException {
        List<Map> sheetList = this.excelToCSV.generateExcelSheets(excelFile);
        FileInputStream inputStream = new FileInputStream(excelFile);
        XSSFWorkbook workBook = new XSSFWorkbook((InputStream)inputStream);
        try {
            for (int i = 0; i < sheetList.size(); ++i) {
                Sheet sheet = workBook.getSheet(sheetList.get(i).get("name").toString());
                File sheetFile = new File(excelFile.getParent() + "/" + sheetList.get(i).get("name").toString() + ".csv");
                this.excelToCSV.writeTOCSV(sheetFile, sheet, 0, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

