/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.message;

import com.axelor.apps.base.db.AppBase;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.service.MailAccountServiceImpl;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;

public class MailAccountServiceBaseImpl
extends MailAccountServiceImpl {
    protected UserService userService;
    @Inject
    protected AppBaseService appBaseService;

    @Inject
    public MailAccountServiceBaseImpl(UserService userService) {
        this.userService = userService;
    }

    public void checkDefaultMailAccount(EmailAccount mailAccount) throws AxelorException {
        if (this.appBaseService.getAppBase().getEmailAccountByUser().booleanValue() && mailAccount.getIsDefault().booleanValue() && mailAccount.getUser() != null) {
            Integer serverTypeSelect;
            String query = "self.user = ?1 AND self.isDefault = true";
            ArrayList params = Lists.newArrayList();
            params.add(mailAccount.getUser());
            if (mailAccount.getId() != null) {
                query = query + " AND self.id != ?2";
                params.add(mailAccount.getId());
            }
            if ((serverTypeSelect = mailAccount.getServerTypeSelect()) == 1) {
                query = query + " AND self.serverTypeSelect = 1 ";
            } else if (serverTypeSelect == 3 || serverTypeSelect == 2) {
                query = query + " AND (self.serverTypeSelect = 3 OR self.serverTypeSelect = 2) ";
            }
            Long count = this.mailAccountRepo.all().filter(query, params.toArray()).count();
            if (count > 0L) {
                throw new AxelorException(4, I18n.get((String)"There is already a default account"));
            }
        } else {
            super.checkDefaultMailAccount(mailAccount);
        }
    }

    public EmailAccount getDefaultSender() {
        AppBase appBase = this.appBaseService.getAppBase();
        if (appBase != null && appBase.getEmailAccountByUser().booleanValue()) {
            return (EmailAccount)((Object)this.mailAccountRepo.all().filter("self.user = ?1 AND self.isDefault = true AND self.serverTypeSelect = ?2", new Object[]{this.userService.getUser(), 1}).fetchOne());
        }
        return super.getDefaultSender();
    }

    public EmailAccount getDefaultReader() {
        if (this.appBaseService.getAppBase().getEmailAccountByUser().booleanValue()) {
            return (EmailAccount)((Object)this.mailAccountRepo.all().filter("self.user = ?1 AND self.isDefault = true AND (self.serverTypeSelect = ?2 OR self.serverTypeSelect = ?3)", new Object[]{this.userService.getUser(), 3, 2}).fetchOne());
        }
        return super.getDefaultReader();
    }
}

