/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.publicHoliday;

import com.axelor.apps.base.db.EventsPlanning;
import com.axelor.apps.base.db.EventsPlanningLine;
import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.base.db.repo.EventsPlanningLineRepository;
import com.axelor.apps.base.service.weeklyplanning.WeeklyPlanningService;
import com.axelor.common.ObjectUtils;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

public class PublicHolidayService {
    protected WeeklyPlanningService weeklyPlanningService;
    protected EventsPlanningLineRepository eventsPlanningLineRepo;

    @Inject
    public PublicHolidayService(WeeklyPlanningService weeklyPlanningService, EventsPlanningLineRepository eventsPlanningLineRepo) {
        this.weeklyPlanningService = weeklyPlanningService;
        this.eventsPlanningLineRepo = eventsPlanningLineRepo;
    }

    public BigDecimal computePublicHolidayDays(LocalDate fromDate, LocalDate toDate, WeeklyPlanning weeklyPlanning, EventsPlanning publicHolidayPlanning) {
        BigDecimal publicHolidayDays = BigDecimal.ZERO;
        List publicHolidayDayList = this.eventsPlanningLineRepo.all().filter("self.eventsPlanning = ?1 AND self.date BETWEEN ?2 AND ?3", new Object[]{publicHolidayPlanning, fromDate, toDate}).fetch();
        for (EventsPlanningLine publicHolidayDay : publicHolidayDayList) {
            publicHolidayDays = publicHolidayDays.add(BigDecimal.valueOf(this.weeklyPlanningService.getWorkingDayValueInDays(weeklyPlanning, publicHolidayDay.getDate())));
        }
        return publicHolidayDays;
    }

    public boolean checkPublicHolidayDay(LocalDate date, EventsPlanning publicHolidayEventsPlanning) {
        if (publicHolidayEventsPlanning == null) {
            return false;
        }
        List publicHolidayDayList = this.eventsPlanningLineRepo.all().filter("self.eventsPlanning = ?1 AND self.date = ?2", new Object[]{publicHolidayEventsPlanning, date}).fetch();
        return ObjectUtils.notEmpty((Object)publicHolidayDayList);
    }
}

