/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.querie;

import com.axelor.apps.base.db.Querie;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.db.MetaModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QuerieService {
    public List<Long> getQuerieResult(Set<Querie> querieSet) throws AxelorException {
        HashSet idList = Sets.newHashSet();
        if (querieSet != null) {
            for (Querie querie : querieSet) {
                idList.addAll(this.getQuerieResult(querie));
            }
        }
        return Lists.newArrayList((Iterable)idList);
    }

    public List<Long> getQuerieResult(Querie querie) throws AxelorException {
        List<Object> result = Lists.newArrayList();
        int requestType = querie.getType();
        String filter = querie.getQuery();
        if (filter == null || filter.isEmpty()) {
            throw new AxelorException(1, I18n.get((String)"Error : There is no query set for the querie %s"), new Object[]{querie.getId()});
        }
        Class<?> klass = this.getClass(querie.getMetaModel());
        try {
            if (requestType == 1) {
                result = this.runSqlRequest(filter);
            } else if (requestType == 2) {
                result = this.runJpqlRequest(filter, klass);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AxelorException(e.getCause(), 4, I18n.get((String)"Error : Incorrect query for the querie %s"), new Object[]{querie.getId()});
        }
        return result;
    }

    public List<Long> runSqlRequest(String filter) {
        ArrayList idLists = Lists.newArrayList();
        javax.persistence.Query query = JPA.em().createNativeQuery(filter);
        List queryResult = query.getResultList();
        for (BigInteger bi : queryResult) {
            idLists.add(bi.longValue());
        }
        return idLists;
    }

    public List<Long> runJpqlRequest(String filter, Class<?> klass) {
        ArrayList idLists = Lists.newArrayList();
        List result = Query.of(klass).filter(filter).select(new String[]{"id"}).fetch(0, 0);
        for (Map map : result) {
            idLists.add(Long.valueOf(map.get("id").toString()));
        }
        return idLists;
    }

    private Class<?> getClass(MetaModel metaModel) {
        String model = metaModel.getFullName();
        try {
            return Class.forName(model);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public void checkQuerie(Querie querie) throws AxelorException {
        this.getQuerieResult(querie);
    }
}

