/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.tax;

import com.axelor.apps.account.db.Tax;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.time.LocalDate;

@Singleton
public class TaxService {
    public BigDecimal getTaxRate(Tax tax, LocalDate localDate) throws AxelorException {
        return this.getTaxLine(tax, localDate).getValue();
    }

    public TaxLine getTaxLine(Tax tax, LocalDate localDate) throws AxelorException {
        if (tax == null) {
            throw new AxelorException(4, I18n.get((String)"Tax is missing"));
        }
        if (tax.getActiveTaxLine() != null) {
            return tax.getActiveTaxLine();
        }
        if (tax.getTaxLineList() != null && !tax.getTaxLineList().isEmpty()) {
            for (TaxLine taxLine : tax.getTaxLineList()) {
                if (!DateTool.isBetween((LocalDate)taxLine.getStartDate(), (LocalDate)taxLine.getEndDate(), (LocalDate)localDate)) continue;
                return taxLine;
            }
        }
        throw new AxelorException(4, I18n.get((String)"Please enter a tax version for the tax %s"), new Object[]{tax.getName()});
    }
}

