/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.template;

import com.axelor.apps.base.db.TemplateRule;
import com.axelor.apps.base.db.TemplateRuleLine;
import com.axelor.apps.message.db.Template;
import com.axelor.db.Model;
import com.axelor.i18n.I18n;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.schema.actions.Action;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.Resource;
import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateRuleService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Map<String, Object> getContext(TemplateRule templateRule, Model bean) {
        Template template = this.getTemplate(bean, templateRule);
        if (template == null) {
            return null;
        }
        return null;
    }

    public Template getTemplate(Model bean, TemplateRule templateRule) {
        if (templateRule.getTemplateRuleLineList() == null || templateRule.getMetaModel() == null) {
            return null;
        }
        Class<?> klass = this.getTemplateClass(templateRule.getMetaModel());
        if (klass != null) {
            if (!klass.isInstance(bean)) {
                throw new IllegalArgumentException(I18n.get((String)"Bean is not an instance of") + " " + klass.getSimpleName());
            }
            List<TemplateRuleLine> lines = this._sortRuleLine(templateRule.getTemplateRuleLineList());
            for (TemplateRuleLine line : lines) {
                Boolean isValid = this.runAction(bean, line.getMetaAction(), klass.getName());
                if (!Boolean.TRUE.equals(isValid)) continue;
                return line.getTemplate();
            }
        }
        return null;
    }

    private Class<?> getTemplateClass(MetaModel metaModel) {
        String model = metaModel.getFullName();
        try {
            return Class.forName(model);
        }
        catch (ClassNotFoundException e) {
            LOG.error(e.getMessage());
            return null;
        }
    }

    private List<TemplateRuleLine> _sortRuleLine(List<TemplateRuleLine> templateRuleLine) {
        Collections.sort(templateRuleLine, new Comparator<TemplateRuleLine>(){

            @Override
            public int compare(TemplateRuleLine o1, TemplateRuleLine o2) {
                return o1.getSequence().compareTo(o2.getSequence());
            }
        });
        return templateRuleLine;
    }

    public Boolean runAction(Model bean, MetaAction metaAction, String klassName) {
        ActionHandler handler;
        if (metaAction == null) {
            return true;
        }
        Action action = MetaStore.getAction((String)metaAction.getName());
        Object result = action.wrap(handler = this.createHandler(bean, action.getName(), klassName));
        if (result instanceof Map) {
            Map data = (Map)result;
            String ERRORS = "errors";
            if (data.containsKey("errors") && data.get("errors") != null && !((Map)data.get("errors")).isEmpty()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return (Boolean)result;
    }

    private ActionHandler createHandler(Model bean, String action, String model) {
        ActionRequest request = new ActionRequest();
        HashMap map = Maps.newHashMap();
        map.put("context", Resource.toMap((Object)bean, (String[])new String[0]));
        request.setData((Map)map);
        request.setModel(model);
        request.setAction(action);
        return new ActionHandler(request);
    }
}

