/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.timer;

import com.axelor.apps.base.db.Timer;
import com.axelor.apps.base.db.TimerHistory;
import com.axelor.apps.base.db.repo.TimerHistoryRepository;
import com.axelor.apps.base.db.repo.TimerRepository;
import com.axelor.apps.base.service.timer.TimerService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;

public abstract class AbstractTimerService
implements TimerService {
    protected TimerRepository timerRepository;
    protected TimerHistoryRepository timerHistoryRepository;
    protected UserService userService;

    @Inject
    public AbstractTimerService(TimerRepository timerRepository, TimerHistoryRepository timerHistoryRepository, UserService userService) {
        this.timerRepository = timerRepository;
        this.timerHistoryRepository = timerHistoryRepository;
        this.userService = userService;
    }

    @Override
    public LocalDateTime findStartDate(Timer timer) {
        TimerHistory first = (TimerHistory)((Object)this.timerHistoryRepository.findByTimer(timer).order("startDateT").fetchOne());
        return first != null ? first.getStartDateT() : null;
    }

    @Override
    public LocalDateTime findEndDate(Timer timer) {
        TimerHistory last = (TimerHistory)((Object)this.timerHistoryRepository.findByTimer(timer).order("-endDateT").fetchOne());
        return last != null ? last.getEndDateT() : null;
    }

    @Override
    public Duration compute(Timer timer) {
        LocalDateTime start = this.findStartDate(timer);
        if (start == null) {
            return Duration.ZERO;
        }
        LocalDateTime end = this.findEndDate(timer);
        if (end == null) {
            TimerHistory lastWithEndDate = (TimerHistory)((Object)this.timerHistoryRepository.all().filter("self.timer = :timer AND self.endDateT IS NOT NULL").bind("timer", (Object)timer).order("-endDateT").fetchOne());
            if (lastWithEndDate == null) {
                return Duration.ZERO;
            }
            end = lastWithEndDate.getEndDateT();
        }
        return Duration.between(start, end);
    }

    @Override
    @Transactional
    public void cancel(Timer timer) {
        List histories = this.timerHistoryRepository.findByTimer(timer).fetch();
        histories.forEach(arg_0 -> ((TimerHistoryRepository)this.timerHistoryRepository).remove(arg_0));
        timer.setStatusSelect(0);
    }

    @Transactional(rollbackOn={Exception.class})
    protected Timer tryStartOrCreate(Timer timer) throws AxelorException {
        if (timer == null) {
            timer = new Timer();
            timer.setAssignedToUser(this.userService.getUser());
        } else if (timer.getStatusSelect().equals(1)) {
            throw new AxelorException(1, I18n.get((String)"You can't start a timer that has already started"));
        }
        timer.setStatusSelect(1);
        return (Timer)((Object)this.timerRepository.save((Model)((Object)timer)));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public TimerHistory stop(Model model, Timer timer, LocalDateTime dateTime) throws AxelorException {
        Preconditions.checkNotNull((Object)((Object)timer), (Object)I18n.get((String)"You can't stop a timer that hasn't been started"));
        TimerHistory last = (TimerHistory)((Object)this.timerHistoryRepository.findByTimer(timer).order("-startDateT").fetchOne());
        if (last == null) {
            throw new AxelorException(1, I18n.get((String)"You can't stop a timer that hasn't been started"));
        }
        last.setEndDateT(dateTime);
        timer.setStatusSelect(0);
        return last;
    }
}

