/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.wizard;

import com.axelor.db.JPA;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.exception.AxelorException;
import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertWizardService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Object createObject(Map<String, Object> context, Object obj, Mapper mapper) throws AxelorException {
        if (context != null) {
            int random = new Random().nextInt();
            for (Property p : mapper.getProperties()) {
                if (p.isVirtual() || p.isPrimary() || p.isVersion()) continue;
                LOG.debug("Property name / Context value  : {} / {}", (Object)p.getName());
                Object value = context.get(p.getName());
                LOG.debug("Context value : {}", value);
                if (value == null) continue;
                if (value instanceof String && p.isUnique()) {
                    value = (String)value + " (" + random + ")";
                }
                if (value instanceof Map) {
                    LOG.debug("Map");
                    Map map = (Map)value;
                    Object id = map.get("id");
                    value = JPA.find((Class)p.getTarget(), (Long)Long.parseLong(id.toString()));
                }
                if (value instanceof List) {
                    LOG.debug("List");
                    List valueList = (List)value;
                    ArrayList resultList = Lists.newArrayList();
                    if (valueList != null) {
                        for (Object object : valueList) {
                            Map map = (Map)object;
                            Object id = map.get("id");
                            resultList.add(JPA.find((Class)p.getTarget(), (Long)Long.parseLong(id.toString())));
                        }
                    }
                    value = resultList;
                }
                p.set(obj, value);
            }
            return obj;
        }
        return null;
    }
}

