/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.ABCAnalysis;
import com.axelor.apps.base.db.ABCAnalysisClass;
import com.axelor.apps.base.db.repo.ABCAnalysisRepository;
import com.axelor.apps.base.service.ABCAnalysisService;
import com.axelor.apps.base.service.ABCAnalysisServiceImpl;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Strings;
import java.util.List;

public class ABCAnalysisController {
    public void runAnalysis(ActionRequest request, ActionResponse response) {
        ABCAnalysis abcAnalysis = (ABCAnalysis)((Object)request.getContext().asType(ABCAnalysis.class));
        try {
            Class<?> clazz = Class.forName(abcAnalysis.getTypeSelect());
            ((ABCAnalysisServiceImpl)Beans.get(clazz)).runAnalysis((ABCAnalysis)((Object)((ABCAnalysisRepository)((Object)Beans.get(ABCAnalysisRepository.class))).find(abcAnalysis.getId())));
            response.setReload(true);
        }
        catch (AxelorException | ClassNotFoundException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void initABCClasses(ActionRequest request, ActionResponse response) {
        List<ABCAnalysisClass> abcAnalysisClassList = ((ABCAnalysisService)Beans.get(ABCAnalysisService.class)).initABCClasses();
        response.setValue("abcAnalysisClassList", abcAnalysisClassList);
    }

    public void setSequence(ActionRequest request, ActionResponse response) {
        ABCAnalysis abcAnalysis = (ABCAnalysis)((Object)request.getContext().asType(ABCAnalysis.class));
        ((ABCAnalysisServiceImpl)Beans.get(ABCAnalysisServiceImpl.class)).setSequence(abcAnalysis);
        response.setValue("abcAnalysisSeq", (Object)abcAnalysis.getAbcAnalysisSeq());
    }

    public void printReport(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        Long abcAnalysisId = Long.parseLong(context.get((Object)"_abcAnalysisId").toString());
        String reportType = (String)context.get((Object)"reportTypeSelect");
        ABCAnalysis abcAnalysis = (ABCAnalysis)((Object)((ABCAnalysisRepository)((Object)Beans.get(ABCAnalysisRepository.class))).find(abcAnalysisId));
        try {
            String name = I18n.get((String)"ABC Analysis N\u00b0") + " " + abcAnalysis.getAbcAnalysisSeq();
            String fileLink = ((ABCAnalysisServiceImpl)Beans.get(ABCAnalysisServiceImpl.class)).printReport(abcAnalysis, reportType);
            if (!Strings.isNullOrEmpty((String)fileLink)) {
                response.setView(ActionView.define((String)name).add("html", fileLink).map());
            }
        }
        catch (AxelorException e) {
            response.setError(e.getMessage());
        }
        response.setCanClose(true);
    }

    public void checkClasses(ActionRequest request, ActionResponse response) {
        ABCAnalysis abcAnalysis = (ABCAnalysis)((Object)request.getContext().asType(ABCAnalysis.class));
        try {
            ((ABCAnalysisServiceImpl)Beans.get(ABCAnalysisServiceImpl.class)).checkClasses(abcAnalysis);
        }
        catch (AxelorException e) {
            response.setError(e.getMessage());
        }
    }
}

