/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.AddressExport;
import com.axelor.apps.base.db.AppBase;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PartnerAddress;
import com.axelor.apps.base.db.PickListEntry;
import com.axelor.apps.base.db.repo.AddressRepository;
import com.axelor.apps.base.db.repo.PartnerAddressRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.MapService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import com.qas.web_2005_02.AddressLineType;
import com.qas.web_2005_02.PicklistEntryType;
import com.qas.web_2005_02.QAAddressType;
import com.qas.web_2005_02.QAPicklistType;
import com.qas.web_2005_02.VerifyLevelType;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AddressController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void check(ActionRequest request, ActionResponse response) {
        AppBase appBase = (AppBase)((Object)request.getContext().asType(AppBase.class));
        LOG.debug("validate g = {}", (Object)appBase);
        LOG.debug("validate g.qasWsdlUrl = {}", (Object)appBase.getQasWsdlUrl());
        String msg = ((AddressService)Beans.get(AddressService.class)).check(appBase.getQasWsdlUrl()) ? appBase.getQasWsdlUrl() + " " + I18n.get((String)"OK") : I18n.get((String)"Service unavailable, please contact a administrator");
        response.setFlash(msg);
    }

    public void validate(ActionRequest request, ActionResponse response) {
        Address a = (Address)((Object)request.getContext().asType(Address.class));
        LOG.debug("validate a = {}", (Object)a);
        String search = a.getAddressL4() + " " + a.getAddressL6();
        Map<String, Object> retDict = ((AddressService)Beans.get(AddressService.class)).validate(((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getQasWsdlUrl(), search);
        LOG.debug("validate retDict = {}", retDict);
        VerifyLevelType verifyLevel = (VerifyLevelType)retDict.get("verifyLevel");
        if (verifyLevel != null && verifyLevel.value().equals("Verified")) {
            QAAddressType address = (QAAddressType)retDict.get("qaAddress");
            List addressLineType = address.getAddressLine();
            String addL1 = ((AddressLineType)addressLineType.get(0)).getLine();
            response.setValue("addressL2", (Object)((AddressLineType)addressLineType.get(1)).getLine());
            response.setValue("addressL3", (Object)((AddressLineType)addressLineType.get(2)).getLine());
            response.setValue("addressL4", (Object)((AddressLineType)addressLineType.get(3)).getLine());
            response.setValue("addressL5", (Object)((AddressLineType)addressLineType.get(4)).getLine());
            response.setValue("addressL6", (Object)((AddressLineType)addressLineType.get(5)).getLine());
            response.setValue("inseeCode", (Object)((AddressLineType)addressLineType.get(6)).getLine());
            response.setValue("certifiedOk", (Object)true);
            response.setValue("pickList", new ArrayList());
            if (addL1 != null) {
                response.setFlash("Ligne 1: " + addL1);
            }
        } else if (verifyLevel != null && (verifyLevel.value().equals("Multiple") || verifyLevel.value().equals("StreetPartial") || verifyLevel.value().equals("InteractionRequired") || verifyLevel.value().equals("PremisesPartial"))) {
            LOG.debug("retDict.verifyLevel = {}", retDict.get("verifyLevel"));
            QAPicklistType qaPicklist = (QAPicklistType)retDict.get("qaPicklist");
            ArrayList<PickListEntry> pickList = new ArrayList<PickListEntry>();
            if (qaPicklist != null) {
                for (PicklistEntryType p : qaPicklist.getPicklistEntry()) {
                    PickListEntry e = new PickListEntry();
                    e.setAddress(a);
                    e.setMoniker(p.getMoniker());
                    e.setScore(p.getScore().toString());
                    e.setPostcode(p.getPostcode());
                    e.setPartialAddress(p.getPartialAddress());
                    e.setPicklist(p.getPicklist());
                    pickList.add(e);
                }
            } else if (retDict.get("qaAddress") != null) {
                QAAddressType address = (QAAddressType)retDict.get("qaAddress");
                PickListEntry e = new PickListEntry();
                List addressLineType = address.getAddressLine();
                e.setAddress(a);
                e.setL2(((AddressLineType)addressLineType.get(1)).getLine());
                e.setL3(((AddressLineType)addressLineType.get(2)).getLine());
                e.setPartialAddress(((AddressLineType)addressLineType.get(3)).getLine());
                e.setL5(((AddressLineType)addressLineType.get(4)).getLine());
                e.setPostcode(((AddressLineType)addressLineType.get(5)).getLine());
                e.setInseeCode(((AddressLineType)addressLineType.get(6)).getLine());
                pickList.add(e);
            }
            response.setValue("certifiedOk", (Object)false);
            response.setValue("pickList", pickList);
        } else if (verifyLevel != null && verifyLevel.value().equals("None")) {
            LOG.debug("address None");
            response.setFlash(I18n.get((String)"There is no matching address in the QAS base"));
        }
    }

    public void select(ActionRequest request, ActionResponse response) {
        Address a = (Address)((Object)request.getContext().asType(Address.class));
        PickListEntry pickedEntry = null;
        if (!a.getPickList().isEmpty()) {
            pickedEntry = a.getPickList().get(0);
            LOG.debug("select pickedEntry = {}", (Object)pickedEntry);
            String moniker = pickedEntry.getMoniker();
            if (moniker != null) {
                com.qas.web_2005_02.Address address = ((AddressService)Beans.get(AddressService.class)).select(((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getQasWsdlUrl(), moniker);
                LOG.debug("select address = {}", (Object)address);
                response.setValue("addressL2", address.getQAAddress().getAddressLine().get(1));
                response.setValue("addressL3", address.getQAAddress().getAddressLine().get(2));
                response.setValue("addressL4", address.getQAAddress().getAddressLine().get(3));
                response.setValue("addressL5", address.getQAAddress().getAddressLine().get(4));
                response.setValue("addressL6", address.getQAAddress().getAddressLine().get(5));
                response.setValue("inseeCode", address.getQAAddress().getAddressLine().get(6));
                response.setValue("certifiedOk", (Object)true);
                response.setValue("pickList", new ArrayList());
            } else {
                LOG.debug("missing fields for pickedEntry: {}", (Object)pickedEntry);
                response.setValue("addressL2", (Object)pickedEntry.getL2());
                response.setValue("addressL3", (Object)pickedEntry.getL3());
                response.setValue("addressL4", (Object)pickedEntry.getPartialAddress());
                response.setValue("addressL5", (Object)pickedEntry.getL5());
                response.setValue("addressL6", (Object)pickedEntry.getPostcode());
                response.setValue("inseeCode", (Object)pickedEntry.getInseeCode());
                response.setValue("pickList", new ArrayList());
                response.setValue("certifiedOk", (Object)true);
            }
        } else {
            response.setFlash(I18n.get((String)"NA"));
        }
    }

    public void export(ActionRequest request, ActionResponse response) throws IOException {
        AddressExport addressExport = (AddressExport)((Object)request.getContext().asType(AddressExport.class));
        int size = ((AddressService)Beans.get(AddressService.class)).export(addressExport.getPath());
        response.setValue("log", (Object)(size + " adresses export\u00e9es"));
    }

    public void viewMap(ActionRequest request, ActionResponse response) {
        try {
            Address address = (Address)((Object)request.getContext().asType(Address.class));
            address = (Address)((Object)((AddressRepository)((Object)Beans.get(AddressRepository.class))).find(address.getId()));
            Optional<Pair<BigDecimal, BigDecimal>> latLong = ((AddressService)Beans.get(AddressService.class)).getOrUpdateLatLong(address);
            if (latLong.isPresent()) {
                MapService mapService = (MapService)Beans.get(MapService.class);
                HashMap<String, String> mapView = new HashMap<String, String>();
                mapView.put("title", "Map");
                mapView.put("resource", mapService.getMapUrl(latLong.get(), address.getFullName()));
                mapView.put("viewType", "html");
                response.setView(mapView);
            } else {
                response.setFlash(String.format(I18n.get((String)"<B>%s</B> not found"), address.getFullName()));
            }
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void viewDirection(ActionRequest request, ActionResponse response) {
        AddressRepository addressRepository = (AddressRepository)((Object)Beans.get(AddressRepository.class));
        try {
            Company company;
            MapService mapService = (MapService)Beans.get(MapService.class);
            String key = null;
            if (((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getMapApiSelect() == 1) {
                key = mapService.getGoogleMapsApiKey();
            }
            if ((company = AuthUtils.getUser().getActiveCompany()) == null) {
                response.setFlash(I18n.get((String)"No active company for this user, please define an active company."));
                return;
            }
            Address departureAddress = company.getAddress();
            if (departureAddress == null) {
                response.setFlash(I18n.get((String)"Current user's active company address is not set"));
                return;
            }
            departureAddress = (Address)((Object)addressRepository.find(departureAddress.getId()));
            Optional<Pair<BigDecimal, BigDecimal>> departureLatLong = ((AddressService)Beans.get(AddressService.class)).getOrUpdateLatLong(departureAddress);
            if (!departureLatLong.isPresent()) {
                response.setFlash(String.format(I18n.get((String)"<B>%s</B> not found"), departureAddress.getFullName()));
                return;
            }
            Address arrivalAddress = (Address)((Object)request.getContext().asType(Address.class));
            arrivalAddress = (Address)((Object)addressRepository.find(arrivalAddress.getId()));
            Optional<Pair<BigDecimal, BigDecimal>> arrivalLatLong = ((AddressService)Beans.get(AddressService.class)).getOrUpdateLatLong(arrivalAddress);
            if (!arrivalLatLong.isPresent()) {
                response.setFlash(String.format(I18n.get((String)"<B>%s</B> not found"), arrivalAddress.getFullName()));
                return;
            }
            HashMap<String, String> mapView = new HashMap<String, String>();
            mapView.put("title", "Map");
            mapView.put("resource", mapService.getDirectionUrl(key, departureLatLong.get(), arrivalLatLong.get()));
            mapView.put("viewType", "html");
            response.setView(mapView);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updateLatLong(ActionRequest request, ActionResponse response) {
        AddressService addressService = (AddressService)Beans.get(AddressService.class);
        try {
            Address address = (Address)((Object)request.getContext().asType(Address.class));
            address = (Address)((Object)((AddressRepository)((Object)Beans.get(AddressRepository.class))).find(address.getId()));
            addressService.resetLatLong(address);
            addressService.updateLatLong(address);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void createPartnerAddress(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        Context parentContext = context.getParent();
        if (parentContext.isEmpty()) {
            return;
        }
        String parentModel = (String)parentContext.get((Object)"_model");
        LOG.debug("Create partner address : Parent model = {}", (Object)parentModel);
        String partnerField = PartnerAddressRepository.modelPartnerFieldMap.get(parentModel);
        LOG.debug("Create partner address : Parent field = {}", (Object)partnerField);
        Partner partner = null;
        if (parentContext.get((Object)partnerField) instanceof Partner) {
            partner = (Partner)((Object)parentContext.get((Object)partnerField));
        } else if (parentContext.get((Object)partnerField) instanceof Map) {
            partner = (Partner)((Object)Mapper.toBean(Partner.class, (Map)((Map)parentContext.get((Object)partnerField))));
        }
        LOG.debug("Create partner address : Partner = {}", (Object)partner);
        if (partner == null || partner.getId() == null) {
            return;
        }
        Address address = (Address)((Object)context.asType(Address.class));
        PartnerAddress partnerAddress = (PartnerAddress)((Object)((PartnerAddressRepository)((Object)Beans.get(PartnerAddressRepository.class))).all().filter("self.partner.id = ? AND self.address.id = ?", new Object[]{partner.getId(), address.getId()}).fetchOne());
        LOG.debug("Create partner address : Partner Address = {}", (Object)partnerAddress);
        if (partnerAddress == null) {
            Boolean isDefault;
            Boolean delivery;
            partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId()));
            address = (Address)((Object)((AddressRepository)((Object)Beans.get(AddressRepository.class))).find(address.getId()));
            Boolean invoicing = (Boolean)context.get((Object)"isInvoicingAddr");
            if (invoicing == null) {
                invoicing = false;
            }
            if ((delivery = (Boolean)context.get((Object)"isDeliveryAddr")) == null) {
                delivery = false;
            }
            if ((isDefault = (Boolean)context.get((Object)"isDefault")) == null) {
                isDefault = false;
            }
            PartnerService partnerService = (PartnerService)Beans.get(PartnerService.class);
            partnerService.addPartnerAddress(partner, address, isDefault, invoicing, delivery);
            partnerService.savePartner(partner);
        }
    }

    public void autocompleteAddress(ActionRequest request, ActionResponse response) {
        Address address = (Address)((Object)request.getContext().asType(Address.class));
        ((AddressService)Beans.get(AddressService.class)).autocompleteAddress(address);
        response.setValues((Object)address);
    }
}

