/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.Bank;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.apps.base.service.BankDetailsServiceImpl;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import org.iban4j.IbanFormatException;
import org.iban4j.InvalidCheckDigitException;
import org.iban4j.UnsupportedCountryException;

@Singleton
public class BankDetailsController {
    public void validateIban(ActionRequest request, ActionResponse response) {
        response.setAttr("invalidIbanText", "hidden", (Object)true);
        if (request.getAction().endsWith("onnew")) {
            return;
        }
        BankDetails bankDetails = (BankDetails)((Object)request.getContext().asType(BankDetails.class));
        Bank bank = bankDetails.getBank();
        if (bankDetails.getIban() != null && bank != null && bank.getBankDetailsTypeSelect() == 1) {
            try {
                ((BankDetailsService)Beans.get(BankDetailsService.class)).validateIban(bankDetails.getIban());
                bankDetails = ((BankDetailsServiceImpl)Beans.get(BankDetailsServiceImpl.class)).detailsIban(bankDetails);
                if (bank.getCountry() != null && bank.getCountry().getAlpha2Code().equals("FR")) {
                    response.setValue("bankCode", (Object)bankDetails.getBankCode());
                    response.setValue("sortCode", (Object)bankDetails.getSortCode());
                    response.setValue("accountNbr", (Object)bankDetails.getAccountNbr());
                    response.setValue("bbanKey", (Object)bankDetails.getBbanKey());
                }
            }
            catch (IbanFormatException | InvalidCheckDigitException | UnsupportedCountryException e) {
                if (request.getAction().endsWith("onchange")) {
                    response.setFlash(I18n.get((String)"The entered IBAN code is not valid . <br> Either the code doesn't respect the norm, or the format you have entered is not correct. It has to be without any blank space, as the following : <br> FR0000000000000000000000000"));
                }
                response.setAttr("invalidIbanText", "hidden", (Object)false);
            }
        }
    }
}

