/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.BaseBatch;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.repo.BaseBatchRepository;
import com.axelor.apps.base.service.batch.BaseBatchService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.util.HashMap;

@Singleton
public class BaseBatchController {
    public void run(ActionRequest request, ActionResponse response) throws AxelorException {
        Batch batch = ((BaseBatchService)Beans.get(BaseBatchService.class)).run((String)request.getContext().get((Object)"code"));
        HashMap<String, Integer> mapData = new HashMap<String, Integer>();
        mapData.put("anomaly", batch.getAnomaly());
        response.setData(mapData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionSynchronizeCalendars(ActionRequest request, ActionResponse response) {
        try {
            BaseBatch baseBatch = (BaseBatch)((Object)request.getContext().asType(BaseBatch.class));
            baseBatch = (BaseBatch)((Object)((BaseBatchRepository)((Object)Beans.get(BaseBatchRepository.class))).find(baseBatch.getId()));
            Batch batch = ((BaseBatchService)Beans.get(BaseBatchService.class)).synchronizeCalendars(baseBatch);
            response.setFlash(batch.getComments());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }
}

