/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.FileTab;
import com.axelor.apps.base.db.repo.FileTabRepository;
import com.axelor.apps.base.service.advanced.imports.ActionService;
import com.axelor.apps.base.service.advanced.imports.FileTabService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.repo.MetaJsonFieldRepository;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import org.apache.commons.lang3.StringUtils;

public class FileTabController {
    public void updateFields(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            Context map = context.getParent();
            if (map == null || ((Boolean)map.get("isConfigInFile")).booleanValue()) {
                return;
            }
            FileTab fileTab = (FileTab)((Object)context.asType(FileTab.class));
            ((FileTabService)Beans.get(FileTabService.class)).updateFields(fileTab);
            response.setValue("fileFieldList", fileTab.getFileFieldList());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void compute(ActionRequest request, ActionResponse response) {
        try {
            FileTab fileTab = (FileTab)((Object)request.getContext().asType(FileTab.class));
            fileTab = ((FileTabService)Beans.get(FileTabService.class)).compute(fileTab);
            response.setValues((Object)fileTab);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showRecord(ActionRequest request, ActionResponse response) {
        try {
            FileTab fileTab = (FileTab)((Object)request.getContext().asType(FileTab.class));
            fileTab = (FileTab)((Object)((FileTabRepository)((Object)Beans.get(FileTabRepository.class))).find(fileTab.getId()));
            String btnName = request.getContext().get((Object)"_signal").toString();
            String fieldName = StringUtils.substringBetween((String)btnName, (String)"show", (String)"Btn");
            MetaJsonField jsonField = (MetaJsonField)((MetaJsonFieldRepository)Beans.get(MetaJsonFieldRepository.class)).all().filter("self.name = ?1 AND self.type = 'many-to-many' AND self.model = ?2 AND self.modelField = 'attrs'", new Object[]{fieldName, ((Object)((Object)fileTab)).getClass().getName()}).fetchOne();
            if (jsonField == null) {
                return;
            }
            String ids = ((FileTabService)Beans.get(FileTabService.class)).getShowRecordIds(fileTab, jsonField.getName());
            response.setView(ActionView.define((String)I18n.get((String)jsonField.getTitle())).model(jsonField.getTargetModel()).add("grid", jsonField.getGridView()).add("form", jsonField.getFormView()).domain("self.id IN (" + ids + ")").map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validateActions(ActionRequest request, ActionResponse response) {
        FileTab fileTab = (FileTab)((Object)request.getContext().asType(FileTab.class));
        if (StringUtils.isEmpty((CharSequence)fileTab.getActions())) {
            return;
        }
        ActionService actionService = (ActionService)Beans.get(ActionService.class);
        if (!actionService.validate(fileTab.getActions()).booleanValue()) {
            response.setError(String.format("Action does not exists or invalid for the object(%s)", fileTab.getMetaModel().getName()));
        }
    }
}

