/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.ICalendar;
import com.axelor.apps.base.db.ICalendarEvent;
import com.axelor.apps.base.db.ImportConfiguration;
import com.axelor.apps.base.db.repo.ICalendarRepository;
import com.axelor.apps.base.ical.ICalendarException;
import com.axelor.apps.base.ical.ICalendarService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import net.fortuna.ical4j.data.ParserException;

@Singleton
public class ICalendarController {
    public void exportCalendar(ActionRequest request, ActionResponse response) throws IOException, ParseException {
        ICalendar cal = (ICalendar)((Object)request.getContext().asType(ICalendar.class));
        Path tempPath = MetaFiles.createTempFile((String)cal.getName(), (String)".ics", (FileAttribute[])new FileAttribute[0]);
        ((ICalendarService)Beans.get(ICalendarService.class)).export(cal, tempPath.toFile());
        ((MetaFiles)Beans.get(MetaFiles.class)).attach((InputStream)new FileInputStream(tempPath.toFile()), cal.getName() + ".ics", (Model)((Object)cal));
        response.setReload(true);
    }

    public void importCalendarFile(ActionRequest request, ActionResponse response) throws IOException, ParserException {
        ImportConfiguration imp = (ImportConfiguration)((Object)request.getContext().asType(ImportConfiguration.class));
        Object object = request.getContext().get((Object)"_id");
        ICalendar cal = null;
        if (object != null) {
            Long id = Long.valueOf(object.toString());
            cal = (ICalendar)((Object)((ICalendarRepository)((Object)Beans.get(ICalendarRepository.class))).find(id));
        }
        if (cal == null) {
            cal = new ICalendar();
        }
        File data = MetaFiles.getPath((MetaFile)imp.getDataMetaFile()).toFile();
        ((ICalendarService)Beans.get(ICalendarService.class)).load(cal, data);
        response.setCanClose(true);
        response.setReload(true);
    }

    public void importCalendar(ActionRequest request, ActionResponse response) {
        ICalendar cal = (ICalendar)((Object)request.getContext().asType(ICalendar.class));
        response.setView(ActionView.define((String)I18n.get((String)"Import calendar")).model("com.axelor.apps.base.db.ImportConfiguration").add("form", "import-icalendar-form").param("popup", "reload").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").context("_id", (Object)cal.getId()).map());
    }

    public void testConnect(ActionRequest request, ActionResponse response) {
        try {
            ICalendar cal = (ICalendar)((Object)request.getContext().asType(ICalendar.class));
            ((ICalendarService)Beans.get(ICalendarService.class)).testConnect(cal);
            response.setValue("isValid", (Object)true);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            response.setFlash("Configuration error");
            response.setValue("isValid", (Object)false);
        }
    }

    public void synchronizeCalendar(ActionRequest request, ActionResponse response) throws MalformedURLException, ICalendarException {
        ICalendar cal = (ICalendar)((Object)request.getContext().asType(ICalendar.class));
        cal = (ICalendar)((Object)((ICalendarRepository)((Object)Beans.get(ICalendarRepository.class))).find(cal.getId()));
        ((ICalendarService)Beans.get(ICalendarService.class)).sync(cal, false, 0);
        response.setReload(true);
    }

    public void validate(ActionRequest request, ActionResponse response) {
        if (request.getContext().get((Object)"newPassword") != null) {
            response.setValue("password", (Object)((ICalendarService)Beans.get(ICalendarService.class)).getCalendarEncryptPassword(request.getContext().get((Object)"newPassword").toString()));
        }
    }

    public void showMyEvents(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        response.setView(ActionView.define((String)I18n.get((String)"My events")).model(ICalendarEvent.class.getName()).add("calendar", "calendar-event-all").add("grid", "calendar-event-grid").add("form", "calendar-event-form").domain("self.user.id = :_userId OR self.calendar.user.id = :_userId OR :_userId IN (SELECT attendee.user FROM self.attendees attendee) OR self.organizer.user.id = :_userId OR :_userId IN (SELECT setting.sharedWith FROM self.calendar.sharingSettingList setting WHERE setting.visible = TRUE)").context("_userId", (Object)user.getId()).map());
    }
}

