/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.tool.ModelTool;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.common.ObjectUtils;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.ValidationException;

@Singleton
public class UserController {
    protected static final Map<String, String> UNIQUE_MESSAGES = ImmutableMap.of((Object)"code", (Object)"A user with this login already exists.");

    @Transactional
    public void setUserPartner(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            if (context.get((Object)"user_id") != null) {
                UserRepository userRepo = (UserRepository)((Object)Beans.get(UserRepository.class));
                Partner partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(((Partner)((Object)context.asType(Partner.class))).getId()));
                User user = (User)((Object)userRepo.find(((Integer)context.get((Object)"user_id")).longValue()));
                user.setPartner(partner);
                userRepo.save((Model)((Object)user));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    public void applyApplicationMode(ActionRequest request, ActionResponse response) {
        String applicationMode = AppSettings.get().get("application.mode", "prod");
        if ("dev".equals(applicationMode)) {
            response.setAttr("testingPanel", "hidden", (Object)false);
        }
    }

    public void validate(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            User user = (User)((Object)request.getContext().asType(User.class));
            Map errors = ModelTool.getUniqueErrors((Model)((Object)user), UNIQUE_MESSAGES);
            if (!errors.isEmpty()) {
                response.setErrors(errors);
                return;
            }
            UserService userService = (UserService)Beans.get(UserService.class);
            user = userService.changeUserPassword(user, (Map<String, Object>)context);
            response.setValue("transientPassword", (Object)user.getTransientPassword());
        }
        catch (ValidationException e) {
            response.setError(e.getMessage());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateRandomPassword(ActionRequest request, ActionResponse response) {
        try {
            UserService userService = (UserService)Beans.get(UserService.class);
            CharSequence password = userService.generateRandomPassword();
            response.setValue("newPassword", (Object)password);
            response.setValue("chkPassword", (Object)password);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validatePassword(ActionRequest request, ActionResponse response) {
        try {
            UserService userService = (UserService)Beans.get(UserService.class);
            String newPassword = (String)MoreObjects.firstNonNull((Object)((String)request.getContext().get((Object)"newPassword")), (Object)"");
            boolean valid = userService.matchPasswordPattern(newPassword);
            response.setAttr("passwordPatternDescriptionLabel", "hidden", (Object)valid);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void openGenerateRandomPasswordsWizard(ActionRequest request, ActionResponse response) {
        try {
            List userIds = (List)request.getContext().get((Object)"_ids");
            if (ObjectUtils.isEmpty((Object)userIds)) {
                response.setError(I18n.get((String)"Please select at least one record."));
                return;
            }
            ActionView.ActionViewBuilder view = ActionView.define((String)I18n.get((String)"Generate random passwords")).model(Wizard.class.getName()).add("form", "generate-random-passwords-wizard").param("popup", "reload").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").context("_userIds", (Object)userIds);
            response.setView(view.map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateRandomPasswords(ActionRequest request, ActionResponse response) {
        try {
            List ids = Lists.transform((List)((List)request.getContext().get((Object)"_userIds")), (Function)new Function<Object, Long>(){

                @Nullable
                public Long apply(@Nullable Object input) {
                    return Long.parseLong(input.toString());
                }
            });
            String currentUserPassword = (String)request.getContext().get((Object)"currentUserPassword");
            boolean isValidUser = ((UserService)Beans.get(UserService.class)).verifyCurrentUserPassword(currentUserPassword);
            if (!isValidUser) {
                response.setError(I18n.get((String)"Current user password is wrong."));
                return;
            }
            ((UserService)Beans.get(UserService.class)).generateRandomPasswordForUsers(ids);
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

