/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.report.engine;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.PartnerServiceImpl;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportSettings {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String FORMAT_PDF = "pdf";
    public static final String FORMAT_XLS = "xls";
    public static final String FORMAT_XLSX = "xlsx";
    public static final String FORMAT_DOC = "doc";
    public static final String FORMAT_DOCX = "docx";
    public static final String FORMAT_ODS = "ods";
    public static final String FORMAT_ODT = "odt";
    public static final String FORMAT_HTML = "html";
    protected Map<String, Object> params = Maps.newHashMap();
    protected String format = "pdf";
    protected String rptdesign;
    protected String outputName;
    protected Model model;
    protected String fileName;
    protected File output;
    private boolean FLAG_ATTACH = false;

    public ReportSettings(String rptdesign, String outputName) {
        this.rptdesign = rptdesign;
        this.computeOutputName(outputName);
        this.addDataBaseConnection();
        this.addAttachmentPath();
    }

    public ReportSettings generate() throws AxelorException {
        this.computeFileName();
        return this;
    }

    public String getFileLink() {
        if (this.output == null) {
            return null;
        }
        String fileLink = "ws/files/report/" + this.output.getName();
        try {
            fileLink = fileLink + "?name=" + URLEncoder.encode(this.fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getLocalizedMessage());
        }
        this.logger.debug("URL : {}", (Object)fileLink);
        return fileLink;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public File getFile() {
        return this.output;
    }

    protected void attach() throws FileNotFoundException, IOException {
        if (this.FLAG_ATTACH && this.model.getId() != null && this.output != null) {
            try (FileInputStream is = new FileInputStream(this.output);){
                ((MetaFiles)Beans.get(MetaFiles.class)).attach((InputStream)is, this.fileName, this.model);
            }
        }
    }

    protected void computeOutputName(String outputName) {
        this.outputName = outputName.replace("${date}", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).replace("${time}", LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        this.outputName = StringTool.getFilename((String)this.outputName);
    }

    protected void computeFileName() {
        this.fileName = String.format("%s.%s", this.outputName, this.format);
    }

    public ReportSettings addFormat(String format) {
        if (format != null) {
            this.format = format;
        }
        return this;
    }

    public ReportSettings toAttach(Model model) {
        this.model = Objects.requireNonNull(model);
        this.FLAG_ATTACH = true;
        return this;
    }

    public ReportSettings addParam(String param, Object value) {
        this.params.put(param, value);
        return this;
    }

    protected ReportSettings addDataBaseConnection() {
        AppSettings appSettings = AppSettings.get();
        return this.addParam("DefaultDriver", appSettings.get("db.default.driver")).addParam("DBName", appSettings.get("db.default.url")).addParam("UserName", appSettings.get("db.default.user")).addParam("Password", appSettings.get("db.default.password"));
    }

    private ReportSettings addAttachmentPath() {
        String attachmentPath = AppSettings.get().getPath("file.upload.dir", "");
        if (attachmentPath == null) {
            return this;
        }
        attachmentPath = attachmentPath.endsWith(File.separator) ? attachmentPath : attachmentPath + File.separator;
        return this.addParam("AttachmentPath", attachmentPath);
    }

    public static boolean useIntegratedEngine() {
        AppSettings appsSettings = AppSettings.get();
        String useIntegratedEngine = appsSettings.get("axelor.report.use.embedded.engine", "true");
        return "true".equals(useIntegratedEngine);
    }

    public static String getPrintingLocale(Partner partner) {
        if (partner != null) {
            return ((PartnerServiceImpl)Beans.get(PartnerServiceImpl.class)).getPartnerLanguageCode(partner);
        }
        return ((UserService)Beans.get(UserService.class)).getLanguage();
    }

    public static String getPrintingLocale() {
        return ReportSettings.getPrintingLocale(null);
    }
}

