/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.base.service.ical;

import com.axelor.apps.base.db.ICalendarEvent;
import com.axelor.apps.base.db.ICalendarUser;
import com.axelor.apps.base.ical.ICalendarException;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.base.service.ical.ICalendarEventService;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import javax.mail.MessagingException;

public class ICalendarEventServiceImpl
implements ICalendarEventService {
    @Inject
    protected UserRepository userRepository;

    @Override
    public List<ICalendarUser> addEmailGuest(EmailAddress email, ICalendarEvent event) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxelorException, MessagingException, IOException, ICalendarException, ParseException {
        if (!(email == null || event.getAttendees() != null && event.getAttendees().stream().anyMatch(x -> email.getAddress().equals(x.getEmail())))) {
            ICalendarUser calUser = new ICalendarUser();
            calUser.setEmail(email.getAddress());
            calUser.setName(email.getName());
            if (email.getPartner() != null) {
                calUser.setUser((User)((Object)this.userRepository.all().filter("self.partner.id = ?1", new Object[]{email.getPartner().getId()}).fetchOne()));
            }
            event.addAttendee(calUser);
        }
        return event.getAttendees();
    }
}

