/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.meta.CallMethod;
import com.google.common.base.Strings;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportDateTime {
    String pat = "((\\+|\\-)?[0-9]{1,%s}%s)";
    String dt = "[0-9]{4}-[0-9]{2}-[0-9]{2}";
    Pattern patternYear = Pattern.compile("[0-9]{1,4}");
    Pattern patternMonth = Pattern.compile("[0-9]{1,2}");

    public LocalDateTime updateYear(LocalDateTime datetime, String year) {
        Matcher matcher;
        if (!Strings.isNullOrEmpty((String)year) && (matcher = this.patternYear.matcher(year)).find()) {
            Long years = Long.parseLong(matcher.group());
            datetime = year.startsWith("+") ? datetime.plusYears(years) : (year.startsWith("-") ? datetime.minusYears(years) : datetime.withYear(years.intValue()));
        }
        return datetime;
    }

    public LocalDateTime updateMonth(LocalDateTime datetime, String month) {
        Matcher matcher;
        if (!Strings.isNullOrEmpty((String)month) && (matcher = this.patternMonth.matcher(month)).find()) {
            Long months = Long.parseLong(matcher.group());
            datetime = month.startsWith("+") ? datetime.plusMonths(months) : (month.startsWith("-") ? datetime.minusMonths(months) : datetime.withMonth(months.intValue()));
        }
        return datetime;
    }

    public LocalDateTime updateDay(LocalDateTime datetime, String day) {
        Matcher matcher;
        if (!Strings.isNullOrEmpty((String)day) && (matcher = this.patternMonth.matcher(day)).find()) {
            Long days = Long.parseLong(matcher.group());
            if (day.startsWith("+")) {
                datetime = datetime.plusDays(days);
            } else if (day.startsWith("-")) {
                datetime = datetime.minusDays(days);
            } else {
                if (days > (long)datetime.toLocalDate().lengthOfMonth()) {
                    days = datetime.toLocalDate().lengthOfMonth();
                }
                datetime = datetime.withDayOfMonth(days.intValue());
            }
        }
        return datetime;
    }

    public LocalDateTime updateHour(LocalDateTime datetime, String hour) {
        Matcher matcher;
        if (!Strings.isNullOrEmpty((String)hour) && (matcher = this.patternMonth.matcher(hour)).find()) {
            Long hours = Long.parseLong(matcher.group());
            datetime = hour.startsWith("+") ? datetime.plusHours(hours) : (hour.startsWith("-") ? datetime.minusHours(hours) : datetime.withHour(hours.intValue()));
        }
        return datetime;
    }

    public LocalDateTime updateMinute(LocalDateTime datetime, String minute) {
        Matcher matcher;
        if (!Strings.isNullOrEmpty((String)minute) && (matcher = this.patternMonth.matcher(minute)).find()) {
            Long minutes = Long.parseLong(matcher.group());
            datetime = minute.startsWith("+") ? datetime.plusMinutes(minutes) : (minute.startsWith("-") ? datetime.minusMinutes(minutes) : datetime.withMinute(minutes.intValue()));
        }
        return datetime;
    }

    public LocalDateTime updateSecond(LocalDateTime datetime, String second) {
        Matcher matcher;
        if (!Strings.isNullOrEmpty((String)second) && (matcher = this.patternMonth.matcher(second)).find()) {
            Long seconds = Long.parseLong(matcher.group());
            datetime = second.startsWith("+") ? datetime.plusSeconds(seconds) : (second.startsWith("-") ? datetime.minusSeconds(seconds) : datetime.withSecond(seconds.intValue()));
        }
        return datetime;
    }

    @CallMethod
    public String importDate(String inputDate) {
        String patDate = "(" + this.dt + "|TODAY)(\\[(" + String.format(this.pat, 4, "y") + "?" + String.format(this.pat, 2, "M") + "?" + String.format(this.pat, 2, "d") + "?)\\])?";
        try {
            if (!Strings.isNullOrEmpty((String)inputDate) && inputDate.matches(patDate)) {
                List<String> dates = Arrays.asList(inputDate.split("\\["));
                String string = inputDate = dates.get(0).equals("TODAY") ? LocalDate.now().toString() : dates.get(0);
                if (dates.size() > 1) {
                    LocalDateTime localDate = LocalDate.parse(inputDate, DateTimeFormatter.ISO_DATE).atStartOfDay();
                    Matcher matcher = Pattern.compile(String.format(this.pat, 4, "y")).matcher(dates.get(1));
                    if (matcher.find()) {
                        localDate = this.updateYear(localDate, matcher.group());
                    }
                    if ((matcher = Pattern.compile(String.format(this.pat, 2, "M")).matcher(dates.get(1))).find()) {
                        localDate = this.updateMonth(localDate, matcher.group());
                    }
                    if ((matcher = Pattern.compile(String.format(this.pat, 2, "d")).matcher(dates.get(1))).find()) {
                        localDate = this.updateDay(localDate, matcher.group());
                    }
                    return localDate.toString();
                }
                return inputDate;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String importDateTime(String inputDateTime) {
        String tm = "[0-9]{2}:[0-9]{2}:[0-9]{2}";
        String patTime = "(" + this.dt + " " + tm + "|NOW)(\\[(" + String.format(this.pat, 4, "y") + "?" + String.format(this.pat, 2, "M") + "?" + String.format(this.pat, 2, "d") + "?" + String.format(this.pat, 2, "H") + "?" + String.format(this.pat, 2, "m") + "?" + String.format(this.pat, 2, "s") + "?)\\])?";
        try {
            if (!Strings.isNullOrEmpty((String)inputDateTime) && inputDateTime.matches(patTime)) {
                List<String> timeList = Arrays.asList(inputDateTime.split("\\["));
                String string = inputDateTime = timeList.get(0).equals("NOW") ? LocalDateTime.now().toString() : timeList.get(0);
                if (timeList.size() > 1) {
                    LocalDateTime datetime = LocalDateTime.parse(inputDateTime, DateTimeFormatter.ISO_DATE_TIME);
                    Matcher matcher = Pattern.compile(String.format(this.pat, 4, "y")).matcher(timeList.get(1));
                    if (matcher.find()) {
                        datetime = this.updateYear(datetime, matcher.group());
                    }
                    if ((matcher = Pattern.compile(String.format(this.pat, 2, "M")).matcher(timeList.get(1))).find()) {
                        datetime = this.updateMonth(datetime, matcher.group());
                    }
                    if ((matcher = Pattern.compile(String.format(this.pat, 2, "d")).matcher(timeList.get(1))).find()) {
                        datetime = this.updateDay(datetime, matcher.group());
                    }
                    if ((matcher = Pattern.compile(String.format(this.pat, 2, "H")).matcher(timeList.get(1))).find()) {
                        datetime = this.updateHour(datetime, matcher.group());
                    }
                    if ((matcher = Pattern.compile(String.format(this.pat, 2, "m")).matcher(timeList.get(1))).find()) {
                        datetime = this.updateMinute(datetime, matcher.group());
                    }
                    if ((matcher = Pattern.compile(String.format(this.pat, 2, "s")).matcher(timeList.get(1))).find()) {
                        datetime = this.updateSecond(datetime, matcher.group());
                    }
                    return datetime.toString();
                }
                return inputDateTime.replace(" ", "T");
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

