/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.ProductService;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.inject.Inject;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportProduct {
    private final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private ProductService productService;
    @Inject
    private ProductRepository productRepo;
    @Inject
    MetaFiles metaFiles;

    public Object importProduct(Object bean, Map<String, Object> values) {
        assert (bean instanceof Product);
        Product product = (Product)((Object)bean);
        String fileName = (String)values.get("picture_fileName");
        if (!StringUtils.isEmpty((CharSequence)fileName)) {
            Path path = (Path)values.get("__path__");
            try {
                File image = path.resolve(fileName).toFile();
                if (image != null && image.isFile()) {
                    MetaFile metaFile = this.metaFiles.upload(image);
                    product.setPicture(metaFile);
                } else {
                    this.LOG.debug("No image file found: {}", image == null ? path.toAbsolutePath() : image.getAbsolutePath());
                }
            }
            catch (Exception e) {
                this.LOG.error("Error when importing product picture : {}", (Throwable)e);
            }
        }
        return this.productRepo.save((Model)((Object)product));
    }

    public Object generateVariant(Object bean, Map<String, Object> values) {
        assert (bean instanceof Product);
        Product product = (Product)((Object)bean);
        this.LOG.debug("Product : {}, Variant config: {}", (Object)product.getCode(), (Object)product.getProductVariantConfig());
        if (product.getProductVariantConfig() != null) {
            this.productService.generateProductVariants(product);
        }
        return bean;
    }
}

