/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.tool.file.CsvTool;
import com.axelor.apps.tool.xml.XPathParse;
import com.axelor.inject.Beans;
import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PrepareCsv {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void prepareCsv(String xmlDir, String csvDir) {
        List<String> ignoreType = Arrays.asList("one-to-one", "many-to-many", "one-to-many");
        try {
            if (xmlDir != null && csvDir != null) {
                File xDir = new File(xmlDir);
                File cDir = new File(csvDir);
                ArrayList blankData = new ArrayList();
                DocumentBuilder dBuilder = ((XPathParse)Beans.get(XPathParse.class)).getDocumentBuilderFactory().newDocumentBuilder();
                if (xDir.isDirectory() && cDir.isDirectory()) {
                    for (File xf : xDir.listFiles()) {
                        LOG.info("Processing XML: {} ", (Object)xf.getName());
                        ArrayList<String> fieldList = new ArrayList<String>();
                        Document doc = dBuilder.parse(xf);
                        NodeList nList = doc.getElementsByTagName("module");
                        String module = nList.item(0).getAttributes().getNamedItem("name").getNodeValue();
                        nList = doc.getElementsByTagName("entity");
                        if (nList == null) continue;
                        NodeList fields = nList.item(0).getChildNodes();
                        Integer count = 0;
                        String csvFileName = module + "_" + CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, xf.getName().replace(".xml", ".csv"));
                        while (count < fields.getLength()) {
                            Node field = fields.item(count);
                            NamedNodeMap attrs = field.getAttributes();
                            String type = field.getNodeName();
                            if (attrs != null && attrs.getNamedItem("name") != null && !ignoreType.contains(type)) {
                                String fieldName = attrs.getNamedItem("name").getNodeValue();
                                if (type.equals("many-to-one")) {
                                    String[] objName = attrs.getNamedItem("ref").getNodeValue().split("\\.");
                                    String refName = objName[objName.length - 1];
                                    String nameColumn = this.getNameColumn(xmlDir + "/" + refName + ".xml");
                                    if (nameColumn != null) {
                                        fieldList.add(fieldName + "." + nameColumn);
                                    } else {
                                        fieldList.add(fieldName);
                                    }
                                } else {
                                    fieldList.add(fieldName);
                                }
                            }
                            Integer n = count;
                            Integer n2 = count = Integer.valueOf(count + 1);
                        }
                        CsvTool.csvWriter((String)csvDir, (String)csvFileName, (char)';', (String[])StringUtils.join(fieldList, (String)",").split(","), blankData);
                        LOG.info("CSV file prepared: {} ", (Object)csvFileName);
                    }
                } else {
                    LOG.error("XML and CSV paths must be directory");
                }
            } else {
                LOG.error("Please input XML and CSV directory path");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getNameColumn(String fileName) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder dBuilder = ((XPathParse)Beans.get(XPathParse.class)).getDocumentBuilderFactory().newDocumentBuilder();
        File domainFile = new File(fileName);
        if (!domainFile.exists()) {
            return null;
        }
        Document doc = dBuilder.parse(domainFile);
        NodeList nList = doc.getElementsByTagName("entity");
        if (nList != null) {
            NodeList fields = nList.item(0).getChildNodes();
            Integer count = 0;
            while (count < fields.getLength()) {
                NamedNodeMap attrs = fields.item(count).getAttributes();
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                if (attrs == null || attrs.getNamedItem("name") == null) continue;
                String name = attrs.getNamedItem("name").getNodeValue();
                if (name.equals("importId")) {
                    return "importId";
                }
                if (name.equals("code")) {
                    return "code";
                }
                if (!name.equals("name")) continue;
                return "name";
            }
        }
        return null;
    }
}

