/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PartnerAddress;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.MapRestService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.tool.service.TranslationService;
import com.axelor.auth.AuthUtils;
import com.axelor.common.StringUtils;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/map")
public class MapRest {
    @Inject
    private MapRestService mapRestService;
    @Inject
    private TranslationService translationService;
    @Inject
    private PartnerService partnerService;
    @Inject
    private PartnerRepository partnerRepo;
    JsonNodeFactory nodeFactory = JsonNodeFactory.instance;

    @Path(value="/partner")
    @GET
    @Produces(value={"application/json"})
    public JsonNode getPartners() {
        ObjectNode mainNode = this.nodeFactory.objectNode();
        try {
            List partners = this.partnerRepo.all().filter("self.isCustomer = true OR self.isSupplier = true AND self.isContact=?", new Object[]{false}).fetch();
            ArrayNode arrayNode = this.nodeFactory.arrayNode();
            for (Partner partner : partners) {
                String pinChar;
                Address address;
                ObjectNode objectNode = this.nodeFactory.objectNode();
                objectNode.put("fullName", partner.getFullName());
                if (partner.getFixedPhone() != null) {
                    objectNode.put("fixedPhone", partner.getFixedPhone());
                }
                if (partner.getEmailAddress() != null) {
                    objectNode.put("emailAddress", partner.getEmailAddress().getAddress());
                }
                if ((address = this.partnerService.getInvoicingAddress(partner)) == null || !StringUtils.notBlank((CharSequence)address.getFullName()) || !address.getIsValidLatLong().booleanValue()) continue;
                String addressString = this.mapRestService.makeAddressString(address, objectNode);
                objectNode.put("address", addressString);
                objectNode.put("pinColor", partner.getIsProspect() != false ? "red" : "orange");
                String string = pinChar = partner.getIsProspect() != false ? "P" : "C";
                if (partner.getIsSupplier().booleanValue()) {
                    pinChar = pinChar + "/S";
                }
                objectNode.put("pinChar", pinChar);
                arrayNode.add((JsonNode)objectNode);
            }
            this.mapRestService.setData(mainNode, arrayNode);
        }
        catch (Exception e) {
            this.mapRestService.setError(mainNode, e);
        }
        return mainNode;
    }

    @Path(value="/partner/{id}")
    @GET
    @Produces(value={"application/json"})
    public JsonNode getPartner(@PathParam(value="id") long id) {
        ObjectNode mainNode = this.nodeFactory.objectNode();
        try {
            Partner partner = (Partner)((Object)this.partnerRepo.find(id));
            if (partner == null) {
                throw new AxelorException(Partner.class, 3, I18n.get((String)"Partner not found"));
            }
            ArrayNode arrayNode = this.nodeFactory.arrayNode();
            String pinColor = this.getPinColor(partner);
            List<Object> partnerAddressList = partner.getPartnerAddressList() != null ? partner.getPartnerAddressList() : Collections.emptyList();
            for (PartnerAddress partnerAddress : partnerAddressList) {
                Address address = partnerAddress.getAddress();
                if (address == null || address != null && !address.getIsValidLatLong().booleanValue()) continue;
                ObjectNode objectNode = this.nodeFactory.objectNode();
                objectNode.put("fullName", this.getFullName(partnerAddress));
                if (partnerAddress.getIsDefaultAddr().booleanValue()) {
                    if (!StringUtils.isBlank((CharSequence)partner.getFixedPhone())) {
                        objectNode.put("fixedPhone", partner.getFixedPhone());
                    }
                    if (partner.getEmailAddress() != null) {
                        objectNode.put("emailAddress", partner.getEmailAddress().getAddress());
                    }
                }
                if (!StringUtils.isBlank((CharSequence)address.getFullName())) {
                    String addressString = this.mapRestService.makeAddressString(address, objectNode);
                    objectNode.put("address", addressString);
                }
                objectNode.put("pinColor", pinColor);
                objectNode.put("pinChar", this.getPinChar(partnerAddress));
                arrayNode.add((JsonNode)objectNode);
            }
            this.mapRestService.setData(mainNode, arrayNode);
        }
        catch (Exception e) {
            this.mapRestService.setError(mainNode, e);
        }
        return mainNode;
    }

    @Path(value="/customer")
    @GET
    @Produces(value={"application/json"})
    public JsonNode getCustomers() {
        ObjectNode mainNode = this.nodeFactory.objectNode();
        try {
            List customers = this.partnerRepo.all().filter("self.isCustomer = true AND self.isContact=?", new Object[]{false}).fetch();
            ArrayNode arrayNode = this.nodeFactory.arrayNode();
            for (Partner customer : customers) {
                Address address;
                ObjectNode objectNode = this.nodeFactory.objectNode();
                objectNode.put("fullName", customer.getFullName());
                objectNode.put("fixedPhone", customer.getFixedPhone() != null ? customer.getFixedPhone() : " ");
                if (customer.getEmailAddress() != null) {
                    objectNode.put("emailAddress", customer.getEmailAddress().getAddress());
                }
                if ((address = this.partnerService.getInvoicingAddress(customer)) == null || !address.getIsValidLatLong().booleanValue()) continue;
                String addressString = this.mapRestService.makeAddressString(address, objectNode);
                objectNode.put("address", addressString);
                objectNode.put("pinColor", "orange");
                objectNode.put("pinChar", "C");
                arrayNode.add((JsonNode)objectNode);
            }
            this.mapRestService.setData(mainNode, arrayNode);
        }
        catch (Exception e) {
            this.mapRestService.setError(mainNode, e);
        }
        return mainNode;
    }

    @Path(value="/prospect")
    @GET
    @Produces(value={"application/json"})
    public JsonNode getProspects() {
        ObjectNode mainNode = this.nodeFactory.objectNode();
        try {
            List customers = this.partnerRepo.all().filter("self.isProspect = true AND self.isContact=?", new Object[]{false}).fetch();
            ArrayNode arrayNode = this.nodeFactory.arrayNode();
            for (Partner prospect : customers) {
                Address address;
                ObjectNode objectNode = this.nodeFactory.objectNode();
                objectNode.put("fullName", prospect.getFullName());
                objectNode.put("fixedPhone", prospect.getFixedPhone() != null ? prospect.getFixedPhone() : " ");
                if (prospect.getEmailAddress() != null) {
                    objectNode.put("emailAddress", prospect.getEmailAddress().getAddress());
                }
                if ((address = this.partnerService.getInvoicingAddress(prospect)) == null || !address.getIsValidLatLong().booleanValue()) continue;
                String addressString = this.mapRestService.makeAddressString(address, objectNode);
                objectNode.put("address", addressString);
                objectNode.put("pinColor", "red");
                objectNode.put("pinChar", "P");
                arrayNode.add((JsonNode)objectNode);
            }
            this.mapRestService.setData(mainNode, arrayNode);
        }
        catch (Exception e) {
            this.mapRestService.setError(mainNode, e);
        }
        return mainNode;
    }

    @Path(value="/supplier")
    @GET
    @Produces(value={"application/json"})
    public JsonNode getSuppliers() {
        ObjectNode mainNode = this.nodeFactory.objectNode();
        try {
            ArrayNode arrayNode = this.nodeFactory.arrayNode();
            List customers = this.partnerRepo.all().filter("self.isSupplier = true AND self.isContact=?", new Object[]{false}).fetch();
            for (Partner supplier : customers) {
                Address address;
                ObjectNode objectNode = this.nodeFactory.objectNode();
                objectNode.put("fullName", supplier.getFullName());
                objectNode.put("fixedPhone", supplier.getFixedPhone() != null ? supplier.getFixedPhone() : " ");
                if (supplier.getEmailAddress() != null) {
                    objectNode.put("emailAddress", supplier.getEmailAddress().getAddress());
                }
                if ((address = this.partnerService.getInvoicingAddress(supplier)) == null || !address.getIsValidLatLong().booleanValue()) continue;
                String addressString = this.mapRestService.makeAddressString(address, objectNode);
                objectNode.put("address", addressString);
                objectNode.put("pinColor", "purple");
                objectNode.put("pinChar", "S");
                arrayNode.add((JsonNode)objectNode);
            }
            this.mapRestService.setData(mainNode, arrayNode);
        }
        catch (Exception e) {
            this.mapRestService.setError(mainNode, e);
        }
        return mainNode;
    }

    @Path(value="translation/{key}")
    @GET
    @Produces(value={"application/json"})
    public JsonNode getTranslation(@PathParam(value="key") String key) {
        ObjectNode mainNode = this.nodeFactory.objectNode();
        String language = AuthUtils.getUser().getLanguage();
        String translation = this.translationService.getTranslation(key, language);
        if (translation.equals(key)) {
            translation = translation.substring("MapRest.".length());
        }
        mainNode.put("translation", translation);
        return mainNode;
    }

    protected String getFullName(PartnerAddress partnerAddress) {
        String fullName = partnerAddress.getPartner().getFullName();
        if (StringUtils.isBlank((CharSequence)fullName)) {
            fullName = "";
        }
        ArrayList<String> texts = new ArrayList<String>();
        if (partnerAddress.getIsDefaultAddr().booleanValue()) {
            texts.add(I18n.get((String)"MapRest.Default"));
        }
        if (partnerAddress.getIsInvoicingAddr().booleanValue()) {
            texts.add(I18n.get((String)"MapRest.Invoicing"));
        }
        if (partnerAddress.getIsDeliveryAddr().booleanValue()) {
            texts.add(I18n.get((String)"MapRest.Delivery"));
        }
        if (!texts.isEmpty()) {
            fullName = fullName + String.format(" (%s)", String.join((CharSequence)", ", texts));
        }
        return fullName;
    }

    protected String getPinColor(Partner partner) {
        return partner.getIsProspect() != false ? "red" : "orange";
    }

    protected String getPinChar(PartnerAddress partnerAddress) {
        if (partnerAddress.getIsDefaultAddr().booleanValue()) {
            return "";
        }
        if (partnerAddress.getIsInvoicingAddr().booleanValue()) {
            return I18n.get((String)"MapRest.PinCharInvoicing");
        }
        if (partnerAddress.getIsDeliveryAddr().booleanValue()) {
            return I18n.get((String)"MapRest.PinCharDelivery");
        }
        return "";
    }
}

