/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MESSAGE_EMAIL_ACCOUNT", indexes={@Index(columnList="name")})
public class EmailAccount
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MESSAGE_EMAIL_ACCOUNT_SEQ")
    @SequenceGenerator(name="MESSAGE_EMAIL_ACCOUNT_SEQ", sequenceName="MESSAGE_EMAIL_ACCOUNT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NameColumn
    @NotNull
    private String name;
    @Widget(title="Server Type", selection="mail.account.server.type.select")
    @NotNull
    private Integer serverTypeSelect = 1;
    @Widget(title="Login")
    private String login;
    @Widget(title="Password")
    private String password;
    @Widget(title="Host")
    @NotNull
    private String host;
    @Widget(title="Port")
    @Min(value=1L)
    @Column(nullable=true)
    private Integer port;
    @Widget(title="SSL/STARTTLS", selection="mail.account.security.select")
    private Integer securitySelect = 0;
    @Widget(title="Default account")
    private Boolean isDefault = Boolean.FALSE;
    @Widget(title="Valid")
    private Boolean isValid = Boolean.FALSE;
    @Widget(title="Signature")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String signature;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public EmailAccount() {
    }

    public EmailAccount(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getServerTypeSelect() {
        return this.serverTypeSelect == null ? 0 : this.serverTypeSelect;
    }

    public void setServerTypeSelect(Integer serverTypeSelect) {
        this.serverTypeSelect = serverTypeSelect;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getSecuritySelect() {
        return this.securitySelect == null ? 0 : this.securitySelect;
    }

    public void setSecuritySelect(Integer securitySelect) {
        this.securitySelect = securitySelect;
    }

    public Boolean getIsDefault() {
        return this.isDefault == null ? Boolean.FALSE : this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Boolean getIsValid() {
        return this.isValid == null ? Boolean.FALSE : this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmailAccount)) {
            return false;
        }
        EmailAccount other = (EmailAccount)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("serverTypeSelect", (Object)this.getServerTypeSelect()).add("login", (Object)this.getLogin()).add("password", (Object)this.getPassword()).add("host", (Object)this.getHost()).add("port", (Object)this.getPort()).add("securitySelect", (Object)this.getSecuritySelect()).add("isDefault", (Object)this.getIsDefault()).add("isValid", (Object)this.getIsValid()).omitNullValues().toString();
    }
}

