/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.job;

import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.db.repo.EmailAccountRepository;
import com.axelor.apps.message.service.MailAccountService;
import com.axelor.exception.service.TraceBackService;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import javax.mail.MessagingException;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchEmailJob
implements Job {
    private final Logger log = LoggerFactory.getLogger(FetchEmailJob.class);
    @Inject
    private MailAccountService mailAccountService;
    @Inject
    private EmailAccountRepository mailAccountRepo;

    public void execute(JobExecutionContext context) {
        List mailAccounts = this.mailAccountRepo.all().filter("self.isValid = true and self.serverTypeSelect > 1").fetch();
        this.log.debug("Total email fetching accounts : {}", (Object)mailAccounts.size());
        for (EmailAccount account : mailAccounts) {
            try {
                Integer total = this.mailAccountService.fetchEmails(account, true);
                this.log.debug("Email fetched for account: {}, total: {} ", (Object)account.getName(), (Object)total);
            }
            catch (IOException | MessagingException e) {
                TraceBackService.trace((Throwable)e);
            }
        }
    }
}

