/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.service;

import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.repo.EmailAccountRepository;
import com.axelor.apps.message.db.repo.EmailAddressRepository;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.service.MailAccountService;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.apps.tool.service.CipherService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.mail.ImapAccount;
import com.axelor.mail.MailAccount;
import com.axelor.mail.MailParser;
import com.axelor.mail.MailReader;
import com.axelor.mail.Pop3Account;
import com.axelor.mail.SmtpAccount;
import com.axelor.meta.MetaFiles;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.activation.DataSource;
import javax.mail.AuthenticationFailedException;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailAccountServiceImpl
implements MailAccountService {
    private final Logger log = LoggerFactory.getLogger(MailAccountServiceImpl.class);
    static final int CHECK_CONF_TIMEOUT = 5000;
    @Inject
    protected EmailAccountRepository mailAccountRepo;
    @Inject
    private CipherService cipherService;
    @Inject
    protected EmailAddressRepository emailAddressRepo;
    @Inject
    private MessageRepository messageRepo;
    @Inject
    private MetaFiles metaFiles;

    @Override
    public void checkDefaultMailAccount(EmailAccount mailAccount) throws AxelorException {
        if (mailAccount.getIsDefault().booleanValue()) {
            Integer serverTypeSelect;
            String query = "self.isDefault = true";
            ArrayList params = Lists.newArrayList();
            if (mailAccount.getId() != null) {
                query = query + " AND self.id != ?1";
                params.add(mailAccount.getId());
            }
            if ((serverTypeSelect = mailAccount.getServerTypeSelect()) == 1) {
                query = query + " AND self.serverTypeSelect = 1 ";
            } else if (serverTypeSelect == 3 || serverTypeSelect == 2) {
                query = query + " AND (self.serverTypeSelect = 3 OR self.serverTypeSelect = 2) ";
            }
            Long count = this.mailAccountRepo.all().filter(query, params.toArray()).count();
            if (count > 0L) {
                throw new AxelorException(4, I18n.get((String)"There is already a default account"));
            }
        }
    }

    @Override
    public EmailAccount getDefaultSender() {
        return (EmailAccount)this.mailAccountRepo.all().filter("self.isDefault = true AND self.serverTypeSelect = ?1", new Object[]{1}).fetchOne();
    }

    @Override
    public EmailAccount getDefaultReader() {
        return (EmailAccount)this.mailAccountRepo.all().filter("self.isDefault = true AND (self.serverTypeSelect = ?1 OR self.serverTypeSelect = ?2)", new Object[]{3, 2}).fetchOne();
    }

    @Override
    public void checkMailAccountConfiguration(EmailAccount mailAccount) throws AxelorException, MessagingException {
        MailAccount account = this.getMailAccount(mailAccount);
        Session session = account.getSession();
        try {
            if (mailAccount.getServerTypeSelect().equals(1)) {
                Transport transport = session.getTransport(this.getProtocol(mailAccount));
                transport.connect(mailAccount.getHost(), mailAccount.getPort().intValue(), mailAccount.getLogin(), mailAccount.getPassword());
                transport.close();
            } else {
                session.getStore().connect();
            }
        }
        catch (AuthenticationFailedException e) {
            throw new AxelorException((Throwable)e, (Model)mailAccount, 4, I18n.get((String)"Incorrect login or password"));
        }
        catch (NoSuchProviderException e) {
            throw new AxelorException((Throwable)e, (Model)mailAccount, 4, I18n.get((String)"Unable to reach server. Please check Host,Port and SSL/TLS"));
        }
    }

    @Override
    public MailAccount getMailAccount(EmailAccount mailAccount) {
        String port;
        Integer serverType = mailAccount.getServerTypeSelect();
        String string = port = mailAccount.getPort() <= 0 ? null : mailAccount.getPort().toString();
        Object account = serverType == 1 ? new SmtpAccount(mailAccount.getHost(), port, mailAccount.getLogin(), this.getDecryptPassword(mailAccount.getPassword()), this.getSecurity(mailAccount)) : (serverType == 3 ? new ImapAccount(mailAccount.getHost(), mailAccount.getPort().toString(), mailAccount.getLogin(), this.getDecryptPassword(mailAccount.getPassword()), this.getSecurity(mailAccount)) : new Pop3Account(mailAccount.getHost(), mailAccount.getPort().toString(), mailAccount.getLogin(), this.getDecryptPassword(mailAccount.getPassword()), this.getSecurity(mailAccount)));
        account.setConnectionTimeout(5000);
        return account;
    }

    @Override
    public String getSecurity(EmailAccount mailAccount) {
        if (mailAccount.getSecuritySelect() == 1) {
            return "ssl";
        }
        if (mailAccount.getSecuritySelect() == 2) {
            return "starttls";
        }
        return null;
    }

    @Override
    public String getProtocol(EmailAccount mailAccount) {
        switch (mailAccount.getServerTypeSelect()) {
            case 1: {
                return "smtp";
            }
            case 3: {
                if (mailAccount.getSecuritySelect() == 1) {
                    return "imaps";
                }
                return "imap";
            }
            case 2: {
                return "pop3";
            }
        }
        return "";
    }

    @Override
    public String getSignature(EmailAccount mailAccount) {
        if (mailAccount != null && mailAccount.getSignature() != null) {
            return "\n " + mailAccount.getSignature();
        }
        return "";
    }

    @Override
    public int fetchEmails(EmailAccount mailAccount, boolean unseenOnly) throws MessagingException, IOException {
        javax.mail.Message[] messages;
        if (mailAccount == null) {
            return 0;
        }
        this.log.debug("Fetching emails from host: {}, port: {}, login: {} ", new Object[]{mailAccount.getHost(), mailAccount.getPort(), mailAccount.getLogin()});
        Object account = null;
        account = mailAccount.getServerTypeSelect().equals(3) ? new ImapAccount(mailAccount.getHost(), mailAccount.getPort().toString(), mailAccount.getLogin(), mailAccount.getPassword(), this.getSecurity(mailAccount)) : new Pop3Account(mailAccount.getHost(), mailAccount.getPort().toString(), mailAccount.getLogin(), mailAccount.getPassword(), this.getSecurity(mailAccount));
        MailReader reader = new MailReader((MailAccount)account);
        Store store = reader.getStore();
        Folder inbox = store.getFolder("INBOX");
        inbox.open(2);
        FetchProfile profile = new FetchProfile();
        if (unseenOnly) {
            FlagTerm unseen = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
            messages = inbox.search((SearchTerm)unseen);
        } else {
            messages = inbox.getMessages();
        }
        profile.add(FetchProfile.Item.ENVELOPE);
        inbox.fetch(messages, profile);
        this.log.debug("Total emails unseen: {}", (Object)messages.length);
        int count = 0;
        for (javax.mail.Message message : messages) {
            if (!(message instanceof MimeMessage)) continue;
            MailParser parser = new MailParser((MimeMessage)message);
            parser.parse();
            this.createMessage(mailAccount, parser, message.getSentDate());
            ++count;
        }
        this.log.debug("Total emails fetched: {}", (Object)count);
        return count;
    }

    @Transactional(rollbackOn={Exception.class})
    public Message createMessage(EmailAccount mailAccount, MailParser parser, Date date) throws MessagingException {
        Message message = new Message();
        message.setMailAccount(mailAccount);
        message.setTypeSelect(2);
        message.setMediaTypeSelect(2);
        message.setFromEmailAddress(this.getEmailAddress(parser.getFrom()));
        message.setCcEmailAddressSet(this.getEmailAddressSet(parser.getCc()));
        message.setBccEmailAddressSet(this.getEmailAddressSet(parser.getBcc()));
        message.setToEmailAddressSet(this.getEmailAddressSet(parser.getTo()));
        message.addReplyToEmailAddressSetItem(this.getEmailAddress(parser.getReplyTo()));
        message.setContent(parser.getHtml());
        message.setSubject(parser.getSubject());
        message.setSentDateT(DateTool.toLocalDateT((Date)date));
        message = (Message)this.messageRepo.save((Model)message);
        List attachments = parser.getAttachments();
        this.addAttachments(message, attachments);
        return message;
    }

    private EmailAddress getEmailAddress(InternetAddress address) {
        EmailAddress emailAddress = null;
        emailAddress = this.emailAddressRepo.findByAddress(address.getAddress());
        if (emailAddress == null) {
            emailAddress = new EmailAddress();
            emailAddress.setAddress(address.getAddress());
        }
        return emailAddress;
    }

    private Set<EmailAddress> getEmailAddressSet(List<InternetAddress> addresses) {
        HashSet<EmailAddress> addressSet = new HashSet<EmailAddress>();
        if (addresses == null) {
            return addressSet;
        }
        for (InternetAddress address : addresses) {
            EmailAddress emailAddress = this.getEmailAddress(address);
            addressSet.add(emailAddress);
        }
        return addressSet;
    }

    private void addAttachments(Message message, List<DataSource> attachments) {
        if (attachments == null) {
            return;
        }
        for (DataSource source : attachments) {
            try {
                InputStream stream = source.getInputStream();
                this.metaFiles.attach(stream, source.getName(), (Model)message);
            }
            catch (IOException e) {
                TraceBackService.trace((Throwable)e);
            }
        }
    }

    @Override
    public String getEncryptPassword(String password) {
        return this.cipherService.encrypt(password);
    }

    @Override
    public String getDecryptPassword(String password) {
        return this.cipherService.decrypt(password);
    }
}

