/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.service;

import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.repo.EmailAccountRepository;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.service.MailAccountService;
import com.axelor.apps.message.service.MessageService;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.JPA;
import com.axelor.db.JpaSupport;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.mail.MailAccount;
import com.axelor.mail.MailBuilder;
import com.axelor.mail.MailSender;
import com.axelor.mail.SmtpAccount;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaAttachment;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaAttachmentRepository;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageServiceImpl
extends JpaSupport
implements MessageService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private MetaAttachmentRepository metaAttachmentRepository;
    protected MessageRepository messageRepository;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private static final int ENTITY_FIND_TIMEOUT = 10000;
    private static final int ENTITY_FIND_INTERVAL = 200;

    @Inject
    public MessageServiceImpl(MetaAttachmentRepository metaAttachmentRepository, MessageRepository messageRepository) {
        this.metaAttachmentRepository = metaAttachmentRepository;
        this.messageRepository = messageRepository;
    }

    @Override
    @Transactional
    public Message createMessage(String model, int id, String subject, String content, EmailAddress fromEmailAddress, List<EmailAddress> replyToEmailAddressList, List<EmailAddress> toEmailAddressList, List<EmailAddress> ccEmailAddressList, List<EmailAddress> bccEmailAddressList, Set<MetaFile> metaFiles, String addressBlock, int mediaTypeSelect, EmailAccount emailAccount) {
        emailAccount = emailAccount != null ? (EmailAccount)((EmailAccountRepository)((Object)Beans.get(EmailAccountRepository.class))).find(emailAccount.getId()) : emailAccount;
        Message message = this.createMessage(content, fromEmailAddress, model, id, null, 0L, false, 1, subject, 2, replyToEmailAddressList, toEmailAddressList, ccEmailAddressList, bccEmailAddressList, addressBlock, mediaTypeSelect, emailAccount);
        this.messageRepository.save((Model)message);
        this.attachMetaFiles(message, metaFiles);
        return message;
    }

    @Override
    @Transactional
    public void attachMetaFiles(Message message, Set<MetaFile> metaFiles) {
        Preconditions.checkNotNull((Object)message.getId());
        if (metaFiles == null || metaFiles.isEmpty()) {
            return;
        }
        this.log.debug("Add metafiles to object {}:{}", (Object)Message.class.getName(), (Object)message.getId());
        for (MetaFile metaFile : metaFiles) {
            ((MetaFiles)Beans.get(MetaFiles.class)).attach(metaFile, metaFile.getFileName(), (Model)message);
        }
    }

    protected Message createMessage(String content, EmailAddress fromEmailAddress, String relatedTo1Select, long relatedTo1SelectId, String relatedTo2Select, long relatedTo2SelectId, boolean sentByEmail, int statusSelect, String subject, int typeSelect, List<EmailAddress> replyToEmailAddressList, List<EmailAddress> toEmailAddressList, List<EmailAddress> ccEmailAddressList, List<EmailAddress> bccEmailAddressList, String addressBlock, int mediaTypeSelect, EmailAccount emailAccount) {
        HashSet replyToEmailAddressSet = Sets.newHashSet();
        HashSet bccEmailAddressSet = Sets.newHashSet();
        HashSet toEmailAddressSet = Sets.newHashSet();
        HashSet ccEmailAddressSet = Sets.newHashSet();
        if (mediaTypeSelect == 2) {
            if (replyToEmailAddressList != null) {
                replyToEmailAddressSet.addAll(replyToEmailAddressList);
            }
            if (bccEmailAddressList != null) {
                bccEmailAddressSet.addAll(bccEmailAddressList);
            }
            if (toEmailAddressList != null) {
                toEmailAddressSet.addAll(toEmailAddressList);
            }
            if (ccEmailAddressList != null) {
                ccEmailAddressSet.addAll(ccEmailAddressList);
            }
        }
        if (emailAccount != null) {
            content = content + "<p></p><p></p>" + ((MailAccountService)Beans.get(MailAccountService.class)).getSignature(emailAccount);
        }
        Message message = new Message(typeSelect, subject, content, statusSelect, mediaTypeSelect, addressBlock, fromEmailAddress, replyToEmailAddressSet, toEmailAddressSet, ccEmailAddressSet, bccEmailAddressSet, sentByEmail, emailAccount);
        message.setRelatedTo1Select(relatedTo1Select);
        message.setRelatedTo1SelectId(relatedTo1SelectId);
        message.setRelatedTo2Select(relatedTo2Select);
        message.setRelatedTo2SelectId(relatedTo2SelectId);
        return message;
    }

    @Override
    public Message sendMessage(Message message) throws AxelorException {
        try {
            message.setStatusSelect(2);
            if (message.getMediaTypeSelect() == 1) {
                return this.sendByMail(message);
            }
            if (message.getMediaTypeSelect() == 2) {
                return this.sendByEmail(message);
            }
            if (message.getMediaTypeSelect() == 3) {
                return this.sendToUser(message);
            }
        }
        catch (MessagingException e) {
            TraceBackService.trace((Throwable)e);
        }
        return message;
    }

    @Override
    @Transactional
    public Message sendToUser(Message message) {
        if (message.getRecipientUser() == null) {
            return message;
        }
        message.setSenderUser(AuthUtils.getUser());
        this.log.debug("Sent internal message to user ::: {}", (Object)message.getRecipientUser());
        message.setStatusSelect(3);
        message.setSentByEmail(false);
        message.setSentDateT(LocalDateTime.now());
        return (Message)this.messageRepository.save((Model)message);
    }

    @Override
    @Transactional
    public Message sendByMail(Message message) {
        this.log.debug("Sent mail");
        message.setStatusSelect(3);
        message.setSentByEmail(false);
        message.setSentDateT(LocalDateTime.now());
        return (Message)this.messageRepository.save((Model)message);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Message sendByEmail(Message message) throws MessagingException, AxelorException {
        EmailAccount mailAccount = message.getMailAccount();
        if (mailAccount == null) {
            return message;
        }
        this.log.debug("Sent email");
        MailAccountService mailAccountService = (MailAccountService)Beans.get(MailAccountService.class);
        SmtpAccount account = new SmtpAccount(mailAccount.getHost(), mailAccount.getPort().toString(), mailAccount.getLogin(), mailAccountService.getDecryptPassword(mailAccount.getPassword()), mailAccountService.getSecurity(mailAccount));
        List<String> replytoRecipients = this.getEmailAddresses(message.getReplyToEmailAddressSet());
        List<String> toRecipients = this.getEmailAddresses(message.getToEmailAddressSet());
        List<String> ccRecipients = this.getEmailAddresses(message.getCcEmailAddressSet());
        List<String> bccRecipients = this.getEmailAddresses(message.getBccEmailAddressSet());
        if (toRecipients.isEmpty() && ccRecipients.isEmpty() && bccRecipients.isEmpty()) {
            throw new AxelorException((Model)message, 4, I18n.get((String)"TO/CC/BCC recipient's email address is empty"));
        }
        MailSender sender = new MailSender((MailAccount)account);
        MailBuilder mailBuilder = sender.compose();
        mailBuilder.subject(message.getSubject());
        if (message.getFromEmailAddress() != null) {
            if (!Strings.isNullOrEmpty((String)message.getFromEmailAddress().getAddress())) {
                this.log.debug("Override from :::  {}", (Object)this.getFullEmailAddress(message.getFromEmailAddress()));
                mailBuilder.from(this.getFullEmailAddress(message.getFromEmailAddress()));
            } else {
                throw new AxelorException((Model)message, 4, "Sender's email address is null or empty");
            }
        }
        if (replytoRecipients != null && !replytoRecipients.isEmpty()) {
            mailBuilder.replyTo(new String[]{Joiner.on((String)",").join(replytoRecipients)});
        }
        if (toRecipients != null && !toRecipients.isEmpty()) {
            mailBuilder.to(new String[]{Joiner.on((String)",").join(toRecipients)});
        }
        if (ccRecipients != null && !ccRecipients.isEmpty()) {
            mailBuilder.cc(new String[]{Joiner.on((String)",").join(ccRecipients)});
        }
        if (bccRecipients != null && !bccRecipients.isEmpty()) {
            mailBuilder.bcc(new String[]{Joiner.on((String)",").join(bccRecipients)});
        }
        if (!Strings.isNullOrEmpty((String)message.getContent())) {
            mailBuilder.html(message.getContent());
        }
        for (MetaAttachment metaAttachment : this.getMetaAttachments(message)) {
            MetaFile metaFile = metaAttachment.getMetaFile();
            mailBuilder.attach(metaFile.getFileName(), MetaFiles.getPath((MetaFile)metaFile).toString());
        }
        this.getEntityManager().flush();
        this.executor.submit(() -> {
            try {
                Message updateMessage = this.findMessage(message);
                mailBuilder.send();
                this.inTransaction(() -> {
                    updateMessage.setSentByEmail(true);
                    updateMessage.setStatusSelect(3);
                    updateMessage.setSentDateT(LocalDateTime.now());
                    updateMessage.setSenderUser(AuthUtils.getUser());
                    this.messageRepository.save((Model)updateMessage);
                });
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)e);
            }
            return true;
        });
        return message;
    }

    private Message findMessage(Message message) throws InterruptedException, TimeoutException {
        Message foundMessage;
        long startTime = System.currentTimeMillis();
        while ((foundMessage = (Message)this.messageRepository.find(message.getId())) == null) {
            if (System.currentTimeMillis() - startTime > 10000L) {
                throw new TimeoutException(String.format("Cannot find message: %s", new Object[]{message}));
            }
            Thread.sleep(200L);
        }
        return foundMessage;
    }

    @Override
    public Set<MetaAttachment> getMetaAttachments(Message message) {
        Query query = this.metaAttachmentRepository.all().filter("self.objectId = ?1 AND self.objectName = ?2", new Object[]{message.getId(), Message.class.getName()});
        return Sets.newHashSet((Iterable)query.fetch());
    }

    public List<String> getEmailAddresses(Set<EmailAddress> emailAddressSet) {
        ArrayList recipients = Lists.newArrayList();
        if (emailAddressSet != null) {
            for (EmailAddress emailAddress : emailAddressSet) {
                if (Strings.isNullOrEmpty((String)emailAddress.getAddress())) continue;
                recipients.add(this.getFullEmailAddress(emailAddress));
            }
        }
        return recipients;
    }

    @Override
    public String printMessage(Message message) throws AxelorException {
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Message regenerateMessage(Message message) throws Exception {
        Preconditions.checkNotNull((Object)((Object)message.getTemplate()), (Object)I18n.get((String)"Cannot regenerate message without template associated to message."));
        Preconditions.checkNotNull((Object)message.getRelatedTo1Select(), (Object)I18n.get((String)"Cannot regenerate message without related model."));
        Class<?> m = Class.forName(message.getRelatedTo1Select());
        Model model = JPA.all(m).filter("self.id = ?", new Object[]{message.getRelatedTo1SelectId()}).fetchOne();
        Message newMessage = ((TemplateMessageService)Beans.get(TemplateMessageService.class)).generateMessage(model, message.getTemplate());
        newMessage.setRelatedTo2Select(message.getRelatedTo2Select());
        newMessage.setRelatedTo2SelectId(message.getRelatedTo2SelectId());
        message.setArchived(true);
        return newMessage;
    }

    @Override
    public String getFullEmailAddress(EmailAddress emailAddress) {
        return emailAddress.getAddress();
    }
}

