/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.service;

import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.db.TemplateContext;
import com.axelor.apps.message.db.repo.EmailAddressRepository;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.db.repo.TemplateRepository;
import com.axelor.apps.message.service.MailAccountService;
import com.axelor.apps.message.service.MessageService;
import com.axelor.apps.message.service.TemplateContextService;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.dms.db.DMSFile;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaJsonModel;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.meta.db.MetaModel;
import com.axelor.rpc.Context;
import com.axelor.tool.template.TemplateMaker;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateMessageServiceImpl
implements TemplateMessageService {
    private static final String RECIPIENT_SEPARATOR = ";|,";
    private static final char TEMPLATE_DELIMITER = '$';
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected TemplateMaker maker = new TemplateMaker(Locale.FRENCH, '$', '$');
    protected MessageService messageService;
    protected TemplateContextService templateContextService;

    @Inject
    public TemplateMessageServiceImpl(MessageService messageService, TemplateContextService templateContextService) {
        this.messageService = messageService;
        this.templateContextService = templateContextService;
    }

    @Override
    public Message generateMessage(Model model, Template template) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxelorException, IOException {
        Class klass = EntityHelper.getEntityClass((Object)model);
        return this.generateMessage(model.getId(), klass.getCanonicalName(), klass.getSimpleName(), template);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Message generateMessage(Long objectId, String model, String tag, Template template) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxelorException, IOException {
        MetaJsonModel modelObj;
        Object object = modelObj = template.getIsJson() != false ? template.getMetaJsonModel() : template.getMetaModel();
        if (modelObj != null) {
            String modelName;
            String string = modelName = template.getIsJson() != false ? modelObj.getName() : ((MetaModel)modelObj).getFullName();
            if (!model.equals(modelName)) {
                throw new AxelorException(5, String.format(I18n.get((String)"The email template model (%s) is different than the entity generating the email (%s)"), modelName, model));
            }
            this.initMaker(objectId, model, tag, template.getIsJson());
            this.computeTemplateContexts(template.getTemplateContextList(), objectId, model, template.getIsJson());
        }
        this.log.debug("model : {}", (Object)model);
        this.log.debug("tag : {}", (Object)tag);
        this.log.debug("object id : {}", (Object)objectId);
        this.log.debug("template : {}", (Object)template);
        String content = "";
        String subject = "";
        String from = "";
        String replyToRecipients = "";
        String toRecipients = "";
        String ccRecipients = "";
        String bccRecipients = "";
        String addressBlock = "";
        if (!Strings.isNullOrEmpty((String)template.getContent())) {
            this.maker.setTemplate(template.getContent());
            content = this.maker.make();
        }
        if (!Strings.isNullOrEmpty((String)template.getAddressBlock())) {
            this.maker.setTemplate(template.getAddressBlock());
            addressBlock = this.maker.make();
        }
        if (!Strings.isNullOrEmpty((String)template.getSubject())) {
            this.maker.setTemplate(template.getSubject());
            subject = this.maker.make();
            this.log.debug("Subject ::: {}", (Object)subject);
        }
        if (!Strings.isNullOrEmpty((String)template.getFromAdress())) {
            this.maker.setTemplate(template.getFromAdress());
            from = this.maker.make();
            this.log.debug("From ::: {}", (Object)from);
        }
        if (!Strings.isNullOrEmpty((String)template.getReplyToRecipients())) {
            this.maker.setTemplate(template.getReplyToRecipients());
            replyToRecipients = this.maker.make();
            this.log.debug("Reply to ::: {}", (Object)replyToRecipients);
        }
        if (template.getToRecipients() != null) {
            this.maker.setTemplate(template.getToRecipients());
            toRecipients = this.maker.make();
            this.log.debug("To ::: {}", (Object)toRecipients);
        }
        if (template.getCcRecipients() != null) {
            this.maker.setTemplate(template.getCcRecipients());
            ccRecipients = this.maker.make();
            this.log.debug("CC ::: {}", (Object)ccRecipients);
        }
        if (template.getBccRecipients() != null) {
            this.maker.setTemplate(template.getBccRecipients());
            bccRecipients = this.maker.make();
            this.log.debug("BCC ::: {}", (Object)bccRecipients);
        }
        int mediaTypeSelect = this.getMediaTypeSelect(template);
        this.log.debug("Media ::: {}", (Object)mediaTypeSelect);
        this.log.debug("Content ::: {}", (Object)content);
        Message message = this.messageService.createMessage(model, Math.toIntExact(objectId), subject, content, this.getEmailAddress(from), this.getEmailAddresses(replyToRecipients), this.getEmailAddresses(toRecipients), this.getEmailAddresses(ccRecipients), this.getEmailAddresses(bccRecipients), null, addressBlock, mediaTypeSelect, this.getMailAccount());
        message.setTemplate((Template)((TemplateRepository)((Object)Beans.get(TemplateRepository.class))).find(template.getId()));
        message = (Message)((MessageRepository)((Object)Beans.get(MessageRepository.class))).save((Model)message);
        this.messageService.attachMetaFiles(message, this.getMetaFiles(template));
        return message;
    }

    @Override
    public Message generateAndSendMessage(Model model, Template template) throws MessagingException, IOException, AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Message message = this.generateMessage(model, template);
        this.messageService.sendMessage(message);
        return message;
    }

    @Override
    public Set<MetaFile> getMetaFiles(Template template) throws AxelorException, IOException {
        List metaAttachments = Query.of(DMSFile.class).filter("self.relatedId = ?1 AND self.relatedModel = ?2", new Object[]{template.getId(), EntityHelper.getEntityClass((Object)((Object)template)).getName()}).fetch();
        HashSet metaFiles = Sets.newHashSet();
        for (DMSFile metaAttachment : metaAttachments) {
            if (metaAttachment.getIsDirectory().booleanValue()) continue;
            metaFiles.add(metaAttachment.getMetaFile());
        }
        this.log.debug("Metafile to attach: {}", (Object)metaFiles);
        return metaFiles;
    }

    @Override
    public TemplateMaker initMaker(long objectId, String model, String tag, boolean isJson) throws ClassNotFoundException {
        if (isJson) {
            this.maker.setContext(JPA.find(MetaJsonRecord.class, (Long)objectId), tag);
        } else {
            Class<?> myClass = Class.forName(model);
            this.maker.setContext(JPA.find(myClass, (Long)objectId), tag);
        }
        return this.maker;
    }

    protected TemplateMaker computeTemplateContexts(List<TemplateContext> templateContextList, long objectId, String model, boolean isJson) throws ClassNotFoundException {
        if (templateContextList == null) {
            return this.maker;
        }
        Context context = null;
        if (isJson) {
            context = new Context(Long.valueOf(objectId), MetaJsonRecord.class);
        } else {
            Class<?> myClass = Class.forName(model);
            context = new Context(Long.valueOf(objectId), myClass);
        }
        for (TemplateContext templateContext : templateContextList) {
            Object result = this.templateContextService.computeTemplateContext(templateContext, context);
            this.maker.addContext(templateContext.getName(), result);
        }
        return this.maker;
    }

    protected List<EmailAddress> getEmailAddresses(String recipients) {
        ArrayList emailAddressList = Lists.newArrayList();
        if (Strings.isNullOrEmpty((String)recipients)) {
            return emailAddressList;
        }
        for (String recipient : Splitter.onPattern((String)RECIPIENT_SEPARATOR).trimResults().omitEmptyStrings().splitToList((CharSequence)recipients)) {
            emailAddressList.add(this.getEmailAddress(recipient));
        }
        return emailAddressList;
    }

    protected EmailAddress getEmailAddress(String recipient) {
        if (Strings.isNullOrEmpty((String)recipient)) {
            return null;
        }
        EmailAddressRepository emailAddressRepo = (EmailAddressRepository)((Object)Beans.get(EmailAddressRepository.class));
        EmailAddress emailAddress = emailAddressRepo.findByAddress(recipient);
        if (emailAddress == null) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("address", recipient);
            emailAddress = (EmailAddress)emailAddressRepo.create(values);
        }
        return emailAddress;
    }

    protected Integer getMediaTypeSelect(Template template) {
        return template.getMediaTypeSelect();
    }

    protected EmailAccount getMailAccount() {
        EmailAccount mailAccount = ((MailAccountService)Beans.get(MailAccountService.class)).getDefaultSender();
        if (mailAccount != null) {
            this.log.debug("Email account ::: {}", (Object)mailAccount);
            return mailAccount;
        }
        return null;
    }
}

