/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.service;

import com.axelor.apps.message.db.Template;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.db.MetaModel;
import com.axelor.tool.template.TemplateMaker;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

@Singleton
public class TemplateService {
    public void checkTargetReceptor(Template template) throws AxelorException {
        String target = template.getTarget();
        MetaModel metaModel = template.getMetaModel();
        if (Strings.isNullOrEmpty((String)target)) {
            return;
        }
        if (metaModel == null) {
            throw new AxelorException(1, I18n.get((String)"Model empty. Please configure a model."));
        }
        try {
            this.validTarget(target, metaModel);
        }
        catch (Exception e) {
            throw new AxelorException(e.getCause(), 5, I18n.get((String)"Your target receptor is not valid. Please check it."));
        }
    }

    private void validTarget(String target, MetaModel metaModel) throws ClassNotFoundException {
        Iterator iter = Splitter.on((String)".").split((CharSequence)target).iterator();
        Property p = Mapper.of(Class.forName(metaModel.getFullName())).getProperty((String)iter.next());
        while (iter.hasNext() && p != null) {
            p = Mapper.of((Class)p.getTarget()).getProperty((String)iter.next());
        }
        if (p == null) {
            throw new IllegalArgumentException();
        }
    }

    public String processSubject(Template template, Model bean, String beanName, Map<String, Object> context) {
        TemplateMaker maker = new TemplateMaker(new Locale("fr"), '$', '$');
        maker.setTemplate(template.getSubject());
        maker.setContext(bean, context, beanName);
        return maker.make();
    }

    public String processContent(Template template, Model bean, String beanName, Map<String, Object> context) {
        TemplateMaker maker = new TemplateMaker(new Locale("fr"), '$', '$');
        maker.setTemplate(template.getContent());
        maker.setContext(bean, context, beanName);
        return maker.make();
    }
}

