/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.web;

import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.service.MessageService;
import com.axelor.apps.tool.ModelTool;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;

@Singleton
public class MessageController {
    public void sendMessage(ActionRequest request, ActionResponse response) {
        Message message = (Message)((Object)request.getContext().asType(Message.class));
        try {
            ((MessageService)Beans.get(MessageService.class)).sendMessage((Message)((MessageRepository)((Object)Beans.get(MessageRepository.class))).find(message.getId()));
            response.setReload(true);
            response.setFlash(I18n.get((String)"Email sending is in progress"));
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void sendMessages(ActionRequest request, ActionResponse response) {
        List idList = (List)request.getContext().get((Object)"_ids");
        try {
            if (idList == null) {
                throw new AxelorException(1, I18n.get((String)"Please select one or more messages."));
            }
            ModelTool.apply(Message.class, (Collection)idList, model -> ((MessageService)Beans.get(MessageService.class)).sendMessage((Message)((Object)model)));
            response.setFlash(String.format(I18n.get((String)"Email sending is in progress for %d messages."), idList.size()));
            response.setReload(true);
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void regenerateMessages(ActionRequest request, ActionResponse response) {
        List idList = (List)request.getContext().get((Object)"_ids");
        try {
            if (idList == null) {
                throw new AxelorException(1, I18n.get((String)"Please select one or more messages."));
            }
            int error = ModelTool.apply(Message.class, (Collection)idList, model -> ((MessageService)Beans.get(MessageService.class)).regenerateMessage((Message)((Object)model)));
            response.setFlash(String.format(I18n.get((String)"%d messages has been regenerated successfully and %d errors append."), idList.size() - error, error));
            response.setReload(true);
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

